/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.cli.resources;

import java.io.IOException;
import java.util.Map;
import java.util.Optional;
import org.aesh.command.shell.Shell;
import org.infinispan.cli.logging.Messages;
import org.infinispan.cli.printers.CacheEntryRowPrinter;
import org.infinispan.cli.printers.PrettyPrinter;
import org.infinispan.cli.resources.AbstractResource;
import org.infinispan.cli.resources.CacheKeyResource;
import org.infinispan.cli.resources.CachesResource;
import org.infinispan.cli.resources.Resource;
import org.infinispan.cli.util.TransformingIterable;

public class CacheResource
extends AbstractResource {
    public CacheResource(CachesResource parent, String name) {
        super(parent, name);
    }

    public Iterable<String> getChildrenNames(int limit) throws IOException {
        Iterable<Map<String, String>> keys = this.getConnection().getCacheKeys(this.getParent().getParent().getName(), this.name, limit);
        return new TransformingIterable<Map<String, String>, String>(keys, TransformingIterable.SINGLETON_MAP_VALUE);
    }

    @Override
    public void printChildren(Resource.ListFormat format, int limit, PrettyPrinter.PrettyPrintMode prettyPrintMode, Shell shell) throws IOException {
        Iterable<Map<String, String>> it;
        CacheEntryRowPrinter rowPrinter = switch (format) {
            case Resource.ListFormat.NAMES -> {
                it = this.getConnection().getCacheKeys(this.getParent().getParent().getName(), this.name, limit);
                yield new CacheEntryRowPrinter(shell.size().getWidth(), 1);
            }
            case Resource.ListFormat.VALUES -> {
                it = this.getConnection().getCacheEntries(this.getParent().getParent().getName(), this.name, limit, false);
                yield new CacheEntryRowPrinter(shell.size().getWidth(), 2);
            }
            case Resource.ListFormat.FULL -> {
                it = this.getConnection().getCacheEntries(this.getParent().getParent().getName(), this.name, limit, true);
                yield new CacheEntryRowPrinter(shell.size().getWidth(), 7);
            }
            default -> throw Messages.MSG.unsupportedListFormat(format);
        };
        try (PrettyPrinter printer = PrettyPrinter.forMode(prettyPrintMode, shell, rowPrinter);){
            printer.print(it);
        }
    }

    @Override
    public boolean isLeaf() {
        return true;
    }

    @Override
    public Resource getChild(String name) {
        if ("..".equals(name)) {
            return this.parent;
        }
        return new CacheKeyResource(this, name);
    }

    @Override
    public String describe() throws IOException {
        return this.getConnection().describeCache(this.getParent().getParent().getName(), this.name);
    }

    public static String cacheName(Resource resource) {
        return resource.findAncestor(CacheResource.class).getName();
    }

    public static Optional<String> findCacheName(Resource resource) {
        return resource.optionalFindAncestor(CacheResource.class).map(AbstractResource::getName);
    }
}

