/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.cli.util.aesh.graal;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Stream;
import org.aesh.command.Command;
import org.aesh.command.container.CommandContainer;
import org.aesh.command.impl.container.AeshCommandContainerBuilder;
import org.aesh.command.impl.internal.ProcessedCommand;
import org.aesh.command.impl.internal.ProcessedOption;
import org.aesh.command.impl.parser.AeshOptionParser;
import org.aesh.command.impl.parser.CommandLineParser;
import org.aesh.command.invocation.CommandInvocation;
import org.infinispan.cli.commands.Batch;
import org.infinispan.cli.commands.CLI;
import org.infinispan.cli.commands.kubernetes.Kube;
import org.infinispan.cli.impl.ExitCodeResultHandler;
import org.infinispan.cli.logging.Messages_$bundle;
import org.infinispan.commons.graalvm.ReflectiveClass;
import org.infinispan.commons.logging.Log_;
import org.wildfly.security.password.impl.PasswordFactorySpiImpl;

public class NativeMetadataProvider
implements org.infinispan.commons.graalvm.NativeMetadataProvider {
    final List<ReflectiveClass> classes = new ArrayList<ReflectiveClass>();

    public NativeMetadataProvider() {
        this.loadCommand(Batch.class);
        this.loadCommand(CLI.class);
        this.loadCommand(Kube.class);
        this.classes.addAll(List.of(ReflectiveClass.of(ExitCodeResultHandler.class), ReflectiveClass.of(Messages_$bundle.class), ReflectiveClass.of(Log_.logger.class), ReflectiveClass.of(AeshOptionParser.class), ReflectiveClass.of(PasswordFactorySpiImpl.class)));
    }

    public Stream<ReflectiveClass> reflectiveClasses() {
        return this.classes.stream();
    }

    private void loadCommand(Class<?> cmd) {
        Class<?> clazz = cmd;
        AeshCommandContainerBuilder builder = new AeshCommandContainerBuilder();
        try (CommandContainer container = builder.create(clazz);){
            this.addCommandClasses(container.getParser());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private void addCommandClasses(CommandLineParser<CommandInvocation<?>> parser) {
        this.addCommandClasses(parser.getProcessedCommand());
        if (parser.isGroupCommand()) {
            for (CommandLineParser child : parser.getAllChildParsers()) {
                this.addCommandClasses(child);
            }
        }
    }

    private void addCommandClasses(ProcessedCommand<Command<CommandInvocation<?>>, CommandInvocation<?>> command) {
        Class clazz = command.getCommand().getClass();
        if (command.getActivator() != null) {
            this.classes.add(ReflectiveClass.of((Class)command.getActivator().getClass()));
        }
        ArrayList<ProcessedOption> allArgumentsAndOptions = new ArrayList<ProcessedOption>(command.getOptions());
        if (command.getArguments() != null) {
            allArgumentsAndOptions.add(command.getArguments());
        }
        if (command.getArgument() != null) {
            allArgumentsAndOptions.add(command.getArgument());
        }
        Field[] fields = new Field[allArgumentsAndOptions.size()];
        for (int i = 0; i < fields.length; ++i) {
            ProcessedOption option = (ProcessedOption)allArgumentsAndOptions.get(i);
            try {
                fields[i] = this.getField(clazz, option.getFieldName());
            }
            catch (NoSuchFieldException e) {
                throw new RuntimeException(String.format("Unable to process command '%s'", clazz.getName()), e);
            }
            if (option.completer() != null) {
                this.classes.add(ReflectiveClass.of((Class)option.completer().getClass(), (boolean)false, (boolean)true));
            }
            if (option.activator() != null) {
                this.classes.add(ReflectiveClass.of((Class)option.activator().getClass(), (boolean)false, (boolean)true));
            }
            if (option.converter() == null) continue;
            this.classes.add(ReflectiveClass.of((Class)option.converter().getClass(), (boolean)false, (boolean)true));
        }
        this.classes.add(new ReflectiveClass(clazz, (Constructor[])clazz.getDeclaredConstructors(), fields, clazz.getDeclaredMethods()));
    }

    Field getField(Class<?> clazz, String field) throws NoSuchFieldException {
        try {
            return clazz.getDeclaredField(field);
        }
        catch (NoSuchFieldException e) {
            if (clazz.getSuperclass() == Object.class) {
                throw e;
            }
            return this.getField(clazz.getSuperclass(), field);
        }
    }
}

