/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.cli.commands.rest;

import java.io.File;
import java.util.List;
import java.util.concurrent.CompletionStage;
import org.aesh.command.CommandDefinition;
import org.aesh.command.impl.completer.FileOptionCompleter;
import org.aesh.command.option.Arguments;
import org.aesh.command.option.Option;
import org.aesh.io.Resource;
import org.infinispan.cli.activators.ConnectionActivator;
import org.infinispan.cli.commands.rest.RestCliCommand;
import org.infinispan.cli.completers.CacheCompleter;
import org.infinispan.cli.completers.EncodingCompleter;
import org.infinispan.cli.impl.ContextAwareCommandInvocation;
import org.infinispan.cli.logging.Messages;
import org.infinispan.cli.resources.CacheResource;
import org.infinispan.client.rest.RestCacheClient;
import org.infinispan.client.rest.RestClient;
import org.infinispan.client.rest.RestEntity;
import org.infinispan.client.rest.RestResponse;
import org.infinispan.commons.dataconversion.MediaType;

@CommandDefinition(name="put", description="Puts an entry into the cache", activator=ConnectionActivator.class)
public class Put
extends RestCliCommand {
    @Arguments(required=true)
    List<String> args;
    @Option(completer=EncodingCompleter.class, shortName=101)
    String encoding;
    @Option(completer=CacheCompleter.class, shortName=99)
    String cache;
    @Option(completer=FileOptionCompleter.class, shortName=102)
    Resource file;
    @Option(shortName=108, defaultValue={"0"})
    long ttl;
    @Option(name="max-idle", shortName=105, defaultValue={"0"})
    long maxIdle;
    @Option(name="if-absent", shortName=97)
    boolean ifAbsent;
    @Option(shortName=104, hasValue=false, overrideRequired=true)
    protected boolean help;

    @Override
    public boolean isHelp() {
        return this.help;
    }

    @Override
    protected CompletionStage<RestResponse> exec(ContextAwareCommandInvocation invocation, RestClient client, org.infinispan.cli.resources.Resource resource) {
        RestEntity value;
        if (this.file != null && this.args.size() != 1) {
            throw Messages.MSG.illegalCommandArguments();
        }
        if (this.file == null && this.args.size() != 2) {
            throw Messages.MSG.illegalCommandArguments();
        }
        RestCacheClient cacheClient = client.cache(this.cache != null ? this.cache : CacheResource.cacheName(resource));
        MediaType putEncoding = this.encoding != null ? MediaType.fromString((String)this.encoding) : invocation.getContext().getEncoding();
        RestEntity restEntity = value = this.file != null ? RestEntity.create((MediaType)putEncoding, (File)new File(this.file.getAbsolutePath())) : RestEntity.create((MediaType)putEncoding, (String)this.args.get(1));
        if (this.ifAbsent) {
            return cacheClient.post(this.args.get(0), value, this.ttl, this.maxIdle);
        }
        return cacheClient.put(this.args.get(0), value, this.ttl, this.maxIdle);
    }
}

