/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod.impl.operations;

import io.netty.buffer.ByteBuf;
import io.netty.channel.Channel;
import org.infinispan.client.hotrod.impl.operations.AbstractNoCacheHotRodOperation;
import org.infinispan.client.hotrod.impl.operations.CacheUnmarshaller;
import org.infinispan.client.hotrod.impl.protocol.Codec;
import org.infinispan.client.hotrod.impl.transport.netty.ByteBufUtil;
import org.infinispan.client.hotrod.impl.transport.netty.HeaderDecoder;

public class AuthOperation
extends AbstractNoCacheHotRodOperation<byte[]> {
    private final String saslMechanism;
    private final byte[] response;

    public AuthOperation(String saslMechanism, byte[] response) {
        this.saslMechanism = saslMechanism;
        this.response = response;
    }

    @Override
    public void writeOperationRequest(Channel channel, ByteBuf buf, Codec codec) {
        byte[] saslMechBytes = this.saslMechanism.getBytes(HOTROD_STRING_CHARSET);
        ByteBufUtil.writeArray(buf, saslMechBytes);
        ByteBufUtil.writeArray(buf, this.response);
    }

    @Override
    public byte[] createResponse(ByteBuf buf, short status, HeaderDecoder decoder, Codec codec, CacheUnmarshaller unmarshaller) {
        boolean complete = buf.readUnsignedByte() > 0;
        byte[] challenge = ByteBufUtil.readArray(buf);
        return complete ? null : challenge;
    }

    @Override
    public short requestOpCode() {
        return 35;
    }

    @Override
    public short responseOpCode() {
        return 36;
    }
}

