/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod.impl;

import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.function.BiFunction;
import java.util.function.Function;
import org.infinispan.client.hotrod.MetadataValue;
import org.infinispan.client.hotrod.RemoteCache;
import org.infinispan.client.hotrod.impl.Util;

public abstract class RemoteCacheSupport<K, V>
implements RemoteCache<K, V> {
    protected final long defaultLifespan;
    protected final long defaultMaxIdleTime;

    protected RemoteCacheSupport() {
        this(0L, 0L);
    }

    protected RemoteCacheSupport(long defaultLifespan, long defaultMaxIdleTime) {
        this.defaultLifespan = defaultLifespan;
        this.defaultMaxIdleTime = defaultMaxIdleTime;
    }

    @Override
    public final void putAll(Map<? extends K, ? extends V> map) {
        this.putAll(map, this.defaultLifespan, TimeUnit.MILLISECONDS, this.defaultMaxIdleTime, TimeUnit.MILLISECONDS);
    }

    @Override
    public final void putAll(Map<? extends K, ? extends V> map, long lifespan, TimeUnit unit) {
        this.putAll(map, lifespan, unit, this.defaultMaxIdleTime, TimeUnit.MILLISECONDS);
    }

    @Override
    public final void putAll(Map<? extends K, ? extends V> map, long lifespan, TimeUnit lifespanUnit, long maxIdleTime, TimeUnit maxIdleTimeUnit) {
        Util.await(this.putAllAsync(map, lifespan, lifespanUnit, maxIdleTime, maxIdleTimeUnit));
    }

    @Override
    public final CompletableFuture<Void> putAllAsync(Map<? extends K, ? extends V> data) {
        return this.putAllAsync(data, this.defaultLifespan, TimeUnit.MILLISECONDS, this.defaultMaxIdleTime, TimeUnit.MILLISECONDS);
    }

    @Override
    public final CompletableFuture<Void> putAllAsync(Map<? extends K, ? extends V> data, long lifespan, TimeUnit unit) {
        return this.putAllAsync(data, lifespan, unit, this.defaultMaxIdleTime, TimeUnit.MILLISECONDS);
    }

    @Override
    public abstract CompletableFuture<Void> putAllAsync(Map<? extends K, ? extends V> var1, long var2, TimeUnit var4, long var5, TimeUnit var7);

    public final V putIfAbsent(K key, V value) {
        return this.putIfAbsent(key, value, this.defaultLifespan, TimeUnit.MILLISECONDS, this.defaultMaxIdleTime, TimeUnit.MILLISECONDS);
    }

    public final V putIfAbsent(K key, V value, long lifespan, TimeUnit unit) {
        return this.putIfAbsent(key, value, lifespan, unit, this.defaultMaxIdleTime, TimeUnit.MILLISECONDS);
    }

    public final V putIfAbsent(K key, V value, long lifespan, TimeUnit lifespanUnit, long maxIdleTime, TimeUnit maxIdleTimeUnit) {
        return Util.await(this.putIfAbsentAsync(key, value, lifespan, lifespanUnit, maxIdleTime, maxIdleTimeUnit));
    }

    public final CompletableFuture<V> putIfAbsentAsync(K key, V value) {
        return this.putIfAbsentAsync(key, value, this.defaultLifespan, TimeUnit.MILLISECONDS, this.defaultMaxIdleTime, TimeUnit.MILLISECONDS);
    }

    public final CompletableFuture<V> putIfAbsentAsync(K key, V value, long lifespan, TimeUnit lifespanUnit) {
        return this.putIfAbsentAsync(key, value, lifespan, lifespanUnit, this.defaultMaxIdleTime, TimeUnit.MILLISECONDS);
    }

    public abstract CompletableFuture<V> putIfAbsentAsync(K var1, V var2, long var3, TimeUnit var5, long var6, TimeUnit var8);

    @Override
    public final boolean replace(K key, V oldValue, V newValue) {
        return this.replace(key, oldValue, newValue, this.defaultLifespan, TimeUnit.MILLISECONDS, this.defaultMaxIdleTime, TimeUnit.MILLISECONDS);
    }

    @Override
    public final boolean replace(K key, V oldValue, V value, long lifespan, TimeUnit unit) {
        return this.replace(key, oldValue, value, lifespan, unit, this.defaultMaxIdleTime, TimeUnit.MILLISECONDS);
    }

    @Override
    public final boolean replace(K key, V oldValue, V value, long lifespan, TimeUnit lifespanUnit, long maxIdleTime, TimeUnit maxIdleTimeUnit) {
        return Util.await(this.replaceAsync(key, oldValue, value, lifespan, lifespanUnit, maxIdleTime, maxIdleTimeUnit));
    }

    public final CompletableFuture<Boolean> replaceAsync(K key, V oldValue, V newValue) {
        return this.replaceAsync(key, oldValue, newValue, this.defaultLifespan, TimeUnit.MILLISECONDS);
    }

    public final CompletableFuture<Boolean> replaceAsync(K key, V oldValue, V newValue, long lifespan, TimeUnit unit) {
        return this.replaceAsync(key, oldValue, newValue, lifespan, unit, this.defaultMaxIdleTime, TimeUnit.MILLISECONDS);
    }

    public abstract CompletableFuture<Boolean> replaceAsync(K var1, V var2, V var3, long var4, TimeUnit var6, long var7, TimeUnit var9);

    public final V replace(K key, V value) {
        return this.replace(key, value, this.defaultLifespan, TimeUnit.MILLISECONDS, this.defaultMaxIdleTime, TimeUnit.MILLISECONDS);
    }

    public final V replace(K key, V value, long lifespan, TimeUnit unit) {
        return this.replace(key, value, lifespan, unit, this.defaultMaxIdleTime, TimeUnit.MILLISECONDS);
    }

    public final V replace(K key, V value, long lifespan, TimeUnit lifespanUnit, long maxIdleTime, TimeUnit maxIdleTimeUnit) {
        return Util.await(this.replaceAsync(key, value, lifespan, lifespanUnit, maxIdleTime, maxIdleTimeUnit));
    }

    public final CompletableFuture<V> replaceAsync(K key, V value) {
        return this.replaceAsync(key, value, this.defaultLifespan, TimeUnit.MILLISECONDS, this.defaultMaxIdleTime, TimeUnit.MILLISECONDS);
    }

    public final CompletableFuture<V> replaceAsync(K key, V value, long lifespan, TimeUnit unit) {
        return this.replaceAsync(key, value, lifespan, unit, this.defaultMaxIdleTime, TimeUnit.MILLISECONDS);
    }

    public abstract CompletableFuture<V> replaceAsync(K var1, V var2, long var3, TimeUnit var5, long var6, TimeUnit var8);

    public final V get(Object key) {
        return Util.await(this.getAsync(key));
    }

    public abstract CompletableFuture<V> getAsync(K var1);

    @Override
    public final Map<K, V> getAll(Set<? extends K> keys) {
        return Util.await(this.getAllAsync(keys));
    }

    public abstract CompletableFuture<Map<K, V>> getAllAsync(Set<?> var1);

    @Override
    public final MetadataValue<V> getWithMetadata(K key) {
        return Util.await(this.getWithMetadataAsync(key));
    }

    @Override
    public abstract CompletableFuture<MetadataValue<V>> getWithMetadataAsync(K var1);

    public final boolean containsKey(Object key) {
        return Util.await(this.containsKeyAsync(key));
    }

    public abstract CompletableFuture<Boolean> containsKeyAsync(K var1);

    public final V put(K key, V value) {
        return this.put(key, value, this.defaultLifespan, TimeUnit.MILLISECONDS, this.defaultMaxIdleTime, TimeUnit.MILLISECONDS);
    }

    public final V put(K key, V value, long lifespan, TimeUnit unit) {
        return this.put(key, value, lifespan, unit, this.defaultMaxIdleTime, TimeUnit.MILLISECONDS);
    }

    public final V put(K key, V value, long lifespan, TimeUnit lifespanUnit, long maxIdleTime, TimeUnit maxIdleTimeUnit) {
        return Util.await(this.putAsync(key, value, lifespan, lifespanUnit, maxIdleTime, maxIdleTimeUnit));
    }

    public final CompletableFuture<V> putAsync(K key, V value) {
        return this.putAsync(key, value, this.defaultLifespan, TimeUnit.MILLISECONDS, this.defaultMaxIdleTime, TimeUnit.MILLISECONDS);
    }

    public final CompletableFuture<V> putAsync(K key, V value, long lifespan, TimeUnit unit) {
        return this.putAsync(key, value, lifespan, unit, this.defaultMaxIdleTime, TimeUnit.MILLISECONDS);
    }

    public abstract CompletableFuture<V> putAsync(K var1, V var2, long var3, TimeUnit var5, long var6, TimeUnit var8);

    @Override
    public final boolean replaceWithVersion(K key, V newValue, long version) {
        return this.replaceWithVersion(key, newValue, version, 0);
    }

    @Override
    public final boolean replaceWithVersion(K key, V newValue, long version, int lifespanSeconds) {
        return this.replaceWithVersion(key, newValue, version, lifespanSeconds, 0);
    }

    @Override
    public final boolean replaceWithVersion(K key, V newValue, long version, int lifespanSeconds, int maxIdleTimeSeconds) {
        return this.replaceWithVersion(key, newValue, version, lifespanSeconds, TimeUnit.SECONDS, maxIdleTimeSeconds, TimeUnit.SECONDS);
    }

    @Override
    public final boolean replaceWithVersion(K key, V newValue, long version, long lifespan, TimeUnit lifespanTimeUnit, long maxIdle, TimeUnit maxIdleTimeUnit) {
        return Util.await(this.replaceWithVersionAsync(key, newValue, version, lifespan, lifespanTimeUnit, maxIdle, maxIdleTimeUnit));
    }

    @Override
    public final CompletableFuture<Boolean> replaceWithVersionAsync(K key, V newValue, long version) {
        return this.replaceWithVersionAsync(key, newValue, version, 0);
    }

    @Override
    public final CompletableFuture<Boolean> replaceWithVersionAsync(K key, V newValue, long version, int lifespanSeconds) {
        return this.replaceWithVersionAsync(key, newValue, version, lifespanSeconds, 0);
    }

    @Override
    public final CompletableFuture<Boolean> replaceWithVersionAsync(K key, V newValue, long version, int lifespanSeconds, int maxIdleSeconds) {
        return this.replaceWithVersionAsync(key, newValue, version, lifespanSeconds, TimeUnit.SECONDS, maxIdleSeconds, TimeUnit.SECONDS);
    }

    @Override
    public final V remove(Object key) {
        return Util.await(this.removeAsync(key));
    }

    public abstract CompletableFuture<V> removeAsync(Object var1);

    @Override
    public final boolean remove(Object key, Object value) {
        return Util.await(this.removeAsync(key, value));
    }

    public abstract CompletableFuture<Boolean> removeAsync(Object var1, Object var2);

    @Override
    public final boolean removeWithVersion(K key, long version) {
        return Util.await(this.removeWithVersionAsync(key, version));
    }

    @Override
    public abstract CompletableFuture<Boolean> removeWithVersionAsync(K var1, long var2);

    public final V merge(K key, V value, BiFunction<? super V, ? super V, ? extends V> remappingFunction) {
        return this.merge(key, value, remappingFunction, this.defaultLifespan, TimeUnit.MILLISECONDS, this.defaultMaxIdleTime, TimeUnit.MILLISECONDS);
    }

    public final V merge(K key, V value, BiFunction<? super V, ? super V, ? extends V> remappingFunction, long lifespan, TimeUnit lifespanUnit) {
        return this.merge(key, value, remappingFunction, lifespan, lifespanUnit, this.defaultMaxIdleTime, TimeUnit.MILLISECONDS);
    }

    public final V merge(K key, V value, BiFunction<? super V, ? super V, ? extends V> remappingFunction, long lifespan, TimeUnit lifespanUnit, long maxIdleTime, TimeUnit maxIdleTimeUnit) {
        return Util.await(this.mergeAsync(key, value, remappingFunction, lifespan, lifespanUnit, maxIdleTime, maxIdleTimeUnit));
    }

    public final CompletableFuture<V> mergeAsync(K key, V value, BiFunction<? super V, ? super V, ? extends V> remappingFunction) {
        return this.mergeAsync(key, value, remappingFunction, this.defaultLifespan, TimeUnit.MILLISECONDS, this.defaultMaxIdleTime, TimeUnit.MILLISECONDS);
    }

    public final CompletableFuture<V> mergeAsync(K key, V value, BiFunction<? super V, ? super V, ? extends V> remappingFunction, long lifespan, TimeUnit lifespanUnit) {
        return this.mergeAsync(key, value, remappingFunction, lifespan, lifespanUnit, this.defaultMaxIdleTime, TimeUnit.MILLISECONDS);
    }

    public abstract CompletableFuture<V> mergeAsync(K var1, V var2, BiFunction<? super V, ? super V, ? extends V> var3, long var4, TimeUnit var6, long var7, TimeUnit var9);

    public final void clear() {
        Util.await(this.clearAsync());
    }

    public final V compute(K key, BiFunction<? super K, ? super V, ? extends V> remappingFunction) {
        return this.compute(key, remappingFunction, this.defaultLifespan, TimeUnit.MILLISECONDS, this.defaultMaxIdleTime, TimeUnit.MILLISECONDS);
    }

    public final V compute(K key, BiFunction<? super K, ? super V, ? extends V> remappingFunction, long lifespan, TimeUnit lifespanUnit) {
        return this.compute(key, remappingFunction, lifespan, lifespanUnit, this.defaultMaxIdleTime, TimeUnit.MILLISECONDS);
    }

    public final V compute(K key, BiFunction<? super K, ? super V, ? extends V> remappingFunction, long lifespan, TimeUnit lifespanUnit, long maxIdleTime, TimeUnit maxIdleTimeUnit) {
        return Util.await(this.computeAsync(key, remappingFunction, lifespan, lifespanUnit, maxIdleTime, maxIdleTimeUnit));
    }

    public final CompletableFuture<V> computeAsync(K key, BiFunction<? super K, ? super V, ? extends V> remappingFunction) {
        return this.computeAsync(key, remappingFunction, this.defaultLifespan, TimeUnit.MILLISECONDS, this.defaultMaxIdleTime, TimeUnit.MILLISECONDS);
    }

    public final CompletableFuture<V> computeAsync(K key, BiFunction<? super K, ? super V, ? extends V> remappingFunction, long lifespan, TimeUnit lifespanUnit) {
        return this.computeAsync(key, remappingFunction, lifespan, lifespanUnit, this.defaultMaxIdleTime, TimeUnit.MILLISECONDS);
    }

    public abstract CompletableFuture<V> computeAsync(K var1, BiFunction<? super K, ? super V, ? extends V> var2, long var3, TimeUnit var5, long var6, TimeUnit var8);

    public final V computeIfAbsent(K key, Function<? super K, ? extends V> mappingFunction) {
        return this.computeIfAbsent(key, mappingFunction, this.defaultLifespan, TimeUnit.MILLISECONDS, this.defaultMaxIdleTime, TimeUnit.MILLISECONDS);
    }

    public final V computeIfAbsent(K key, Function<? super K, ? extends V> mappingFunction, long lifespan, TimeUnit lifespanUnit) {
        return this.computeIfAbsent(key, mappingFunction, lifespan, lifespanUnit, this.defaultMaxIdleTime, TimeUnit.MILLISECONDS);
    }

    public final V computeIfAbsent(K key, Function<? super K, ? extends V> mappingFunction, long lifespan, TimeUnit lifespanUnit, long maxIdleTime, TimeUnit maxIdleTimeUnit) {
        return Util.await(this.computeIfAbsentAsync(key, mappingFunction, lifespan, lifespanUnit, maxIdleTime, maxIdleTimeUnit));
    }

    public final CompletableFuture<V> computeIfAbsentAsync(K key, Function<? super K, ? extends V> mappingFunction) {
        return this.computeIfAbsentAsync(key, mappingFunction, this.defaultLifespan, TimeUnit.MILLISECONDS, this.defaultMaxIdleTime, TimeUnit.MILLISECONDS);
    }

    public final CompletableFuture<V> computeIfAbsentAsync(K key, Function<? super K, ? extends V> mappingFunction, long lifespan, TimeUnit lifespanUnit) {
        return this.computeIfAbsentAsync(key, mappingFunction, lifespan, lifespanUnit, this.defaultMaxIdleTime, TimeUnit.MILLISECONDS);
    }

    public abstract CompletableFuture<V> computeIfAbsentAsync(K var1, Function<? super K, ? extends V> var2, long var3, TimeUnit var5, long var6, TimeUnit var8);

    public final V computeIfPresent(K key, BiFunction<? super K, ? super V, ? extends V> remappingFunction) {
        return this.computeIfPresent(key, remappingFunction, this.defaultLifespan, TimeUnit.MILLISECONDS, this.defaultMaxIdleTime, TimeUnit.MILLISECONDS);
    }

    public final V computeIfPresent(K key, BiFunction<? super K, ? super V, ? extends V> remappingFunction, long lifespan, TimeUnit lifespanUnit) {
        return this.computeIfPresent(key, remappingFunction, lifespan, lifespanUnit, this.defaultMaxIdleTime, TimeUnit.MILLISECONDS);
    }

    public final V computeIfPresent(K key, BiFunction<? super K, ? super V, ? extends V> remappingFunction, long lifespan, TimeUnit lifespanUnit, long maxIdleTime, TimeUnit maxIdleTimeUnit) {
        return Util.await(this.computeIfPresentAsync(key, remappingFunction, lifespan, lifespanUnit, maxIdleTime, maxIdleTimeUnit));
    }

    public final CompletableFuture<V> computeIfPresentAsync(K key, BiFunction<? super K, ? super V, ? extends V> remappingFunction) {
        return this.computeIfPresentAsync(key, remappingFunction, this.defaultLifespan, TimeUnit.MILLISECONDS, this.defaultMaxIdleTime, TimeUnit.MILLISECONDS);
    }

    public final CompletableFuture<V> computeIfPresentAsync(K key, BiFunction<? super K, ? super V, ? extends V> remappingFunction, long lifespan, TimeUnit lifespanUnit) {
        return this.computeIfPresentAsync(key, remappingFunction, lifespan, lifespanUnit, this.defaultMaxIdleTime, TimeUnit.MILLISECONDS);
    }

    public abstract CompletableFuture<V> computeIfPresentAsync(K var1, BiFunction<? super K, ? super V, ? extends V> var2, long var3, TimeUnit var5, long var6, TimeUnit var8);

    public abstract void replaceAll(BiFunction<? super K, ? super V, ? extends V> var1);

    public final int size() {
        long size = Util.await(this.sizeAsync());
        return size > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)size;
    }

    public abstract CompletableFuture<Long> sizeAsync();
}

