/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod.impl;

import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.BiConsumer;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.infinispan.client.hotrod.CacheTopologyInfo;
import org.infinispan.client.hotrod.FailoverRequestBalancingStrategy;
import org.infinispan.client.hotrod.configuration.Configuration;
import org.infinispan.client.hotrod.impl.consistenthash.ConsistentHashFactory;
import org.infinispan.client.hotrod.impl.consistenthash.SegmentConsistentHash;
import org.infinispan.client.hotrod.impl.topology.CacheInfo;
import org.infinispan.client.hotrod.impl.topology.ClusterInfo;
import org.infinispan.client.hotrod.logging.Log;
import org.infinispan.client.hotrod.logging.LogFactory;

public final class TopologyInfo {
    private static final Log log = LogFactory.getLog(TopologyInfo.class);
    private static final String DEFAULT_CACHE_NAME = "<default>";
    private final Supplier<FailoverRequestBalancingStrategy> balancerFactory;
    private final ConsistentHashFactory hashFactory = new ConsistentHashFactory();
    private final ConcurrentMap<String, CacheInfo> caches = new ConcurrentHashMap<String, CacheInfo>();
    private volatile ClusterInfo cluster;

    public TopologyInfo(Configuration configuration, ClusterInfo clusterInfo) {
        this.balancerFactory = configuration.balancingStrategyFactory();
        this.hashFactory.init(configuration);
        this.cluster = clusterInfo.withTopologyAge(0);
    }

    static String nameOrDefault(String cacheName) {
        return cacheName != null ? cacheName : DEFAULT_CACHE_NAME;
    }

    public Map<SocketAddress, Set<Integer>> getPrimarySegmentsByServer(String cacheName) {
        CacheInfo cacheInfo = (CacheInfo)this.caches.get(TopologyInfo.nameOrDefault(cacheName));
        if (cacheInfo != null) {
            return cacheInfo.getPrimarySegments();
        }
        return Collections.emptyMap();
    }

    public List<InetSocketAddress> getServers(String cacheName) {
        return this.getCacheInfo(TopologyInfo.nameOrDefault(cacheName)).getServers();
    }

    public Collection<InetSocketAddress> getAllServers() {
        return this.caches.values().stream().flatMap(ct -> ct.getServers().stream()).collect(Collectors.toSet());
    }

    public SegmentConsistentHash createConsistentHash(int numSegments, short hashFunctionVersion, SocketAddress[][] segmentOwners) {
        SegmentConsistentHash hash = null;
        if (hashFunctionVersion > 0) {
            hash = (SegmentConsistentHash)this.hashFactory.newConsistentHash(hashFunctionVersion);
            if (hash == null) {
                Log.HOTROD.noHasHFunctionConfigured(hashFunctionVersion);
            } else {
                hash.init(segmentOwners, numSegments);
            }
        }
        return hash;
    }

    public ConsistentHashFactory getConsistentHashFactory() {
        return this.hashFactory;
    }

    public CacheTopologyInfo getCacheTopologyInfo(String cacheName) {
        return ((CacheInfo)this.caches.get(TopologyInfo.nameOrDefault(cacheName))).getCacheTopologyInfo();
    }

    public CacheInfo getCacheInfo(String cacheName) {
        return (CacheInfo)this.caches.get(TopologyInfo.nameOrDefault(cacheName));
    }

    public CacheInfo getOrCreateCacheInfo(String cacheName) {
        log.debugf("Caches are: %s with argument cacheName %s", this.caches, cacheName);
        return this.caches.computeIfAbsent(TopologyInfo.nameOrDefault(cacheName), cn -> {
            ClusterInfo cluster = this.cluster;
            CacheInfo cacheInfo = new CacheInfo((String)cn, this.balancerFactory.get(), cluster.getInitialServers(), cluster.getIntelligence());
            cacheInfo.updateBalancerServers();
            if (log.isTraceEnabled()) {
                log.tracef("Creating cache info %s", cacheInfo.getCacheName());
            }
            return cacheInfo;
        });
    }

    public void switchCluster(ClusterInfo newCluster) {
        ClusterInfo oldCluster = this.cluster;
        int newTopologyAge = oldCluster.getTopologyAge() + 1;
        if (log.isTraceEnabled()) {
            log.tracef("Switching cluster: %s -> %s with servers %s", oldCluster.getName(), newCluster.getName(), newCluster.getInitialServers());
        }
        this.caches.forEach((name, oldCacheInfo) -> {
            CacheInfo newCacheInfo = oldCacheInfo.withNewServers(-2, newCluster.getInitialServers(), newCluster.getIntelligence());
            this.updateCacheInfo((String)name, (CacheInfo)oldCacheInfo, newCacheInfo);
        });
        this.cluster = newCluster.withTopologyAge(newTopologyAge);
    }

    public void reset(String cacheName) {
        if (log.isTraceEnabled()) {
            log.tracef("Switching to initial server list for cache %s, cluster %s", cacheName, this.cluster.getName());
        }
        CacheInfo oldCacheInfo = (CacheInfo)this.caches.get(cacheName);
        CacheInfo newCacheInfo = oldCacheInfo.withNewServers(-1, this.cluster.getInitialServers(), this.cluster.getIntelligence());
        this.updateCacheInfo(cacheName, oldCacheInfo, newCacheInfo);
    }

    public ClusterInfo getCluster() {
        return this.cluster;
    }

    public int getTopologyAge() {
        return this.cluster.getTopologyAge();
    }

    public void updateCacheInfo(String cacheName, CacheInfo oldCacheInfo, CacheInfo newCacheInfo) {
        if (log.isTraceEnabled()) {
            log.tracef("Updating topology for %s: %s -> %s", newCacheInfo.getCacheName(), oldCacheInfo.getTopologyId(), newCacheInfo.getTopologyId());
        }
        CacheInfo existing = this.caches.put(cacheName, newCacheInfo);
        assert (existing == oldCacheInfo) : "Locking should have prevented concurrent updates";
        newCacheInfo.updateBalancerServers();
        newCacheInfo.updateClientTopologyRef();
    }

    public void forEachCache(BiConsumer<String, CacheInfo> action) {
        this.caches.forEach(action);
    }
}

