/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod.impl.multimap;

import java.util.Collection;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import org.infinispan.client.hotrod.RemoteCache;
import org.infinispan.client.hotrod.RemoteCacheManager;
import org.infinispan.client.hotrod.exceptions.RemoteCacheManagerNotStartedException;
import org.infinispan.client.hotrod.impl.InternalRemoteCache;
import org.infinispan.client.hotrod.impl.RemoteCacheImpl;
import org.infinispan.client.hotrod.impl.multimap.operations.DefaultMultimapOperationsFactory;
import org.infinispan.client.hotrod.impl.multimap.operations.MultimapOperationsFactory;
import org.infinispan.client.hotrod.impl.operations.HotRodOperation;
import org.infinispan.client.hotrod.impl.transport.netty.OperationDispatcher;
import org.infinispan.client.hotrod.logging.Log;
import org.infinispan.client.hotrod.logging.LogFactory;
import org.infinispan.client.hotrod.marshall.MarshallerUtil;
import org.infinispan.client.hotrod.multimap.MetadataCollection;
import org.infinispan.client.hotrod.multimap.RemoteMultimapCache;
import org.infinispan.commons.marshall.AdaptiveBufferSizePredictor;
import org.infinispan.commons.marshall.BufferSizePredictor;
import org.infinispan.commons.marshall.Marshaller;

public class RemoteMultimapCacheImpl<K, V>
implements RemoteMultimapCache<K, V> {
    private static final Log log = LogFactory.getLog(RemoteMultimapCacheImpl.class);
    private final InternalRemoteCache<K, Collection<V>> cache;
    private final RemoteCacheManager remoteCacheManager;
    private MultimapOperationsFactory operationsFactory;
    private OperationDispatcher dispatcher;
    private Marshaller marshaller;
    private final BufferSizePredictor keySizePredictor = new AdaptiveBufferSizePredictor();
    private final BufferSizePredictor valueSizePredictor = new AdaptiveBufferSizePredictor();
    private final boolean supportsDuplicates;

    public void init() {
        this.operationsFactory = new DefaultMultimapOperationsFactory(this.cache, this.remoteCacheManager.getMarshaller(), (BufferSizePredictor)new AdaptiveBufferSizePredictor(), (BufferSizePredictor)new AdaptiveBufferSizePredictor());
        this.dispatcher = this.cache.getDispatcher();
        this.marshaller = this.remoteCacheManager.getMarshaller();
    }

    public RemoteMultimapCacheImpl(RemoteCacheManager rcm, RemoteCache<K, Collection<V>> cache) {
        this(rcm, cache, false);
    }

    public RemoteMultimapCacheImpl(RemoteCacheManager rcm, RemoteCache<K, Collection<V>> cache, boolean supportsDuplicates) {
        if (log.isTraceEnabled()) {
            log.tracef("Creating multimap remote cache: %s", cache.getName());
        }
        this.cache = (RemoteCacheImpl)cache;
        this.remoteCacheManager = rcm;
        this.supportsDuplicates = supportsDuplicates;
    }

    public CompletableFuture<Void> put(K key, V value) {
        if (log.isTraceEnabled()) {
            log.tracef("About to add (K,V): (%s, %s) lifespan:%d, maxIdle:%d", new Object[]{key, value, 0, 0});
        }
        this.assertRemoteCacheManagerIsStarted();
        HotRodOperation<Void> op = this.operationsFactory.newPutKeyValueOperation(key, value, 0L, TimeUnit.MILLISECONDS, 0L, TimeUnit.MILLISECONDS, this.supportsDuplicates);
        return this.dispatcher.execute(op).toCompletableFuture();
    }

    public CompletableFuture<Collection<V>> get(K key) {
        if (log.isTraceEnabled()) {
            log.tracef("About to call get (K): (%s)", key);
        }
        this.assertRemoteCacheManagerIsStarted();
        HotRodOperation gco = this.operationsFactory.newGetKeyMultimapOperation(key, this.supportsDuplicates);
        return this.dispatcher.execute(gco).toCompletableFuture();
    }

    @Override
    public CompletableFuture<MetadataCollection<V>> getWithMetadata(K key) {
        if (log.isTraceEnabled()) {
            log.tracef("About to call getWithMetadata (K): (%s)", key);
        }
        this.assertRemoteCacheManagerIsStarted();
        HotRodOperation operation = this.operationsFactory.newGetKeyWithMetadataMultimapOperation(key, this.supportsDuplicates);
        return this.dispatcher.execute(operation).toCompletableFuture();
    }

    public CompletableFuture<Boolean> remove(K key) {
        if (log.isTraceEnabled()) {
            log.tracef("About to remove (K): (%s)", key);
        }
        this.assertRemoteCacheManagerIsStarted();
        HotRodOperation<Boolean> removeOperation = this.operationsFactory.newRemoveKeyOperation(key, this.supportsDuplicates);
        return this.dispatcher.execute(removeOperation).toCompletableFuture();
    }

    public CompletableFuture<Boolean> remove(K key, V value) {
        if (log.isTraceEnabled()) {
            log.tracef("About to remove (K,V): (%s, %s)", key, value);
        }
        this.assertRemoteCacheManagerIsStarted();
        HotRodOperation<Boolean> removeOperation = this.operationsFactory.newRemoveEntryOperation(key, value, this.supportsDuplicates);
        return this.dispatcher.execute(removeOperation).toCompletableFuture();
    }

    public CompletableFuture<Boolean> containsKey(K key) {
        if (log.isTraceEnabled()) {
            log.tracef("About to call contains (K): (%s)", key);
        }
        this.assertRemoteCacheManagerIsStarted();
        HotRodOperation<Boolean> containsKeyOperation = this.operationsFactory.newContainsKeyOperation(key, this.supportsDuplicates);
        return this.dispatcher.execute(containsKeyOperation).toCompletableFuture();
    }

    public CompletableFuture<Boolean> containsValue(V value) {
        if (log.isTraceEnabled()) {
            log.tracef("About to call contains (V): (%s)", value);
        }
        this.assertRemoteCacheManagerIsStarted();
        byte[] marshallValue = MarshallerUtil.obj2bytes(this.marshaller, value, this.valueSizePredictor);
        HotRodOperation<Boolean> containsValueOperation = this.operationsFactory.newContainsValueOperation(marshallValue, this.supportsDuplicates);
        return this.dispatcher.execute(containsValueOperation).toCompletableFuture();
    }

    public CompletableFuture<Boolean> containsEntry(K key, V value) {
        if (log.isTraceEnabled()) {
            log.tracef("About to call contais(K,V): (%s, %s)", key, value);
        }
        this.assertRemoteCacheManagerIsStarted();
        HotRodOperation<Boolean> containsOperation = this.operationsFactory.newContainsEntryOperation(key, value, this.supportsDuplicates);
        return this.dispatcher.execute(containsOperation).toCompletableFuture();
    }

    public CompletableFuture<Long> size() {
        if (log.isTraceEnabled()) {
            log.trace("About to call size");
        }
        this.assertRemoteCacheManagerIsStarted();
        return this.dispatcher.execute(this.operationsFactory.newSizeOperation(this.supportsDuplicates)).toCompletableFuture();
    }

    public boolean supportsDuplicates() {
        return this.supportsDuplicates;
    }

    private void assertRemoteCacheManagerIsStarted() {
        if (!this.remoteCacheManager.isStarted()) {
            String message = "Cannot perform operations on a multimap cache associated with an unstarted RemoteMultimapCacheManager.";
            if (log.isInfoEnabled()) {
                log.unstartedRemoteCacheManager();
            }
            throw new RemoteCacheManagerNotStartedException(message);
        }
    }
}

