/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod.impl.operations;

import io.netty.buffer.ByteBuf;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.DecoderException;
import java.net.SocketAddress;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicInteger;
import net.jcip.annotations.Immutable;
import org.infinispan.client.hotrod.configuration.Configuration;
import org.infinispan.client.hotrod.exceptions.HotRodClientException;
import org.infinispan.client.hotrod.exceptions.InvalidResponseException;
import org.infinispan.client.hotrod.impl.operations.HotRodOperation;
import org.infinispan.client.hotrod.impl.protocol.Codec;
import org.infinispan.client.hotrod.impl.protocol.HotRodConstants;
import org.infinispan.client.hotrod.impl.transport.netty.ChannelFactory;
import org.infinispan.client.hotrod.impl.transport.netty.ChannelOperation;
import org.infinispan.client.hotrod.impl.transport.netty.HeaderDecoder;
import org.infinispan.client.hotrod.logging.Log;
import org.infinispan.client.hotrod.logging.LogFactory;
import org.infinispan.commons.dataconversion.MediaType;

@Immutable
public class PingOperation
extends HotRodOperation<PingResponse>
implements ChannelOperation {
    private static final Log log = LogFactory.getLog(PingOperation.class);
    private static final boolean trace = log.isTraceEnabled();
    private final boolean releaseChannel;

    public PingOperation(Codec codec, AtomicInteger topologyId, Configuration cfg, byte[] cacheName, ChannelFactory channelFactory, boolean releaseChannel) {
        super((short)23, (short)24, codec, 0, cfg, cacheName, topologyId, channelFactory);
        this.releaseChannel = releaseChannel;
    }

    @Override
    public void invoke(Channel channel) {
        this.sendHeaderAndRead(channel);
        if (this.releaseChannel) {
            this.releaseChannel(channel);
        }
    }

    @Override
    public void cancel(SocketAddress address, Throwable cause) {
        this.completeExceptionally(cause);
    }

    @Override
    public CompletableFuture<PingResponse> execute() {
        throw new UnsupportedOperationException("Cannot execute directly");
    }

    @Override
    public void acceptResponse(ByteBuf buf, short status, HeaderDecoder decoder) {
        MediaType valueMediaType;
        MediaType keyMediaType = this.codec.readKeyType(buf);
        PingResponse pingResponse = new PingResponse(status, keyMediaType, valueMediaType = this.codec.readKeyType(buf));
        if (!pingResponse.isSuccess()) {
            String hexStatus = Integer.toHexString(status);
            if (trace) {
                log.tracef("Unknown response status: %s", hexStatus);
            }
            throw new InvalidResponseException("Unexpected response status: " + hexStatus);
        }
        this.complete(pingResponse);
    }

    @Override
    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
        while (cause instanceof DecoderException && cause.getCause() != null) {
            cause = cause.getCause();
        }
        PingResponse pingResponse = new PingResponse(cause);
        if (pingResponse.isCacheNotFound()) {
            this.complete(pingResponse);
        } else {
            super.exceptionCaught(ctx, cause);
        }
    }

    public static class PingResponse {
        public static PingResponse EMPTY = new PingResponse(null);
        private final short status;
        private final MediaType keyMediaType;
        private final MediaType valueMediaType;
        private final Throwable error;

        PingResponse(short status, MediaType keyMediaType, MediaType valueMediaType) {
            this.status = status;
            this.keyMediaType = keyMediaType;
            this.valueMediaType = valueMediaType;
            this.error = null;
        }

        PingResponse(Throwable error) {
            this.status = (short)-1;
            this.keyMediaType = MediaType.APPLICATION_UNKNOWN;
            this.valueMediaType = MediaType.APPLICATION_UNKNOWN;
            this.error = error;
        }

        public short getStatus() {
            return this.status;
        }

        public boolean isSuccess() {
            return HotRodConstants.isSuccess(this.status);
        }

        public boolean isObjectStorage() {
            return this.keyMediaType != null && this.keyMediaType.match(MediaType.APPLICATION_OBJECT);
        }

        public boolean isFailed() {
            return this.error != null;
        }

        public boolean isCacheNotFound() {
            return this.error instanceof HotRodClientException && this.error.getMessage().contains("CacheNotFoundException");
        }
    }
}

