/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.rest.configuration;

import java.util.Map;
import java.util.Properties;
import org.infinispan.client.rest.configuration.Protocol;
import org.infinispan.commons.util.TypedProperties;
import org.infinispan.commons.util.Version;

public class RestClientConfigurationProperties {
    public static final String ICR = "infinispan.client.rest.";
    public static final String SERVER_LIST = "infinispan.client.rest.server_list";
    public static final String CONTEXT_PATH = "infinispan.client.rest.context_path";
    public static final String TCP_NO_DELAY = "infinispan.client.rest.tcp_no_delay";
    public static final String TCP_KEEP_ALIVE = "infinispan.client.rest.tcp_keep_alive";
    public static final String PROTOCOL = "infinispan.client.rest.protocol";
    public static final String SO_TIMEOUT = "infinispan.client.rest.socket_timeout";
    public static final String CONNECT_TIMEOUT = "infinispan.client.rest.connect_timeout";
    public static final String USER_AGENT = Version.printVersion();
    public static final String USE_SSL = "infinispan.client.rest.use_ssl";
    public static final String KEY_STORE_FILE_NAME = "infinispan.client.rest.key_store_file_name";
    public static final String KEY_STORE_TYPE = "infinispan.client.rest.key_store_type";
    public static final String KEY_STORE_PASSWORD = "infinispan.client.rest.key_store_password";
    public static final String SNI_HOST_NAME = "infinispan.client.rest.sni_host_name";
    public static final String KEY_ALIAS = "infinispan.client.rest.key_alias";
    public static final String KEY_STORE_CERTIFICATE_PASSWORD = "infinispan.client.rest.key_store_certificate_password";
    public static final String TRUST_STORE_FILE_NAME = "infinispan.client.rest.trust_store_file_name";
    public static final String TRUST_STORE_PATH = "infinispan.client.rest.trust_store_path";
    public static final String TRUST_STORE_TYPE = "infinispan.client.rest.trust_store_type";
    public static final String TRUST_STORE_PASSWORD = "infinispan.client.rest.trust_store_password";
    public static final String SSL_PROTOCOL = "infinispan.client.rest.ssl_protocol";
    public static final String SSL_CONTEXT = "infinispan.client.rest.ssl_context";
    public static final String TRUST_MANAGERS = "infinispan.client.rest.trust_managers";
    public static final String PROVIDER = "infinispan.client.rest.provider";
    public static final String USE_AUTH = "infinispan.client.rest.use_auth";
    public static final String AUTH_MECHANISM = "infinispan.client.rest.sasl_mechanism";
    public static final String AUTH_CALLBACK_HANDLER = "infinispan.client.rest.auth_callback_handler";
    public static final String AUTH_SERVER_NAME = "infinispan.client.rest.auth_server_name";
    public static final String AUTH_USERNAME = "infinispan.client.rest.auth_username";
    public static final String AUTH_PASSWORD = "infinispan.client.rest.auth_password";
    public static final String AUTH_REALM = "infinispan.client.rest.auth_realm";
    public static final String AUTH_CLIENT_SUBJECT = "infinispan.client.rest.auth_client_subject";
    public static final int DEFAULT_REST_PORT = 11222;
    public static final long DEFAULT_SO_TIMEOUT = 60000L;
    public static final long DEFAULT_CONNECT_TIMEOUT = 60000L;
    public static final int DEFAULT_MAX_RETRIES = 10;
    public static final int DEFAULT_BATCH_SIZE = 10000;
    public static final String DEFAULT_CONTEXT_PATH = "/rest";
    private final TypedProperties props;

    public RestClientConfigurationProperties() {
        this.props = new TypedProperties();
    }

    public RestClientConfigurationProperties(String serverList) {
        this();
        this.setServerList(serverList);
    }

    public RestClientConfigurationProperties(Properties props) {
        this.props = props == null ? new TypedProperties() : TypedProperties.toTypedProperties((Map)props);
    }

    public void setServerList(String serverList) {
        this.props.setProperty(SERVER_LIST, serverList);
    }

    public boolean getTcpNoDelay() {
        return this.props.getBooleanProperty(TCP_NO_DELAY, true);
    }

    public void setTcpNoDelay(boolean tcpNoDelay) {
        this.props.setProperty(TCP_NO_DELAY, tcpNoDelay);
    }

    public boolean getTcpKeepAlive() {
        return this.props.getBooleanProperty(TCP_KEEP_ALIVE, false);
    }

    public void setTcpKeepAlive(boolean tcpKeepAlive) {
        this.props.setProperty(TCP_KEEP_ALIVE, tcpKeepAlive);
    }

    public Properties getProperties() {
        return this.props;
    }

    public Protocol getProtocol() {
        return Protocol.valueOf(this.props.getProperty(PROTOCOL, Protocol.HTTP_11.name()));
    }

    public void setProtocol(Protocol protocol) {
        this.props.setProperty(PROTOCOL, protocol.name());
    }

    public long getSoTimeout() {
        return this.props.getLongProperty(SO_TIMEOUT, 60000L);
    }

    public void setSocketTimeout(int socketTimeout) {
        this.props.setProperty(SO_TIMEOUT, socketTimeout);
    }

    public long getConnectTimeout() {
        return this.props.getLongProperty(CONNECT_TIMEOUT, 60000L);
    }

    public void setConnectTimeout(int connectTimeout) {
        this.props.setProperty(CONNECT_TIMEOUT, connectTimeout);
    }

    public boolean getUseSSL() {
        return this.props.getBooleanProperty(USE_SSL, false);
    }

    public void setUseSSL(boolean useSSL) {
        this.props.setProperty(USE_SSL, useSSL);
    }

    public String getKeyStoreFileName() {
        return this.props.getProperty(KEY_STORE_FILE_NAME);
    }

    public void setKeyStoreFileName(String keyStoreFileName) {
        this.props.setProperty(KEY_STORE_FILE_NAME, keyStoreFileName);
    }

    public String getKeyStoreType() {
        return this.props.getProperty(KEY_STORE_TYPE);
    }

    public void setKeyStoreType(String keyStoreType) {
        this.props.setProperty(KEY_STORE_TYPE, keyStoreType);
    }

    public String getKeyStorePassword() {
        return this.props.getProperty(KEY_STORE_PASSWORD);
    }

    public void setKeyStorePassword(String keyStorePassword) {
        this.props.setProperty(KEY_STORE_PASSWORD, keyStorePassword);
    }

    public String getKeyAlias() {
        return this.props.getProperty(KEY_ALIAS);
    }

    public void setKeyAlias(String keyAlias) {
        this.props.setProperty(KEY_ALIAS, keyAlias);
    }

    public String getTrustStoreFileName() {
        return this.props.getProperty(TRUST_STORE_FILE_NAME);
    }

    public void setTrustStoreFileName(String trustStoreFileName) {
        this.props.setProperty(TRUST_STORE_FILE_NAME, trustStoreFileName);
    }

    public String getTrustStoreType() {
        return this.props.getProperty(TRUST_STORE_TYPE);
    }

    public void setTrustStoreType(String trustStoreType) {
        this.props.setProperty(TRUST_STORE_TYPE, trustStoreType);
    }

    public String getTrustStorePassword() {
        return this.props.getProperty(TRUST_STORE_PASSWORD);
    }

    public void setTrustStorePassword(String trustStorePassword) {
        this.props.setProperty(TRUST_STORE_PASSWORD, trustStorePassword);
    }

    public String getTrustStorePath() {
        return this.props.getProperty(TRUST_STORE_PATH);
    }

    public void setTrustStorePath(String trustStorePath) {
        this.props.setProperty(TRUST_STORE_PATH, trustStorePath);
    }

    public String getSSLProtocol() {
        return this.props.getProperty(SSL_PROTOCOL);
    }

    public void setSSLProtocol(String sslProtocol) {
        this.props.setProperty(SSL_PROTOCOL, sslProtocol);
    }

    public String getSniHostName() {
        return this.props.getProperty(SNI_HOST_NAME);
    }

    public void setSniHostName(String sniHostName) {
        this.props.setProperty(SNI_HOST_NAME, sniHostName);
    }

    public boolean getUseAuth() {
        return this.props.getBooleanProperty(USE_AUTH, false);
    }

    public void setUseAuth(boolean useAuth) {
        this.props.setProperty(USE_AUTH, useAuth);
    }

    public String getSaslMechanism() {
        return this.props.getProperty(AUTH_MECHANISM);
    }

    public void setSaslMechanism(String saslMechanism) {
        this.props.setProperty(AUTH_MECHANISM, saslMechanism);
    }

    public String getAuthUsername() {
        return this.props.getProperty(AUTH_USERNAME);
    }

    public void setAuthUsername(String authUsername) {
        this.props.setProperty(AUTH_USERNAME, authUsername);
    }

    public String getAuthPassword() {
        return this.props.getProperty(AUTH_PASSWORD);
    }

    public void setAuthPassword(String authPassword) {
        this.props.setProperty(AUTH_PASSWORD, authPassword);
    }

    public String getAuthRealm() {
        return this.props.getProperty(AUTH_REALM);
    }

    public void setAuthRealm(String authRealm) {
        this.props.setProperty(AUTH_REALM, authRealm);
    }

    public void setAuthServerName(String authServerName) {
        this.props.setProperty(AUTH_SERVER_NAME, authServerName);
    }

    public String getServerList() {
        return this.props.getProperty(SERVER_LIST);
    }
}

