/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.rest.impl.jdk;

import java.util.concurrent.CompletionStage;
import org.infinispan.client.rest.RestLoggingClient;
import org.infinispan.client.rest.RestResponse;
import org.infinispan.client.rest.impl.jdk.RestClientJDK;
import org.infinispan.client.rest.impl.jdk.RestRawClientJDK;

public class RestLoggingClientJDK
implements RestLoggingClient {
    private final RestRawClientJDK client;
    private final String path;

    RestLoggingClientJDK(RestRawClientJDK restClient) {
        this.client = restClient;
        this.path = restClient.getConfiguration().contextPath() + "/v2/logging";
    }

    @Override
    public CompletionStage<RestResponse> listLoggers() {
        return this.client.get(this.path + "/loggers");
    }

    @Override
    public CompletionStage<RestResponse> listAppenders() {
        return this.client.get(this.path + "/appenders");
    }

    @Override
    public CompletionStage<RestResponse> setLogger(String name, String level, String ... appenders) {
        StringBuilder sb = new StringBuilder(this.path);
        sb.append("/loggers/");
        if (name != null) {
            sb.append(RestClientJDK.sanitize(name));
        }
        sb.append("?");
        boolean amp = false;
        if (level != null) {
            sb.append("level=").append(level);
            amp = true;
        }
        if (appenders != null) {
            for (String appender : appenders) {
                if (amp) {
                    sb.append("&");
                }
                sb.append("appender=").append(appender);
                amp = true;
            }
        }
        return this.client.put(sb.toString());
    }

    @Override
    public CompletionStage<RestResponse> removeLogger(String name) {
        return this.client.delete(this.path + "/loggers/" + RestClientJDK.sanitize(name));
    }
}

