/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.rest.impl.jdk;

import java.io.File;
import java.net.http.HttpResponse;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletionStage;
import org.infinispan.client.rest.MultiPartRestEntity;
import org.infinispan.client.rest.RestContainerClient;
import org.infinispan.client.rest.RestEntity;
import org.infinispan.client.rest.RestResponse;
import org.infinispan.client.rest.impl.jdk.RestRawClientJDK;
import org.infinispan.commons.dataconversion.MediaType;
import org.infinispan.commons.dataconversion.internal.Json;

public class RestContainerClientJDK
implements RestContainerClient {
    private final RestRawClientJDK client;
    private final String path;

    RestContainerClientJDK(RestRawClientJDK client) {
        this.client = client;
        this.path = client.getConfiguration().contextPath() + "/v2/container";
    }

    @Override
    public CompletionStage<RestResponse> shutdown() {
        return this.client.post(this.path + "?action=shutdown");
    }

    @Override
    public CompletionStage<RestResponse> globalConfiguration(String mediaType) {
        return this.client.get(this.path + "/config", Map.of("Accept", mediaType));
    }

    @Override
    public CompletionStage<RestResponse> cacheConfigurations() {
        return this.client.get(this.path + "/cache-configs");
    }

    @Override
    public CompletionStage<RestResponse> cacheConfigurations(String mediaType) {
        return this.client.get(this.path + "/cache-configs", Map.of("Accept", mediaType));
    }

    @Override
    public CompletionStage<RestResponse> templates(String mediaType) {
        return this.client.get(this.path + "/cache-configs/templates", Map.of("Accept", mediaType));
    }

    @Override
    public CompletionStage<RestResponse> info() {
        return this.client.get(this.path);
    }

    @Override
    public CompletionStage<RestResponse> stats() {
        return this.client.get(this.path + "/stats");
    }

    @Override
    public CompletionStage<RestResponse> statsReset() {
        return this.client.post(this.path + "/stats?action=reset");
    }

    @Override
    public CompletionStage<RestResponse> backupStatuses() {
        return this.client.get(this.path + "/x-site/backups");
    }

    @Override
    public CompletionStage<RestResponse> backupStatus(String site) {
        return this.client.get(this.path + "/x-site/backups/" + site);
    }

    @Override
    public CompletionStage<RestResponse> bringBackupOnline(String backup) {
        return this.executeXSiteOperation(backup, "bring-online");
    }

    @Override
    public CompletionStage<RestResponse> takeOffline(String backup) {
        return this.executeXSiteOperation(backup, "take-offline");
    }

    @Override
    public CompletionStage<RestResponse> pushSiteState(String backup) {
        return this.executeXSiteOperation(backup, "start-push-state");
    }

    @Override
    public CompletionStage<RestResponse> cancelPushState(String backup) {
        return this.executeXSiteOperation(backup, "cancel-push-state");
    }

    private CompletionStage<RestResponse> executeXSiteOperation(String backup, String operation) {
        return this.client.post(this.path + "/x-site/backups/" + backup + "?action=" + operation);
    }

    @Override
    public CompletionStage<RestResponse> health() {
        return this.health(false);
    }

    @Override
    public CompletionStage<RestResponse> health(boolean skipBody) {
        return skipBody ? this.client.head(this.path + "/health") : this.client.get(this.path + "/health");
    }

    @Override
    public CompletionStage<RestResponse> healthStatus() {
        return this.client.get(this.path + "/health/status");
    }

    @Override
    public CompletionStage<RestResponse> createBackup(String name, String workingDir, Map<String, List<String>> resources) {
        Json json = Json.object();
        if (workingDir != null) {
            json.set("directory", (Object)workingDir);
        }
        if (resources != null) {
            json.set("resources", Json.factory().make(resources));
        }
        return this.client.post(this.backup(name), RestEntity.create(MediaType.APPLICATION_JSON, json.toString()));
    }

    @Override
    public CompletionStage<RestResponse> getBackup(String name, boolean skipBody) {
        if (skipBody) {
            return this.client.head(this.backup(name));
        }
        return this.client.get(this.backup(name), Map.of("Accept", "application/octet-stream"), HttpResponse.BodyHandlers::ofInputStream);
    }

    @Override
    public CompletionStage<RestResponse> getBackupNames() {
        return this.client.get(this.path + "/backups");
    }

    @Override
    public CompletionStage<RestResponse> deleteBackup(String name) {
        return this.client.delete(this.backup(name));
    }

    @Override
    public CompletionStage<RestResponse> restore(String name, File backup, Map<String, List<String>> resources) {
        Json json = resources != null ? Json.factory().make(resources) : Json.object();
        MultiPartRestEntity body = RestEntity.multiPart();
        body.addPart("backup", backup.toPath(), MediaType.APPLICATION_ZIP);
        body.addPart("resources", json.toString());
        return this.client.post(this.restore(name), body);
    }

    @Override
    public CompletionStage<RestResponse> restore(String name, String backupLocation, Map<String, List<String>> resources) {
        Json json = Json.object();
        json.set("location", (Object)backupLocation);
        if (resources != null) {
            json.set("resources", Json.factory().make(resources));
        }
        return this.client.post(this.restore(name), RestEntity.create(MediaType.APPLICATION_JSON, json.toString()));
    }

    @Override
    public CompletionStage<RestResponse> getRestore(String name) {
        return this.client.head(this.restore(name));
    }

    @Override
    public CompletionStage<RestResponse> getRestoreNames() {
        return this.client.get(this.path + "/restores");
    }

    @Override
    public CompletionStage<RestResponse> deleteRestore(String name) {
        return this.client.delete(this.restore(name));
    }

    @Override
    public CompletionStage<RestResponse> enableRebalancing() {
        return this.setRebalancing(true);
    }

    @Override
    public CompletionStage<RestResponse> disableRebalancing() {
        return this.setRebalancing(false);
    }

    private CompletionStage<RestResponse> setRebalancing(boolean enable) {
        String action = enable ? "enable-rebalancing" : "disable-rebalancing";
        return this.client.post(this.path + "?action=" + action);
    }

    private String backup(String name) {
        return this.path + "/backups/" + name;
    }

    private String restore(String name) {
        return this.path + "/restores/" + name;
    }
}

