/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.cloudevents.impl;

import java.nio.charset.StandardCharsets;
import java.util.Base64;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.infinispan.commons.dataconversion.MediaType;
import org.infinispan.commons.dataconversion.internal.Json;

public class StructuredEventBuilder {
    public static final int VALIDATION_BUFFER_SIZE = 512;
    public static final String SPECVERSION = "specversion";
    public static final String SPEC_VERSION_10 = "1.0";
    public static final String ID = "id";
    public static final String SOURCE = "source";
    public static final String SUBJECT = "subject";
    public static final String TYPE = "type";
    public static final String TIME = "time";
    public static final String DATA = "data";
    public static final String DATACONTENTTYPE = "datacontenttype";
    public static final String INFINISPAN_SUBJECT_CONTENTTYPE = "orginfinispansubject_contenttype";
    public static final String INFINISPAN_SUBJECT_ISBASE64 = "orginfinispansubject_isbase64";
    public static final String INFINISPAN_DATA_ISBASE64 = "orginfinispandata_isbase64";
    public static final String INFINISPAN_ENTRYVERSION = "orginfinispanentryversion";
    Json json = Json.object();
    private byte[] key;

    public StructuredEventBuilder() {
        this.json.set(SPECVERSION, (Object)SPEC_VERSION_10);
    }

    public ProducerRecord<byte[], byte[]> toKafkaRecord(String topic) {
        return new ProducerRecord(topic, (Object)this.key, (Object)this.json.toString().getBytes(StandardCharsets.UTF_8));
    }

    public void setId(String id) {
        this.json.set(ID, (Object)id);
    }

    public void setSource(String source) {
        this.json.set(SOURCE, (Object)source);
    }

    public void setType(String type) {
        this.json.set(TYPE, (Object)type);
    }

    public void setTime(String time) {
        this.json.set(TIME, (Object)time);
    }

    public void setSubject(String subject, MediaType mediaType, boolean validUtf8) {
        this.json.set(SUBJECT, (Object)subject);
        if (!mediaType.equals((Object)MediaType.APPLICATION_JSON)) {
            this.json.set(INFINISPAN_SUBJECT_CONTENTTYPE, (Object)mediaType);
            if (!validUtf8) {
                this.json.set(INFINISPAN_SUBJECT_ISBASE64, Json.factory().bool(true));
            }
        }
    }

    public void setData(byte[] data, MediaType dataMediaType, boolean validUtf8) {
        if (dataMediaType.equals((Object)MediaType.APPLICATION_JSON)) {
            String string = new String(data, dataMediaType.getCharset());
            this.json.set(DATA, Json.factory().raw(string));
        } else {
            String valueString;
            this.json.set(DATACONTENTTYPE, (Object)dataMediaType);
            if (!validUtf8) {
                this.json.set(INFINISPAN_DATA_ISBASE64, Json.factory().bool(true));
                valueString = Base64.getEncoder().encodeToString(data);
            } else {
                valueString = new String(data, dataMediaType.getCharset());
            }
            this.json.set(DATA, Json.factory().string(valueString));
        }
    }

    public void setPrimitiveData(Object data) {
        this.json.set(DATA, Json.factory().make(data));
    }

    public void setEntryVersion(byte[] version) {
        this.json.set(INFINISPAN_ENTRYVERSION, (Object)Base64.getEncoder().encodeToString(version));
    }

    static boolean isJsonPrimitive(Class<?> valueClass) {
        return valueClass == String.class || valueClass == Boolean.class || Number.class.isAssignableFrom(valueClass) || valueClass.isArray() && StructuredEventBuilder.isJsonPrimitive(valueClass.getComponentType());
    }

    public void setKey(byte[] keyBytes) {
        this.key = keyBytes;
    }
}

