/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.counter.impl.function;

import java.util.function.Function;
import org.infinispan.counter.api.CounterConfiguration;
import org.infinispan.counter.impl.entries.CounterKey;
import org.infinispan.counter.impl.entries.CounterValue;
import org.infinispan.functional.EntryView;
import org.infinispan.functional.impl.CounterConfigurationMetaParam;

abstract class BaseCreateFunction<K extends CounterKey, R>
implements Function<EntryView.ReadWriteEntryView<K, CounterValue>, R> {
    final CounterConfiguration configuration;

    BaseCreateFunction(CounterConfiguration configuration) {
        this.configuration = configuration;
    }

    @Override
    public final R apply(EntryView.ReadWriteEntryView<K, CounterValue> entryView) {
        return entryView.find().isPresent() ? this.checkMetadataAndApply(entryView) : this.createAndApply(entryView);
    }

    private R checkMetadataAndApply(EntryView.ReadWriteEntryView<K, CounterValue> entryView) {
        CounterConfigurationMetaParam metadata = entryView.findMetaParam(CounterConfigurationMetaParam.class).orElseGet(this::createMetadata);
        return this.apply(entryView, (CounterValue)entryView.get(), metadata);
    }

    private R createAndApply(EntryView.ReadWriteEntryView<K, CounterValue> entryView) {
        CounterValue value = CounterValue.newCounterValue(this.configuration);
        return this.apply(entryView, value, this.createMetadata());
    }

    abstract R apply(EntryView.ReadWriteEntryView<K, CounterValue> var1, CounterValue var2, CounterConfigurationMetaParam var3);

    private CounterConfigurationMetaParam createMetadata() {
        return new CounterConfigurationMetaParam(this.configuration);
    }
}

