/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.counter.impl.weak;

import java.util.Objects;
import org.infinispan.counter.impl.entries.CounterKey;
import org.infinispan.protostream.annotations.ProtoFactory;
import org.infinispan.protostream.annotations.ProtoField;
import org.infinispan.protostream.annotations.ProtoTypeId;
import org.infinispan.util.ByteString;

@ProtoTypeId(value=127)
public class WeakCounterKey
implements CounterKey {
    private final ByteString counterName;
    private final int index;

    @ProtoFactory
    WeakCounterKey(ByteString counterName, int index) {
        this.counterName = Objects.requireNonNull(counterName);
        this.index = WeakCounterKey.requirePositive(index);
    }

    private static int requirePositive(int i) {
        if (i < 0) {
            throw new IllegalArgumentException("Requires positive index");
        }
        return i;
    }

    @Override
    @ProtoField(value=1)
    public ByteString getCounterName() {
        return this.counterName;
    }

    @ProtoField(number=2, defaultValue="0")
    int getIndex() {
        return this.index;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WeakCounterKey that = (WeakCounterKey)o;
        return this.index == that.index && this.counterName.equals((Object)that.counterName);
    }

    public int hashCode() {
        int result = this.counterName.hashCode();
        result = 31 * result + this.index;
        return result;
    }

    public String toString() {
        return "WeakCounterKey{counterName=" + String.valueOf(this.counterName) + ", index=" + this.index + "}";
    }
}

