/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.lock.configuration;

import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.infinispan.commons.logging.LogFactory;
import org.infinispan.configuration.global.GlobalConfigurationBuilder;
import org.infinispan.configuration.parsing.ConfigurationBuilderHolder;
import org.infinispan.configuration.parsing.ConfigurationParser;
import org.infinispan.configuration.parsing.Namespace;
import org.infinispan.configuration.parsing.Namespaces;
import org.infinispan.configuration.parsing.ParseUtils;
import org.infinispan.configuration.parsing.ParserScope;
import org.infinispan.configuration.parsing.XMLExtendedStreamReader;
import org.infinispan.lock.configuration.Attribute;
import org.infinispan.lock.configuration.ClusteredLockConfigurationBuilder;
import org.infinispan.lock.configuration.ClusteredLockManagerConfigurationBuilder;
import org.infinispan.lock.configuration.Element;
import org.infinispan.lock.configuration.Reliability;
import org.infinispan.lock.logging.Log;

@Namespaces(value={@Namespace(root="clustered-locks"), @Namespace(uri="urn:infinispan:config:clustered-locks:*", root="clustered-locks", since="9.4")})
public class ClusteredLockConfigurationParser
implements ConfigurationParser {
    private static final Log log = (Log)LogFactory.getLog(ClusteredLockConfigurationParser.class, Log.class);

    public void readElement(XMLExtendedStreamReader reader, ConfigurationBuilderHolder holder) throws XMLStreamException {
        if (!holder.inScope((Enum)ParserScope.CACHE_CONTAINER)) {
            throw log.invalidScope(holder.getScope());
        }
        GlobalConfigurationBuilder builder = holder.getGlobalConfigurationBuilder();
        Element element = Element.forName(reader.getLocalName());
        switch (element) {
            case CLUSTERED_LOCKS: {
                this.parseClusteredLocksElement((XMLStreamReader)reader, (ClusteredLockManagerConfigurationBuilder)builder.addModule(ClusteredLockManagerConfigurationBuilder.class));
                break;
            }
            default: {
                throw ParseUtils.unexpectedElement((XMLStreamReader)reader);
            }
        }
    }

    public Namespace[] getNamespaces() {
        return ParseUtils.getNamespaceAnnotations(this.getClass());
    }

    private void parseClusteredLocksElement(XMLStreamReader reader, ClusteredLockManagerConfigurationBuilder builder) throws XMLStreamException {
        block7: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            ParseUtils.requireNoNamespaceAttribute((XMLStreamReader)reader, (int)i);
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case NUM_OWNERS: {
                    builder.numOwner(Integer.parseInt(value));
                    continue block7;
                }
                case RELIABILITY: {
                    builder.reliability(Reliability.valueOf(value));
                    continue block7;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLStreamReader)reader, (int)i);
                }
            }
        }
        block8: while (reader.hasNext() && reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                case CLUSTERED_LOCK: {
                    this.parseClusteredLock(reader, builder.addClusteredLock());
                    continue block8;
                }
            }
            throw ParseUtils.unexpectedElement((XMLStreamReader)reader);
        }
    }

    private void parseClusteredLock(XMLStreamReader reader, ClusteredLockConfigurationBuilder builder) throws XMLStreamException {
        block3: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            ParseUtils.requireNoNamespaceAttribute((XMLStreamReader)reader, (int)i);
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case NAME: {
                    builder.name(value);
                    continue block3;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLStreamReader)reader, (int)i);
                }
            }
        }
        ParseUtils.requireNoContent((XMLStreamReader)reader);
    }
}

