package org.infinispan.lock.logging;

import java.util.Locale;
import java.lang.Integer;
import java.io.Serializable;
import javax.annotation.processing.Generated;
import org.jboss.logging.DelegatingBasicLogger;
import org.jboss.logging.BasicLogger;
import java.lang.Throwable;
import org.infinispan.lock.exception.ClusteredLockException;
import java.lang.Object;
import java.lang.String;
import org.jboss.logging.Logger;
import java.util.Arrays;


import static org.jboss.logging.Logger.Level.INFO;

/**
 * Warning this class consists of generated code.
 */
@Generated(value = "org.jboss.logging.processor.generator.model.MessageLoggerImplementor", date = "2024-02-01T11:31:18-0500")
public class Log_$logger extends DelegatingBasicLogger implements Log, BasicLogger, Serializable {
    private static final long serialVersionUID = 1L;
    private static final String FQCN = Log_$logger.class.getName();
    public Log_$logger(final Logger log) {
        super(log);
    }
    private static final Locale LOCALE = Locale.ROOT;
    protected Locale getLoggingLocale() {
        return LOCALE;
    }
    protected String lockDeleted$str() {
        return "ISPN029001: The lock was deleted.";
    }
    @Override
    public final ClusteredLockException lockDeleted() {
        final ClusteredLockException result = new ClusteredLockException(String.format(getLoggingLocale(), lockDeleted$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    private static void _copyStackTraceMinusOne(final Throwable e) {
        final StackTraceElement[] st = e.getStackTrace();
        e.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
    }
    protected String unlockFailed$str() {
        return "ISPN029003: LOCK[%s] Unlock failed from node %s";
    }
    @Override
    public final ClusteredLockException unlockFailed(final String lockName, final Object originator) {
        final ClusteredLockException result = new ClusteredLockException(String.format(getLoggingLocale(), unlockFailed$str(), lockName, originator));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String missingName$str() {
        return "ISPN029004: Missing name for the clustered lock";
    }
    @Override
    public final ClusteredLockException missingName() {
        final ClusteredLockException result = new ClusteredLockException(String.format(getLoggingLocale(), missingName$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String invalidNumOwners$str() {
        return "ISPN029005: Invalid number of owner. It must be higher than zero or -1 but it was %s";
    }
    @Override
    public final ClusteredLockException invalidNumOwners(final Integer value) {
        final ClusteredLockException result = new ClusteredLockException(String.format(getLoggingLocale(), invalidNumOwners$str(), value));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String invalidReliabilityMode$str() {
        return "ISPN029006: Invalid reliability mode. Modes are AVAILABLE or CONSISTENT";
    }
    @Override
    public final ClusteredLockException invalidReliabilityMode() {
        final ClusteredLockException result = new ClusteredLockException(String.format(getLoggingLocale(), invalidReliabilityMode$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String invalidScope$str() {
        return "ISPN029007: Invalid scope for tag <clustered-lock>. Expected CACHE_CONTAINER but was %s";
    }
    @Override
    public final ClusteredLockException invalidScope(final String scope) {
        final ClusteredLockException result = new ClusteredLockException(String.format(getLoggingLocale(), invalidScope$str(), scope));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String requireClustered$str() {
        return "ISPN029008: Cannot create clustered locks when clustering is not enabled";
    }
    @Override
    public final ClusteredLockException requireClustered() {
        final ClusteredLockException result = new ClusteredLockException(String.format(getLoggingLocale(), requireClustered$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    @Override
    public final void configurationNotClustered() {
        super.log.logf(FQCN, INFO, null, configurationNotClustered$str());
    }
    protected String configurationNotClustered$str() {
        return "ISPN029009: Configuration is not clustered, clustered locks are disabled";
    }
    protected String jmxRegistrationFailed$str() {
        return "ISPN029010: MBean registration failed";
    }
    @Override
    public final ClusteredLockException jmxRegistrationFailed(final Throwable cause) {
        final ClusteredLockException result = new ClusteredLockException(String.format(getLoggingLocale(), jmxRegistrationFailed$str()));
        result.initCause(cause);
        _copyStackTraceMinusOne(result);
        return result;
    }
}
