/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.commons.graalvm;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.function.Consumer;
import java.util.stream.Stream;
import org.graalvm.nativeimage.hosted.Feature;
import org.infinispan.commons.graalvm.ReflectiveClass;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.jandex.IndexView;

public class ReflectionProcessor {
    final Feature.FeatureAccess featureAccess;
    final IndexView index;
    final List<ReflectiveClass> reflectiveClasses;

    public ReflectionProcessor(Feature.FeatureAccess featureAccess, IndexView index) {
        this.featureAccess = featureAccess;
        this.index = index;
        this.reflectiveClasses = new ArrayList<ReflectiveClass>();
    }

    public ReflectionProcessor addClasses(Class<?> ... classes) {
        return this.addClasses(false, false, classes);
    }

    public ReflectionProcessor addClasses(boolean fields, boolean methods, Class<?> ... classes) {
        this.reflectiveClasses.addAll(Arrays.stream(classes).map(c -> ReflectiveClass.of(c, fields, methods)).toList());
        return this;
    }

    public ReflectionProcessor addClasses(String ... classes) {
        return this.addClasses(false, false, classes);
    }

    public ReflectionProcessor addClasses(boolean fields, boolean methods, String ... classes) {
        this.reflectiveClasses.addAll(Arrays.stream(classes).map(arg_0 -> ((Feature.FeatureAccess)this.featureAccess).findClassByName(arg_0)).map(c -> ReflectiveClass.of(c, fields, methods)).toList());
        return this;
    }

    public ReflectionProcessor addClassesWithAnnotation(boolean fields, boolean methods, Class<?> annotation) {
        return this.forEachAnnotation(annotation, instance -> {
            AnnotationTarget target = instance.target();
            if (target.kind() == AnnotationTarget.Kind.CLASS) {
                DotName targetName = target.asClass().name();
                this.addClasses(fields, methods, targetName.toString());
            }
        });
    }

    public ReflectionProcessor addClassFromAnnotationValue(boolean fields, boolean methods, Class<?> annotation) {
        return this.forEachAnnotation(annotation, instance -> {
            String className = instance.value().asString();
            this.addClasses(fields, methods, className);
        });
    }

    public ReflectionProcessor forEachAnnotation(Class<?> annotation, Consumer<AnnotationInstance> consumer) {
        if (!annotation.isAnnotation()) {
            throw new IllegalArgumentException("Provided class must be an annotation");
        }
        this.index.getAnnotations(DotName.createSimple((String)annotation.getName())).forEach(consumer);
        return this;
    }

    public ReflectionProcessor addImplementation(boolean fields, boolean methods, String className) {
        return this.addImplementations(fields, methods, this.featureAccess.findClassByName(className));
    }

    public ReflectionProcessor addImplementation(boolean fields, boolean methods, Class<?> clazz) {
        Collection classInfos = clazz.isInterface() ? this.index.getAllKnownImplementors(DotName.createSimple((String)clazz.getName())) : this.index.getAllKnownSubclasses(DotName.createSimple((String)clazz.getName()));
        classInfos.stream().map(ClassInfo::toString).forEach(c -> this.addClasses(fields, methods, (String)c));
        return this;
    }

    public ReflectionProcessor addImplementations(boolean fields, boolean methods, String ... classes) {
        for (String clazz : classes) {
            this.addImplementation(fields, methods, clazz);
        }
        return this;
    }

    public ReflectionProcessor addImplementations(boolean fields, boolean methods, Class<?> ... classes) {
        for (Class<?> clazz : classes) {
            this.addImplementation(fields, methods, clazz);
        }
        return this;
    }

    public Stream<ReflectiveClass> classes() {
        return this.reflectiveClasses.stream();
    }
}

