/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.commons.tx;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutionException;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.transaction.HeuristicMixedException;
import javax.transaction.HeuristicRollbackException;
import javax.transaction.RollbackException;
import javax.transaction.Synchronization;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import org.infinispan.commons.logging.Log;
import org.infinispan.commons.logging.LogFactory;
import org.infinispan.commons.tx.DefaultResourceConverter;
import org.infinispan.commons.tx.TransactionManagerImpl;
import org.infinispan.commons.tx.TransactionResourceConverter;
import org.infinispan.commons.tx.Util;
import org.infinispan.commons.tx.XidImpl;
import org.infinispan.commons.util.concurrent.CompletableFutures;

public class TransactionImpl
implements Transaction {
    private static final Log log = LogFactory.getLog(TransactionImpl.class);
    private static final String FORCE_ROLLBACK_MESSAGE = "Force rollback invoked. (debug mode)";
    private final List<Synchronization> syncs;
    private final List<XaResourceData> resources;
    private final Object xidLock = new Object();
    private volatile XidImpl xid;
    private volatile int status = 0;
    private RollbackException firstRollbackException;

    protected TransactionImpl() {
        this.syncs = new ArrayList<Synchronization>(2);
        this.resources = new ArrayList<XaResourceData>(2);
    }

    private static boolean isRollbackCode(XAException ex) {
        return ex.errorCode >= 100 && ex.errorCode <= 107;
    }

    private static RollbackException newRollbackException(String message, Throwable cause) {
        RollbackException exception = new RollbackException(message);
        exception.initCause(cause);
        return exception;
    }

    private static Throwable throwChecked(Throwable throwable) throws RollbackException, HeuristicMixedException, HeuristicRollbackException {
        if ((throwable = CompletableFutures.extractException(throwable)) instanceof HeuristicMixedException) {
            throw (HeuristicMixedException)throwable;
        }
        if (throwable instanceof HeuristicRollbackException) {
            throw (HeuristicRollbackException)throwable;
        }
        if (throwable instanceof RollbackException) {
            throw (RollbackException)throwable;
        }
        if (throwable instanceof RuntimeException) {
            throw (RuntimeException)throwable;
        }
        return throwable;
    }

    private static void throwRuntimeException(Throwable throwable) {
        if (throwable instanceof RuntimeException) {
            throw (RuntimeException)throwable;
        }
        throw new RuntimeException(throwable);
    }

    private static Void checkThrowableForRollback(Throwable t) {
        if ((t = CompletableFutures.extractException(t)) instanceof HeuristicMixedException || t instanceof HeuristicRollbackException) {
            log.errorRollingBack(t);
            SystemException systemException = new SystemException("Unable to rollback transaction");
            systemException.initCause(t);
            throw CompletableFutures.asCompletionException((Throwable)systemException);
        }
        if (t instanceof RollbackException && log.isTraceEnabled()) {
            log.trace("RollbackException thrown while rolling back", t);
        }
        return null;
    }

    public void commit() throws RollbackException, HeuristicMixedException, HeuristicRollbackException, SecurityException {
        try {
            this.commitAsync(DefaultResourceConverter.INSTANCE).toCompletableFuture().get();
        }
        catch (ExecutionException e) {
            Throwable cause = TransactionImpl.throwChecked(e.getCause());
            if (cause instanceof SecurityException) {
                throw (SecurityException)cause;
            }
            TransactionImpl.throwRuntimeException(cause);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    public CompletionStage<Void> commitAsync(TransactionResourceConverter converter) {
        if (log.isTraceEnabled()) {
            log.tracef("Transaction.commit() invoked in transaction with Xid=%s", this.xid);
        }
        if (this.isDone()) {
            return CompletableFutures.completedExceptionFuture(new IllegalStateException("Transaction is done. Cannot commit transaction."));
        }
        return this.runPrepareAsync(converter).handle((____, ___) -> this.runCommitAsync(false, converter)).thenCompose(Function.identity());
    }

    public void rollback() throws IllegalStateException, SystemException {
        try {
            this.rollbackAsync(DefaultResourceConverter.INSTANCE).toCompletableFuture().get();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        catch (ExecutionException e) {
            Throwable cause = CompletableFutures.extractException(e.getCause());
            if (cause instanceof IllegalStateException) {
                throw (IllegalStateException)cause;
            }
            if (cause instanceof SystemException) {
                throw (SystemException)cause;
            }
            TransactionImpl.throwRuntimeException(cause);
        }
    }

    public CompletionStage<Void> rollbackAsync(TransactionResourceConverter converter) {
        if (log.isTraceEnabled()) {
            log.tracef("Transaction.commit() invoked in transaction with Xid=%s", this.xid);
        }
        if (this.isDone()) {
            return CompletableFutures.completedExceptionFuture(new IllegalStateException("Transaction is done. Cannot commit transaction."));
        }
        this.status = 1;
        return this.asyncEndXaResources(converter).thenCompose(unused -> this.runCommitAsync(false, converter)).exceptionally(TransactionImpl::checkThrowableForRollback);
    }

    public void setRollbackOnly() throws IllegalStateException {
        if (log.isTraceEnabled()) {
            log.tracef("Transaction.setRollbackOnly() invoked in transaction with Xid=%s", this.xid);
        }
        if (this.isDone()) {
            throw new IllegalStateException("Transaction is done. Cannot change status");
        }
        this.markRollbackOnly(new RollbackException("Transaction marked as rollback only."));
    }

    public int getStatus() {
        return this.status;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean enlistResource(XAResource resource) throws RollbackException, IllegalStateException, SystemException {
        if (log.isTraceEnabled()) {
            log.tracef("Transaction.enlistResource(%s) invoked in transaction with Xid=%s", resource, this.xid);
        }
        this.checkStatusBeforeRegister("resource");
        for (XaResourceData other : this.resources) {
            try {
                if (!other.xaResource.isSameRM(resource)) continue;
                log.debug("Ignoring resource. It is already there.");
                return true;
            }
            catch (XAException xAException) {
            }
        }
        Object object = this.xidLock;
        synchronized (object) {
            this.resources.add(new XaResourceData(resource));
        }
        try {
            if (log.isTraceEnabled()) {
                log.tracef("XaResource.start() invoked in transaction with Xid=%s", this.xid);
            }
            resource.start(this.xid, 0);
        }
        catch (XAException e) {
            if (TransactionImpl.isRollbackCode(e)) {
                RollbackException exception = TransactionImpl.newRollbackException(String.format("Resource %s rolled back the transaction while XaResource.start()", resource), e);
                this.markRollbackOnly(exception);
                log.errorEnlistingResource(e);
                throw exception;
            }
            log.errorEnlistingResource(e);
            throw new SystemException(e.getMessage());
        }
        return true;
    }

    public boolean delistResource(XAResource xaRes, int flag) throws IllegalStateException, SystemException {
        throw new SystemException("not supported");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerSynchronization(Synchronization sync) throws RollbackException, IllegalStateException {
        if (log.isTraceEnabled()) {
            log.tracef("Transaction.registerSynchronization(%s) invoked in transaction with Xid=%s", sync, this.xid);
        }
        this.checkStatusBeforeRegister("synchronization");
        if (log.isTraceEnabled()) {
            log.tracef("Registering synchronization handler %s", sync);
        }
        Object object = this.xidLock;
        synchronized (object) {
            this.syncs.add(sync);
        }
    }

    public Collection<XAResource> getEnlistedResources() {
        return Collections.unmodifiableList(this.resources.stream().map(xaResourceData -> xaResourceData.xaResource).collect(Collectors.toList()));
    }

    public boolean runPrepare() {
        return this.runPrepareAsync(DefaultResourceConverter.INSTANCE).toCompletableFuture().join();
    }

    public CompletionStage<Boolean> runPrepareAsync(TransactionResourceConverter resourceConverter) {
        TransactionResourceConverter converter;
        TransactionResourceConverter transactionResourceConverter = converter = resourceConverter == null ? DefaultResourceConverter.INSTANCE : resourceConverter;
        if (log.isTraceEnabled()) {
            log.tracef("asyncPrepare() invoked in transaction with Xid=%s", this.xid);
        }
        CompletionStage<Void> cf = this.asyncBeforeCompletion(converter);
        cf = cf.thenCompose(unused -> this.asyncEndXaResources(converter));
        return cf.thenCompose(unused -> {
            if (this.status == 1) {
                return CompletableFutures.completedFalse();
            }
            this.status = 7;
            return this.asyncPrepareXaResources(converter);
        });
    }

    public synchronized void runCommit(boolean forceRollback) throws HeuristicMixedException, HeuristicRollbackException, RollbackException {
        try {
            this.runCommitAsync(forceRollback, DefaultResourceConverter.INSTANCE).toCompletableFuture().get();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        catch (ExecutionException e) {
            Throwable cause = TransactionImpl.throwChecked(e.getCause());
            TransactionImpl.throwRuntimeException(cause);
        }
    }

    public CompletionStage<Void> runCommitAsync(boolean forceRollback, TransactionResourceConverter resourceConverter) {
        TransactionResourceConverter converter;
        TransactionResourceConverter transactionResourceConverter = converter = resourceConverter == null ? DefaultResourceConverter.INSTANCE : resourceConverter;
        if (log.isTraceEnabled()) {
            log.tracef("runCommit(forceRollback=%b) invoked in transaction with Xid=%s", forceRollback, this.xid);
        }
        if (forceRollback) {
            this.markRollbackOnly(new RollbackException(FORCE_ROLLBACK_MESSAGE));
        }
        boolean commit = this.status != 1;
        CompletionStage<Void> stage = this.asyncFinishXaResources(commit, converter);
        stage = stage.handle((__, t) -> {
            CompletionStage<Void> s = this.asyncAfterCompletion(commit ? 3 : 4, converter);
            if (t != null) {
                return s.thenAccept(___ -> {
                    throw CompletableFutures.asCompletionException(t);
                });
            }
            return s.thenAccept(___ -> CompletableFutures.rethrowExceptionIfPresent((Throwable)this.hasRollbackException(forceRollback)));
        }).thenCompose(CompletableFutures.identity());
        TransactionManagerImpl.dissociateTransaction();
        this.resources.clear();
        return stage;
    }

    public String toString() {
        return "TransactionImpl{xid=" + this.xid + ", status=" + Util.transactionStatusToString(this.status) + "}";
    }

    public XidImpl getXid() {
        return this.xid;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setXid(XidImpl xid) {
        Object object = this.xidLock;
        synchronized (object) {
            if (this.syncs.isEmpty() && this.resources.isEmpty()) {
                this.xid = xid;
            }
        }
    }

    public Collection<Synchronization> getEnlistedSynchronization() {
        return Collections.unmodifiableList(this.syncs);
    }

    public final int hashCode() {
        return this.xid.hashCode();
    }

    public final boolean equals(Object obj) {
        return this == obj;
    }

    private RollbackException hasRollbackException(boolean forceRollback) {
        if (this.firstRollbackException != null) {
            if (forceRollback && FORCE_ROLLBACK_MESSAGE.equals(this.firstRollbackException.getMessage())) {
                return null;
            }
            return this.firstRollbackException;
        }
        return null;
    }

    private void markRollbackOnly(RollbackException e) {
        if (this.status == 1) {
            return;
        }
        this.status = 1;
        if (this.firstRollbackException == null) {
            this.firstRollbackException = e;
        }
    }

    private CompletionStage<Void> asyncBeforeCompletion(TransactionResourceConverter converter) {
        Iterator<Synchronization> iterator = this.syncs.iterator();
        if (!iterator.hasNext()) {
            return CompletableFutures.completedNull();
        }
        CompletionStage<Void> cf = this.beforeCompletion(iterator.next(), converter);
        while (iterator.hasNext()) {
            Synchronization synchronization = iterator.next();
            cf = cf.thenCompose(unused -> this.beforeCompletion(synchronization, converter));
        }
        return cf;
    }

    private CompletionStage<Void> beforeCompletion(Synchronization s, TransactionResourceConverter converter) {
        if (log.isTraceEnabled()) {
            log.tracef("Synchronization.beforeCompletion() for %s", s);
        }
        return converter.convertSynchronization(s).asyncBeforeCompletion().exceptionally(t -> {
            this.beforeCompletionFailed(s, (Throwable)t);
            return null;
        });
    }

    private void beforeCompletionFailed(Synchronization s, Throwable t) {
        t = CompletableFutures.extractException(t);
        this.markRollbackOnly(TransactionImpl.newRollbackException(String.format("Synchronization.beforeCompletion() for %s wants to rollback.", s), t));
        log.beforeCompletionFailed(s.toString(), t);
    }

    private CompletionStage<Void> asyncAfterCompletion(int status, TransactionResourceConverter converter) {
        Iterator<Synchronization> iterator = this.syncs.iterator();
        if (!iterator.hasNext()) {
            return CompletableFutures.completedNull();
        }
        CompletionStage<Void> cf = TransactionImpl.afterCompletion(iterator.next(), status, converter);
        while (iterator.hasNext()) {
            Synchronization synchronization = iterator.next();
            cf = cf.thenCompose(unused -> TransactionImpl.afterCompletion(synchronization, status, converter));
        }
        this.syncs.clear();
        return cf;
    }

    private static CompletionStage<Void> afterCompletion(Synchronization s, int status, TransactionResourceConverter converter) {
        if (log.isTraceEnabled()) {
            log.tracef("Synchronization.afterCompletion() for %s", s);
        }
        return converter.convertSynchronization(s).asyncAfterCompletion(status).exceptionally(t -> {
            log.afterCompletionFailed(s.toString(), CompletableFutures.extractException(t));
            return null;
        });
    }

    private CompletionStage<Void> asyncEndXaResources(TransactionResourceConverter converter) {
        Iterator<XaResourceData> iterator = this.resources.iterator();
        if (!iterator.hasNext()) {
            return CompletableFutures.completedNull();
        }
        CompletionStage<Void> cf = this.endXaResource(iterator.next().xaResource, converter);
        while (iterator.hasNext()) {
            XAResource resource = iterator.next().xaResource;
            cf = cf.thenCompose(unused -> this.endXaResource(resource, converter));
        }
        return cf;
    }

    private CompletionStage<Void> endXaResource(XAResource resource, TransactionResourceConverter converter) {
        if (log.isTraceEnabled()) {
            log.tracef("XAResource.end() for %s", resource);
        }
        return converter.convertXaResource(resource).asyncEnd(this.xid, 0x4000000).exceptionally(t -> {
            this.endXaResourceFailed(resource, (Throwable)t);
            return null;
        });
    }

    private void endXaResourceFailed(XAResource resource, Throwable t) {
        String msg = (t = CompletableFutures.extractException(t)) instanceof XAException ? String.format("XaResource.end() for %s wants to rollback.", resource) : String.format("Unexpected error in XaResource.end() for %s. Marked as rollback", resource);
        this.markRollbackOnly(TransactionImpl.newRollbackException(msg, t));
        log.xaResourceEndFailed(resource.toString(), t);
    }

    private CompletionStage<Boolean> asyncPrepareXaResources(TransactionResourceConverter converter) {
        this.status = 7;
        Iterator<XaResourceData> iterator = this.resources.iterator();
        if (!iterator.hasNext()) {
            this.status = 2;
            return CompletableFutures.completedTrue();
        }
        CompletionStage<Boolean> cf = this.prepareXaResource(iterator.next(), converter);
        while (iterator.hasNext()) {
            XaResourceData data = iterator.next();
            cf = cf.thenCompose(prepared -> prepared != false ? this.prepareXaResource(data, converter) : CompletableFutures.completedFalse());
        }
        return cf.whenComplete((prepared, ___) -> {
            if (prepared.booleanValue()) {
                this.status = 2;
            }
        });
    }

    private CompletionStage<Boolean> prepareXaResource(XaResourceData data, TransactionResourceConverter converter) {
        if (log.isTraceEnabled()) {
            log.tracef("XaResource.prepare() for %s", data.xaResource);
        }
        return converter.convertXaResource(data.xaResource).asyncPrepare(this.xid).thenApply(status -> {
            data.status = status;
            return true;
        }).exceptionally(t -> {
            this.prepareXaResourceFailed(data.xaResource, (Throwable)t);
            return false;
        });
    }

    private void prepareXaResourceFailed(XAResource resource, Throwable t) {
        String msg;
        if ((t = CompletableFutures.extractException(t)) instanceof XAException) {
            if (log.isTraceEnabled()) {
                log.tracef(t, "XaResource.prepare() for %s wants to rollback.", resource);
            }
            msg = String.format("XaResource.prepare() for %s wants to rollback.", resource);
        } else {
            msg = String.format("Unexpected error in XaResource.prepare() for %s. Rollback transaction.", resource);
            log.unexpectedErrorFromResourceManager(t);
        }
        this.markRollbackOnly(TransactionImpl.newRollbackException(msg, t));
    }

    private CompletionStage<Void> asyncFinishXaResources(boolean commit, TransactionResourceConverter converter) {
        CompletionStage<Void> cf;
        Iterator<XaResourceData> iterator = this.resources.iterator();
        if (!iterator.hasNext()) {
            this.status = commit ? 3 : 4;
            return CompletableFutures.completedNull();
        }
        XaResultCollector collector = new XaResultCollector(this.resources.size(), commit);
        CompletionStage<Void> completionStage = cf = commit ? this.commitXaResource(iterator.next(), converter, collector) : this.rollbackXaResource(iterator.next(), converter, collector);
        while (iterator.hasNext()) {
            XaResourceData data = iterator.next();
            cf = cf.thenCompose(unused -> commit ? this.commitXaResource(data, converter, collector) : this.rollbackXaResource(data, converter, collector));
        }
        return cf.thenApply(unused -> {
            this.checkCollector(collector, commit);
            return null;
        });
    }

    private CompletionStage<Void> commitXaResource(XaResourceData data, TransactionResourceConverter converter, XaResultCollector collector) {
        if (data.status == 3) {
            log.tracef("Skipping XaResource.commit() since prepare status was XA_RDONLY for %s", data.xaResource);
            return CompletableFutures.completedNull();
        }
        if (log.isTraceEnabled()) {
            log.tracef("XaResource.commit() for %s", data.xaResource);
        }
        return converter.convertXaResource(data.xaResource).asyncCommit(this.xid, false).thenRun(collector).exceptionally(collector);
    }

    private CompletionStage<Void> rollbackXaResource(XaResourceData data, TransactionResourceConverter converter, XaResultCollector collector) {
        if (data.status == 3) {
            log.tracef("Skipping XaResource.rollback() since prepare status was XA_RDONLY for %s", data.xaResource);
            return CompletableFutures.completedNull();
        }
        if (log.isTraceEnabled()) {
            log.tracef("XaResource.rollback() for %s", data.xaResource);
        }
        return converter.convertXaResource(data.xaResource).asyncRollback(this.xid).thenRun(collector).exceptionally(collector);
    }

    private void checkCollector(XaResultCollector collector, boolean commit) {
        switch (collector.status()) {
            case ERROR: 
            case HEURISTIC_MIXED: {
                this.status = 5;
                HeuristicMixedException exception = new HeuristicMixedException();
                collector.addSuppressedTo((Throwable)exception);
                this.status = 5;
                throw CompletableFutures.asCompletionException((Throwable)exception);
            }
            case HEURISTIC_ROLLBACK: {
                HeuristicRollbackException e = new HeuristicRollbackException();
                collector.addSuppressedTo((Throwable)e);
                this.status = 5;
                throw CompletableFutures.asCompletionException((Throwable)e);
            }
        }
        this.status = commit ? 3 : 4;
    }

    private void checkStatusBeforeRegister(String component) throws RollbackException, IllegalStateException {
        if (this.status == 1) {
            throw new RollbackException("Transaction has been marked as rollback only");
        }
        if (this.isDone()) {
            throw new IllegalStateException(String.format("Transaction is done. Cannot register any more %s", component));
        }
    }

    private boolean isDone() {
        switch (this.status) {
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 9: {
                return true;
            }
        }
        return false;
    }

    private static class XaResultCollector
    implements Runnable,
    Function<Throwable, Void> {
        private TxCompletableStatus status = TxCompletableStatus.NONE;
        private final List<Throwable> exceptions;
        private final boolean commit;

        XaResultCollector(int capacity, boolean commit) {
            this.exceptions = new ArrayList<Throwable>(capacity);
            this.commit = commit;
        }

        @Override
        public synchronized void run() {
            if (this.status == TxCompletableStatus.NONE) {
                this.status = TxCompletableStatus.OK;
            } else if (this.status == TxCompletableStatus.HEURISTIC_ROLLBACK) {
                this.status = TxCompletableStatus.HEURISTIC_MIXED;
            }
        }

        @Override
        public synchronized Void apply(Throwable throwable) {
            block12: {
                block11: {
                    throwable = CompletableFutures.extractException(throwable);
                    log.errorCommittingTx(throwable);
                    this.exceptions.add(throwable);
                    if (!(throwable instanceof XAException)) break block11;
                    XAException e = (XAException)throwable;
                    switch (e.errorCode) {
                        case 5: 
                        case 6: 
                        case 7: {
                            if (this.status == TxCompletableStatus.NONE) {
                                this.status = TxCompletableStatus.HEURISTIC_ROLLBACK;
                                break;
                            }
                            if (this.status == TxCompletableStatus.OK) {
                                this.status = TxCompletableStatus.HEURISTIC_MIXED;
                                break;
                            }
                            break block12;
                        }
                        case -4: {
                            if (this.commit) {
                                if (this.status == TxCompletableStatus.NONE) {
                                    this.status = TxCompletableStatus.HEURISTIC_ROLLBACK;
                                    break;
                                }
                                if (this.status == TxCompletableStatus.OK) {
                                    this.status = TxCompletableStatus.HEURISTIC_MIXED;
                                    break;
                                }
                            } else if (this.status == TxCompletableStatus.NONE) {
                                this.status = TxCompletableStatus.OK;
                                break;
                            }
                            break block12;
                        }
                        default: {
                            this.status = TxCompletableStatus.ERROR;
                            break;
                        }
                    }
                    break block12;
                }
                this.status = TxCompletableStatus.ERROR;
            }
            return null;
        }

        synchronized TxCompletableStatus status() {
            return this.status;
        }

        synchronized void addSuppressedTo(Throwable t) {
            this.exceptions.forEach(t::addSuppressed);
        }
    }

    private static enum TxCompletableStatus {
        NONE,
        OK,
        HEURISTIC_ROLLBACK,
        HEURISTIC_MIXED,
        ERROR;

    }

    private static class XaResourceData {
        final XAResource xaResource;
        volatile int status;

        private XaResourceData(XAResource xaResource) {
            this.xaResource = Objects.requireNonNull(xaResource);
        }
    }
}

