/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.commons.dataconversion;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Queue;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.infinispan.commons.dataconversion.EncodingException;
import org.infinispan.commons.dataconversion.MediaType;
import org.infinispan.commons.test.Exceptions;
import org.junit.Assert;
import org.junit.Test;

public class MediaTypeTest {
    @Test
    public void testParsingTypeSubType() {
        MediaType appJson = MediaType.fromString((String)"application/json");
        this.assertMediaTypeNoParams(appJson, "application", "json");
    }

    @Test(expected=EncodingException.class)
    public void testParsingMultipleSubType() {
        MediaType.fromString((String)"application/json/on");
    }

    @Test
    public void testParsingNoType() {
        Exceptions.expectException(EncodingException.class, () -> MediaType.fromString((String)""));
        Exceptions.expectException(EncodingException.class, () -> MediaType.fromString((String)";param=value"));
    }

    @Test(expected=EncodingException.class)
    public void testParsingNoSubType() {
        MediaType.fromString((String)"something");
    }

    @Test(expected=EncodingException.class)
    public void testParsingNoSubType2() {
        MediaType.fromString((String)"application; charset=utf-8");
    }

    @Test(expected=EncodingException.class)
    public void testParsingNull() {
        MediaType.fromString(null);
    }

    @Test(expected=EncodingException.class)
    public void testParsingWhitespaceInType() {
        MediaType.fromString((String)"application /json");
    }

    @Test(expected=EncodingException.class)
    public void testParsingWhitespaceInSubtype() {
        MediaType.fromString((String)"application/ json");
    }

    @Test(expected=EncodingException.class)
    public void testParsingWhitespaceInTypeSubtype() {
        MediaType.fromString((String)"application  / json");
    }

    @Test(expected=EncodingException.class)
    public void testParsingWhitespaceInParamName() {
        MediaType.fromString((String)"application/json; charset =utf-8");
    }

    @Test
    public void testQuotedParam() {
        MediaType mediaType = MediaType.fromString((String)"application/json; charset=\"UTF-8\"");
        this.assertMediaTypeWithParam(mediaType, "application", "json", "charset", "\"UTF-8\"");
    }

    @Test
    public void testQuotedParamsWithWhitespace() {
        MediaType mediaType = MediaType.fromString((String)"application/json; charset=\" UTF-8 \"");
        this.assertMediaTypeWithParam(mediaType, "application", "json", "charset", "\" UTF-8 \"");
    }

    @Test
    public void testQuotedParamsEscaping() {
        MediaType mediaType = MediaType.fromString((String)"application/json; charset=\"\\\"UTF-8\\\"\"");
        this.assertMediaTypeWithParam(mediaType, "application", "json", "charset", "\"\\\"UTF-8\\\"\"");
        MediaType mediaType2 = MediaType.fromString((String)"application/json; charset=\"\\a\\\"\\\\\"");
        this.assertMediaTypeWithParam(mediaType2, "application", "json", "charset", "\"\\a\\\"\\\\\"");
        Exceptions.expectException(EncodingException.class, () -> MediaType.fromString((String)"application/json; charset=\"\\\""));
    }

    @Test
    public void testUnquotedParamWithSingleQuote() {
        MediaType mediaType = MediaType.fromString((String)"application/json; charset='UTF-8'");
        this.assertMediaTypeWithParam(mediaType, "application", "json", "charset", "'UTF-8'");
        Exceptions.expectException(EncodingException.class, () -> MediaType.fromString((String)"application/json; charset='UTF 8'"));
    }

    @Test
    public void testUnQuotedParam() {
        MediaType mediaType = MediaType.fromString((String)"application/json; charset=UTF-8");
        this.assertMediaTypeWithParam(mediaType, "application", "json", "charset", "UTF-8");
        Exceptions.expectException(EncodingException.class, () -> MediaType.fromString((String)"application/json; charset=utf 8"));
    }

    @Test
    public void testToString() {
        Assert.assertEquals((Object)"application/xml; q=0.9", (Object)new MediaType("application", "xml", Map.of("q", "0.9")).toString());
        Assert.assertEquals((Object)"text/csv", (Object)new MediaType("text", "csv").toString());
        Assert.assertEquals((Object)"foo/bar; a=2", (Object)new MediaType("foo", "bar", Map.of("a", "2")).toString());
        String type = new MediaType("foo", "bar", Map.of("a", "2", "b", "1", "c", "2")).toString();
        Assert.assertTrue((boolean)type.startsWith("foo/bar; "));
        Assert.assertTrue((boolean)type.contains("; a=2"));
        Assert.assertTrue((boolean)type.contains("; b=1"));
        Assert.assertTrue((boolean)type.contains("; c=2"));
        Assert.assertEquals((Object)"a/b; p=1", (Object)MediaType.fromString((String)"a/b; p=1; q=2").toStringExcludingParam(new String[]{"q"}));
    }

    @Test
    public void testToStringQuotedParams() {
        MediaType mediaType = MediaType.fromString((String)"a/b; p=\"\"; r=\"\\\"\"");
        Assert.assertEquals((Object)mediaType, (Object)MediaType.fromString((String)mediaType.toString()));
    }

    @Test(expected=EncodingException.class)
    public void testUnQuotedParamWithSpaces() {
        MediaType mediaType = MediaType.fromString((String)"application/json ; charset= UTF-8");
    }

    @Test(expected=EncodingException.class)
    public void testWrongQuoting() {
        MediaType.fromString((String)"application/json;charset= \"UTF-8");
    }

    @Test
    public void testMultipleParameters() {
        MediaType mediaType = MediaType.fromString((String)"application/json; charset=UTF-8; param1=value1 ;param2=value2");
        this.assertMediaTypeWithParams(mediaType, "application", "json", new String[]{"charset", "param1", "param2"}, new String[]{"UTF-8", "value1", "value2"});
    }

    @Test(expected=EncodingException.class)
    public void testMultipleParametersWrongSeparator() {
        MediaType.fromString((String)"application/json; charset=UTF-8; param1=value1, param2=value2");
    }

    @Test
    public void testParseWeight() {
        MediaType mediaType = MediaType.fromString((String)"application/json; q=0.8");
        Assert.assertEquals((double)0.8, (double)mediaType.getWeight(), (double)0.0);
    }

    @Test(expected=EncodingException.class)
    public void testParseInvalidWeight() {
        MediaType.fromString((String)"application/json ; q=high");
    }

    @Test
    public void testDefaultWeight() {
        MediaType mediaType = MediaType.fromString((String)"application/json");
        Assert.assertEquals((double)1.0, (double)mediaType.getWeight(), (double)0.0);
    }

    @Test
    public void testWildCard() {
        MediaType mediaType = MediaType.fromString((String)"*/*");
        Assert.assertEquals((Object)"*", (Object)mediaType.getType());
        Assert.assertEquals((Object)"*", (Object)mediaType.getSubType());
        Assert.assertTrue((boolean)mediaType.match(MediaType.TEXT_PLAIN));
        Assert.assertTrue((boolean)mediaType.match(MediaType.APPLICATION_PROTOSTREAM));
    }

    @Test
    public void testWildCard2() {
        MediaType mediaType = MediaType.fromString((String)"*");
        Assert.assertEquals((Object)"*", (Object)mediaType.getType());
        Assert.assertEquals((Object)"*", (Object)mediaType.getSubType());
    }

    @Test
    public void testParseList() {
        List mediaTypes = MediaType.parseList((String)"text/html, image/png,*/*").collect(Collectors.toList());
        Assert.assertEquals(Arrays.asList(MediaType.TEXT_HTML, MediaType.IMAGE_PNG, MediaType.MATCH_ALL), mediaTypes);
        Exceptions.expectException(EncodingException.class, () -> MediaType.parseList((String)"text/html,"));
        Exceptions.expectException(EncodingException.class, () -> MediaType.parseList((String)"text/html;a=b,"));
        Exceptions.expectException(EncodingException.class, () -> MediaType.parseList((String)"text/html;a=b,;b=c"));
        Exceptions.expectException(EncodingException.class, () -> MediaType.parseList((String)"text/html;a=b,image/png/"));
        List mediaTypes2 = MediaType.parseList((String)"text/html;a=\"b,\" ,*/*").collect(Collectors.toList());
        Assert.assertEquals(Arrays.asList(MediaType.TEXT_HTML.withParameter("a", "\"b,\""), MediaType.MATCH_ALL), mediaTypes2);
    }

    @Test
    public void testParseBrowserRequest() {
        Stream list = MediaType.parseList((String)"text/html,application/xhtml+xml,application/xml;q=0.9,*/*;q=0.8");
        Iterator iterator = list.iterator();
        Assert.assertEquals((Object)"text/html", (Object)((MediaType)iterator.next()).getTypeSubtype());
        Assert.assertEquals((Object)"application/xhtml+xml", (Object)((MediaType)iterator.next()).getTypeSubtype());
        Assert.assertEquals((Object)"application/xml", (Object)((MediaType)iterator.next()).getTypeSubtype());
        Assert.assertEquals((Object)"*/*", (Object)((MediaType)iterator.next()).getTypeSubtype());
    }

    @Test
    public void testParseSingleAsterix() {
        List list = MediaType.parseList((String)"text/html, image/gif, image/jpeg, *; q=.2, */*; q=.2").map(MediaType::getTypeSubtype).collect(Collectors.toList());
        Assert.assertEquals(Arrays.asList("text/html", "image/gif", "image/jpeg", "*/*", "*/*"), list);
    }

    @Test
    public void testNegotiations() {
        Stream mediaTypes = MediaType.parseList((String)"text/html; q=0.8,*/*;q=0.2,application/json");
        Iterator iterator = mediaTypes.iterator();
        MediaType preferred = (MediaType)iterator.next();
        MediaType secondChoice = (MediaType)iterator.next();
        MediaType everythingElse = (MediaType)iterator.next();
        Assert.assertEquals((Object)MediaType.APPLICATION_JSON, (Object)preferred);
        Assert.assertEquals((Object)"text/html", (Object)secondChoice.getTypeSubtype());
        Assert.assertEquals((Object)"*/*", (Object)everythingElse.getTypeSubtype());
    }

    @Test
    public void testMediaTypeMatch() {
        MediaType one = MediaType.APPLICATION_JSON;
        MediaType two = MediaType.APPLICATION_JSON;
        Assert.assertTrue((boolean)one.match(two));
        Assert.assertTrue((boolean)two.match(one));
    }

    @Test
    public void testMediaTypeUnMatch() {
        MediaType one = MediaType.APPLICATION_JSON;
        MediaType two = MediaType.APPLICATION_JAVASCRIPT;
        Assert.assertFalse((boolean)one.match(two));
        Assert.assertFalse((boolean)two.match(one));
    }

    @Test
    public void testMediaTypeMatchItself() {
        MediaType one = MediaType.APPLICATION_JSON;
        Assert.assertTrue((boolean)one.match(one));
    }

    @Test
    public void testMediaTypeExternalizerNoId() throws Exception {
        ObjectInOut inOutOrig = new ObjectInOut();
        MediaType.MediaTypeExternalizer mediaTypeExternalizer = new MediaType.MediaTypeExternalizer();
        mediaTypeExternalizer.writeObject((ObjectOutput)inOutOrig, MediaType.APPLICATION_XML);
        MediaType mediaType = mediaTypeExternalizer.readObject((ObjectInput)inOutOrig);
        this.assertMediaTypeNoParams(mediaType, "application", "xml");
    }

    @Test
    public void testMediaTypeExternalizerId() throws Exception {
        ObjectInOut inOutOrig = new ObjectInOut();
        MediaType.MediaTypeExternalizer mediaTypeExternalizer = new MediaType.MediaTypeExternalizer();
        mediaTypeExternalizer.writeObject((ObjectOutput)inOutOrig, MediaType.TEXT_PLAIN);
        MediaType mediaType = mediaTypeExternalizer.readObject((ObjectInput)inOutOrig);
        this.assertMediaTypeNoParams(mediaType, "text", "plain");
    }

    private void assertMediaTypeNoParams(MediaType mediaType, String type, String subType) {
        Assert.assertEquals((Object)type, (Object)mediaType.getType());
        Assert.assertEquals((Object)subType, (Object)mediaType.getSubType());
        Assert.assertFalse((boolean)mediaType.hasParameters());
        Assert.assertEquals(Optional.empty(), (Object)mediaType.getParameter("a"));
    }

    private void assertMediaTypeWithParam(MediaType mediaType, String type, String subType, String paramName, String paramValue) {
        this.assertMediaTypeWithParams(mediaType, type, subType, new String[]{paramName}, new String[]{paramValue});
    }

    private void assertMediaTypeWithParams(MediaType mediaType, String type, String subType, String[] paramNames, String[] paramValues) {
        Assert.assertEquals((Object)type, (Object)mediaType.getType());
        Assert.assertEquals((Object)subType, (Object)mediaType.getSubType());
        Assert.assertTrue((boolean)mediaType.hasParameters());
        for (int i = 0; i < paramNames.length; ++i) {
            String paramName = paramNames[i];
            String paramValue = paramValues[i];
            Assert.assertEquals(Optional.of(paramValue), (Object)mediaType.getParameter(paramName));
        }
    }

    private static class ObjectInOut
    implements ObjectInput,
    ObjectOutput {
        private final Queue<Object> buffer = new LinkedList<Object>();

        private ObjectInOut() {
        }

        @Override
        public Object readObject() throws ClassNotFoundException, IOException {
            return this.buffer.remove();
        }

        @Override
        public int read() {
            throw new UnsupportedOperationException();
        }

        @Override
        public int read(byte[] b) {
            throw new UnsupportedOperationException();
        }

        @Override
        public int read(byte[] b, int off, int len) {
            throw new UnsupportedOperationException();
        }

        @Override
        public long skip(long n) {
            throw new UnsupportedOperationException();
        }

        @Override
        public int available() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void writeObject(Object obj) throws IOException {
            this.buffer.add(obj);
        }

        @Override
        public void write(int b) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void write(byte[] b) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void write(byte[] b, int off, int len) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void writeBoolean(boolean v) {
            this.buffer.add(v);
        }

        @Override
        public void writeByte(int v) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void writeShort(int v) {
            this.buffer.add((short)v);
        }

        @Override
        public void writeChar(int v) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void writeInt(int v) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void writeLong(long v) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void writeFloat(float v) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void writeDouble(double v) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void writeBytes(String s) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void writeChars(String s) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void writeUTF(String s) {
            this.buffer.add(s);
        }

        @Override
        public void flush() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void close() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void readFully(byte[] b) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void readFully(byte[] b, int off, int len) {
            throw new UnsupportedOperationException();
        }

        @Override
        public int skipBytes(int n) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean readBoolean() {
            return (Boolean)this.buffer.remove();
        }

        @Override
        public byte readByte() {
            throw new UnsupportedOperationException();
        }

        @Override
        public int readUnsignedByte() {
            throw new UnsupportedOperationException();
        }

        @Override
        public short readShort() {
            return (Short)this.buffer.remove();
        }

        @Override
        public int readUnsignedShort() {
            throw new UnsupportedOperationException();
        }

        @Override
        public char readChar() {
            throw new UnsupportedOperationException();
        }

        @Override
        public int readInt() {
            throw new UnsupportedOperationException();
        }

        @Override
        public long readLong() {
            throw new UnsupportedOperationException();
        }

        @Override
        public float readFloat() {
            throw new UnsupportedOperationException();
        }

        @Override
        public double readDouble() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String readLine() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String readUTF() {
            return (String)this.buffer.remove();
        }
    }
}

