/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.commons.hash;

import java.util.Random;
import org.infinispan.commons.hash.MurmurHash3;
import org.infinispan.commons.hash.MurmurHash3Old;
import org.junit.Assert;
import org.junit.Test;

public class MurmurHash3StringCompatTest {
    private static final long NUM_KEYS = 100000L;
    private static final int MAX_KEY_SIZE = 5;

    @Test
    public void compareHashes() {
        Random random = new Random(9005L);
        int i = 0;
        while ((long)i < 100000L) {
            int cpLen = Math.abs(random.nextInt(5) - random.nextInt(5)) + 1;
            int[] codePoints = random.ints(cpLen, 0, 0x110000).filter(Character::isDefined).toArray();
            String s = new String(codePoints, 0, codePoints.length);
            this.testString(s);
            ++i;
        }
    }

    private void testString(String s) {
        int h1 = MurmurHash3Old.getInstance().hash(s);
        int h2 = MurmurHash3.getInstance().hash((Object)s);
        Assert.assertEquals((long)h1, (long)h2);
    }
}

