/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.commons.dataconversion;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import org.infinispan.commons.configuration.ClassAllowList;
import org.infinispan.commons.dataconversion.Base16Codec;
import org.infinispan.commons.dataconversion.DefaultTranscoder;
import org.infinispan.commons.dataconversion.MediaType;
import org.infinispan.commons.marshall.JavaSerializationMarshaller;
import org.infinispan.commons.marshall.Marshaller;
import org.infinispan.commons.util.KeyValueWithPrevious;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class DefaultTranscoderTest {
    private static DefaultTranscoder defaultTranscoder;
    private static JavaSerializationMarshaller marshaller;

    @BeforeClass
    public static void prepare() {
        ClassAllowList allowList = new ClassAllowList();
        allowList.addRegexps(new String[]{".*"});
        marshaller = new JavaSerializationMarshaller(allowList);
        defaultTranscoder = new DefaultTranscoder((Marshaller)marshaller);
    }

    @Test
    public void testObjectOctetStream() throws Exception {
        String string = "string-data";
        byte[] byteArray = new byte[]{1, 2, 3};
        KeyValueWithPrevious pojo = new KeyValueWithPrevious((Object)"string", (Object)1L, (Object)0L);
        this.testObjectOctetStream("string-data", "string-data".getBytes(StandardCharsets.UTF_8));
        this.testObjectOctetStream(byteArray, byteArray);
        this.testObjectOctetStream(pojo, marshaller.objectToByteBuffer((Object)pojo));
    }

    private void testObjectOctetStream(Object data, byte[] expectOctetStream) {
        Object toOctetStream = defaultTranscoder.transcode(data, MediaType.APPLICATION_OBJECT, MediaType.APPLICATION_OCTET_STREAM);
        Object toOctetStreamHex = defaultTranscoder.transcode(data, MediaType.APPLICATION_OBJECT, this.hexEncoded(MediaType.APPLICATION_OCTET_STREAM));
        Object toOctetStreamBase64 = defaultTranscoder.transcode(data, MediaType.APPLICATION_OBJECT, this.base64Encoded(MediaType.APPLICATION_OCTET_STREAM));
        this.assertSame(expectOctetStream, toOctetStream);
        this.assertSame(Base16Codec.encode((byte[])expectOctetStream), toOctetStreamHex);
        this.assertSame(Base64.getEncoder().encode(expectOctetStream), toOctetStreamBase64);
        Object fromOctetStream = defaultTranscoder.transcode(toOctetStream, MediaType.APPLICATION_OCTET_STREAM, MediaType.APPLICATION_OBJECT);
        Object fromOctetStreamHex = defaultTranscoder.transcode(toOctetStreamHex, this.hexEncoded(MediaType.APPLICATION_OCTET_STREAM), MediaType.APPLICATION_OBJECT);
        Object fromOctetStreamBase64 = defaultTranscoder.transcode(toOctetStreamBase64, this.base64Encoded(MediaType.APPLICATION_OCTET_STREAM), MediaType.APPLICATION_OBJECT);
        this.assertSame(expectOctetStream, fromOctetStream);
        this.assertSame(expectOctetStream, fromOctetStreamHex);
        this.assertSame(expectOctetStream, fromOctetStreamBase64);
    }

    @Test
    public void testObjectUrlEncoded() throws Exception {
        String data = "word1 word2";
        String encoded = URLEncoder.encode(data, "utf-8");
        byte[] encodedUTF = encoded.getBytes(StandardCharsets.UTF_8);
        Object toObject = defaultTranscoder.transcode((Object)encodedUTF, MediaType.APPLICATION_WWW_FORM_URLENCODED, MediaType.APPLICATION_OBJECT);
        Assert.assertEquals((Object)data, (Object)toObject);
        Object fromObject = defaultTranscoder.transcode(toObject, MediaType.APPLICATION_OBJECT, MediaType.APPLICATION_WWW_FORM_URLENCODED);
        this.assertSame(encodedUTF, fromObject);
    }

    @Test
    public void testObjectText() throws Exception {
        String textData = "this is text";
        byte[] utf8 = textData.getBytes(StandardCharsets.UTF_8);
        Object textPlain = defaultTranscoder.transcode((Object)textData, MediaType.APPLICATION_OBJECT, MediaType.TEXT_PLAIN);
        this.assertSame(utf8, textPlain);
        Object object = defaultTranscoder.transcode(textPlain, MediaType.TEXT_PLAIN, MediaType.APPLICATION_OBJECT.withClassType(String.class));
        Assert.assertEquals((Object)textData, (Object)object);
        Object fromText = defaultTranscoder.transcode(textPlain, MediaType.TEXT_PLAIN, MediaType.APPLICATION_OBJECT);
        this.assertSame(textData, fromText);
    }

    @Test
    public void testOctetStreamUrlEncoded() throws UnsupportedEncodingException {
        String data = "word1 word2";
        byte[] urlEncoded = URLEncoder.encode(data, "utf-8").getBytes(StandardCharsets.UTF_8);
        byte[] utf8 = data.getBytes(StandardCharsets.UTF_8);
        Object toOctetStream = defaultTranscoder.transcode((Object)urlEncoded, MediaType.APPLICATION_WWW_FORM_URLENCODED, MediaType.APPLICATION_OCTET_STREAM);
        Object toOctetStreamHex = defaultTranscoder.transcode((Object)data, MediaType.APPLICATION_WWW_FORM_URLENCODED, this.hexEncoded(MediaType.APPLICATION_OCTET_STREAM));
        Object toOctetStream64 = defaultTranscoder.transcode((Object)data, MediaType.APPLICATION_WWW_FORM_URLENCODED, this.base64Encoded(MediaType.APPLICATION_OCTET_STREAM));
        this.assertSame(utf8, toOctetStream);
        this.assertSame(Base16Codec.encode((byte[])utf8), toOctetStreamHex);
        this.assertSame(Base64.getEncoder().encode(utf8), toOctetStream64);
        Object fromOctetStream = defaultTranscoder.transcode(toOctetStream, MediaType.APPLICATION_OCTET_STREAM, MediaType.APPLICATION_WWW_FORM_URLENCODED);
        Object fromOctetStreamHex = defaultTranscoder.transcode(toOctetStreamHex, this.hexEncoded(MediaType.APPLICATION_OCTET_STREAM), MediaType.APPLICATION_WWW_FORM_URLENCODED);
        Object fromOctetStream64 = defaultTranscoder.transcode(toOctetStream64, this.base64Encoded(MediaType.APPLICATION_OCTET_STREAM), MediaType.APPLICATION_WWW_FORM_URLENCODED);
        this.assertSame(urlEncoded, fromOctetStream);
        this.assertSame(urlEncoded, fromOctetStreamHex);
        this.assertSame(urlEncoded, fromOctetStream64);
    }

    @Test
    public void testOctetStreamText() {
        String text = "word1 word2";
        byte[] utf8 = text.getBytes(StandardCharsets.UTF_8);
        Object toOctetStream = defaultTranscoder.transcode((Object)text, MediaType.TEXT_PLAIN, MediaType.APPLICATION_OCTET_STREAM);
        Object toOctetStreamHex = defaultTranscoder.transcode((Object)text, MediaType.TEXT_PLAIN, this.hexEncoded(MediaType.APPLICATION_OCTET_STREAM));
        Object toOctetStream64 = defaultTranscoder.transcode((Object)text, MediaType.TEXT_PLAIN, this.base64Encoded(MediaType.APPLICATION_OCTET_STREAM));
        this.assertSame(utf8, toOctetStream);
        Assert.assertEquals((Object)Base16Codec.encode((byte[])utf8), (Object)toOctetStreamHex);
        this.assertSame(Base64.getEncoder().encode(utf8), toOctetStream64);
        Object toOctetStreamFromByteArray = defaultTranscoder.transcode((Object)utf8, MediaType.TEXT_PLAIN, MediaType.APPLICATION_OCTET_STREAM);
        Object toOctetStreamHexFromByteArray = defaultTranscoder.transcode((Object)utf8, MediaType.TEXT_PLAIN, this.hexEncoded(MediaType.APPLICATION_OCTET_STREAM));
        Object toOctetStream64FromByteArray = defaultTranscoder.transcode((Object)utf8, MediaType.TEXT_PLAIN, this.base64Encoded(MediaType.APPLICATION_OCTET_STREAM));
        this.assertSame(utf8, toOctetStreamFromByteArray);
        Assert.assertEquals((Object)Base16Codec.encode((byte[])utf8), (Object)toOctetStreamHexFromByteArray);
        this.assertSame(Base64.getEncoder().encode(utf8), toOctetStream64FromByteArray);
        Object fromOctetStream = defaultTranscoder.transcode(toOctetStream, MediaType.APPLICATION_OCTET_STREAM, MediaType.TEXT_PLAIN);
        Object fromOctetStreamHex = defaultTranscoder.transcode(toOctetStreamHex, this.hexEncoded(MediaType.APPLICATION_OCTET_STREAM), MediaType.TEXT_PLAIN);
        Object fromOctetStream64 = defaultTranscoder.transcode(toOctetStream64, this.base64Encoded(MediaType.APPLICATION_OCTET_STREAM), MediaType.TEXT_PLAIN);
        this.assertSame(utf8, fromOctetStream);
        this.assertSame(utf8, fromOctetStreamHex);
        this.assertSame(utf8, fromOctetStream64);
    }

    @Test
    public void testTextUrlEncoded() throws Exception {
        String textData = "this is text";
        byte[] urlEncoded = URLEncoder.encode(textData, "utf-8").getBytes(StandardCharsets.UTF_8);
        Object encodedText = defaultTranscoder.transcode((Object)textData, MediaType.TEXT_PLAIN, MediaType.APPLICATION_WWW_FORM_URLENCODED);
        this.assertSame(urlEncoded, encodedText);
        Object toText = defaultTranscoder.transcode(encodedText, MediaType.APPLICATION_WWW_FORM_URLENCODED, MediaType.TEXT_PLAIN);
        this.assertSame(textData.getBytes(StandardCharsets.UTF_8), toText);
    }

    private MediaType hexEncoded(MediaType mediaType) {
        return mediaType.withParameter("encoding", "hex");
    }

    private MediaType base64Encoded(MediaType mediaType) {
        return mediaType.withParameter("encoding", "base64");
    }

    private void assertSame(Object expected, Object obtained) {
        if (expected instanceof byte[]) {
            Assert.assertArrayEquals((byte[])((byte[])expected), (byte[])((byte[])obtained));
        } else {
            Assert.assertEquals((Object)expected, (Object)obtained);
        }
    }
}

