/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.commons.util;

import org.infinispan.commons.util.ByteQuantity;
import org.junit.Assert;
import org.junit.Test;

public class ByteQuantityParserTest {
    @Test
    public void testParse() {
        this.assertIllegal("");
        this.assertIllegal("1.23.5");
        this.assertIllegal("1,23");
        this.assertIllegal("10.2");
        this.assertIllegal("10.2 kB");
        this.assertIllegal("0.0000001 MB");
        this.assertIllegal("100000000000000000000 GB");
        Assert.assertEquals((long)0L, (long)ByteQuantity.parse((String)"0"));
        Assert.assertEquals((long)-1L, (long)ByteQuantity.parse((String)"-1"));
        Assert.assertEquals((long)-1239L, (long)ByteQuantity.parse((String)"-1239"));
        Assert.assertEquals((long)250000L, (long)ByteQuantity.parse((String)"250000 B"));
        Assert.assertEquals((long)1000L, (long)ByteQuantity.parse((String)"1000"));
        Assert.assertEquals((long)1000L, (long)ByteQuantity.parse((String)"1KB"));
        Assert.assertEquals((long)1024L, (long)ByteQuantity.parse((String)"1KiB"));
        Assert.assertEquals((long)1000L, (long)ByteQuantity.parse((String)"1 KB"));
        Assert.assertEquals((long)1000L, (long)ByteQuantity.parse((String)"1  KB"));
        Assert.assertEquals((long)1000000L, (long)ByteQuantity.parse((String)"1 MB"));
        Assert.assertEquals((long)0x100000L, (long)ByteQuantity.parse((String)"1 MiB"));
        Assert.assertEquals((long)1523000L, (long)ByteQuantity.parse((String)"1.523 MB"));
        Assert.assertEquals((long)100000L, (long)ByteQuantity.parse((String)"0.1 MB"));
        Assert.assertEquals((long)1L, (long)ByteQuantity.parse((String)"0.000001 MB"));
        Assert.assertEquals((long)10000000000L, (long)ByteQuantity.parse((String)"10GB"));
        Assert.assertEquals((long)1000000000000L, (long)ByteQuantity.parse((String)"1TB"));
        Assert.assertEquals((long)0x10000000000L, (long)ByteQuantity.parse((String)"1TiB"));
        Assert.assertEquals((long)100000000000000L, (long)ByteQuantity.parse((String)"100TB"));
    }

    private void assertIllegal(String text) {
        Assert.assertThrows(IllegalArgumentException.class, () -> ByteQuantity.parse((String)text));
    }
}

