/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.commons.configuration.attributes;

import java.io.File;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.file.FileVisitOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.infinispan.commons.CacheConfigurationException;
import org.infinispan.commons.configuration.Combine;
import org.infinispan.commons.configuration.attributes.Attribute;
import org.infinispan.commons.configuration.attributes.AttributeDefinition;
import org.infinispan.commons.configuration.attributes.AttributeSet;
import org.infinispan.commons.configuration.attributes.TypedPropertiesAttributeCopier;
import org.infinispan.commons.util.TypedProperties;
import org.junit.Assert;
import org.junit.Test;

public class AttributeTest {
    @Test
    public void testAttributeDefinitionType() {
        AttributeDefinition def = AttributeDefinition.builder((String)"long", (Object)10L).build();
        Assert.assertEquals(Long.class, (Object)def.getType());
        AttributeDefinition def2 = AttributeDefinition.builder((String)"string", null, String.class).build();
        Assert.assertEquals(String.class, (Object)def2.getType());
    }

    @Test
    public void testAttributeSetProtection() {
        AttributeDefinition immutable = AttributeDefinition.builder((String)"immutable", (Object)"").immutable().build();
        AttributeDefinition mutable = AttributeDefinition.builder((String)"mutable", (Object)"").build();
        AttributeSet set = new AttributeSet(this.getClass(), new AttributeDefinition[]{immutable, mutable});
        set.attribute(immutable).set((Object)"an immutable string");
        set.attribute(mutable).set((Object)"a mutable string");
        set = set.protect();
        try {
            set.attribute(immutable).set((Object)"this should fail");
            Assert.fail((String)"Changing an immutable attribute on a protected set should fail");
        }
        catch (Exception exception) {
            // empty catch block
        }
        set.attribute(mutable).set((Object)"this should work");
    }

    @Test
    public void testAttributeChanges() {
        AttributeDefinition def = AttributeDefinition.builder((String)"test", (Object)false).build();
        Attribute attribute = def.toAttribute();
        Assert.assertFalse((boolean)attribute.isModified());
        attribute.set((Object)true);
        Assert.assertEquals((Object)true, (Object)attribute.get());
        Assert.assertTrue((boolean)attribute.isModified());
    }

    @Test
    public void testAttributeInitializer() {
        AttributeDefinition def = AttributeDefinition.builder((String)"props", null, Properties.class).initializer(Properties::new).build();
        Attribute attribute1 = def.toAttribute();
        Attribute attribute2 = def.toAttribute();
        Assert.assertNotSame((Object)attribute1.get(), (Object)attribute2.get());
    }

    @Test
    public void testDefaultAttributeCopy() {
        AttributeDefinition def = AttributeDefinition.builder((String)"test", (Object)false).build();
        AttributeSet set1 = new AttributeSet("set", new AttributeDefinition[]{def});
        set1.attribute(def).set((Object)true);
        AttributeSet set2 = new AttributeSet("set", new AttributeDefinition[]{def});
        set2.read(set1, Combine.DEFAULT);
        Assert.assertEquals((Object)set1.attribute(def).get(), (Object)set2.attribute(def).get());
    }

    @Test
    public void testAttributeOverride() {
        AttributeDefinition one = AttributeDefinition.builder((String)"one", (Object)false).build();
        AttributeDefinition two = AttributeDefinition.builder((String)"two", (Object)false).build();
        AttributeSet set1 = new AttributeSet("set", new AttributeDefinition[]{one, two});
        set1.attribute(one).set((Object)true);
        AttributeSet set2 = new AttributeSet("set", new AttributeDefinition[]{one, two});
        set2.attribute(two).set((Object)true);
        set2.read(set1, new Combine(Combine.RepeatedAttributes.OVERRIDE, Combine.Attributes.OVERRIDE));
        Assert.assertEquals((Object)set1.attribute(one).get(), (Object)set2.attribute(one).get());
        Assert.assertFalse((boolean)set2.attribute(two).isModified());
    }

    @Test
    public void testCollectionAttributeCopy() {
        AttributeDefinition def = AttributeDefinition.builder((String)"properties", null, TypedProperties.class).copier(TypedPropertiesAttributeCopier.INSTANCE).initializer(TypedProperties::new).build();
        AttributeSet set1 = new AttributeSet("set", new AttributeDefinition[]{def});
        TypedProperties typedProperties = (TypedProperties)set1.attribute(def).get();
        typedProperties.setProperty("key", "value");
        set1.attribute(def).set((Object)typedProperties);
        set1 = set1.protect();
        typedProperties = (TypedProperties)set1.attribute(def).get();
        typedProperties.setProperty("key", "anotherValue");
        AttributeSet set2 = new AttributeSet("set", new AttributeDefinition[]{def});
        set2.read(set1, Combine.DEFAULT);
    }

    @Test
    public void testCustomAttributeCopier() {
        AttributeDefinition def = AttributeDefinition.builder((String)"test", Arrays.asList("a", "b")).copier(attribute -> {
            if (attribute == null) {
                return null;
            }
            return new ArrayList(attribute);
        }).build();
        AttributeSet set1 = new AttributeSet("set", new AttributeDefinition[]{def});
        set1.attribute(def).set(Arrays.asList("b", "a"));
        AttributeSet set2 = new AttributeSet("set", new AttributeDefinition[]{def});
        set2.read(set1, Combine.DEFAULT);
        Assert.assertEquals((Object)set1.attribute(def).get(), (Object)set2.attribute(def).get());
        Assert.assertNotSame((Object)set1.attribute(def).get(), (Object)set2.attribute(def).get());
    }

    @Test
    public void testAttributeListener() {
        AttributeDefinition def = AttributeDefinition.builder((String)"test", (Object)false).build();
        Attribute attribute = def.toAttribute();
        Holder<Boolean> listenerInvoked = new Holder<Boolean>(false);
        attribute.addListener((attribute1, oldValue) -> {
            Assert.assertTrue((boolean)((Boolean)attribute1.get()));
            Assert.assertFalse((boolean)oldValue);
            listenerInvoked.set(true);
        });
        attribute.set((Object)true);
        Assert.assertTrue((String)"Attribute listener was not invoked", (boolean)listenerInvoked.get());
    }

    @Test
    public void testAttributeSetMatches() {
        AttributeDefinition local = AttributeDefinition.builder((String)"local", (Object)"").global(false).build();
        AttributeDefinition global = AttributeDefinition.builder((String)"global", (Object)"").build();
        AttributeSet setA = new AttributeSet(this.getClass(), new AttributeDefinition[]{local, global});
        AttributeSet setB = new AttributeSet(this.getClass(), new AttributeDefinition[]{local, global});
        setA.attribute("local").set((Object)"A");
        setA.attribute("global").set((Object)"A");
        setB.attribute("local").set((Object)"B");
        setB.attribute("global").set((Object)"A");
        Assert.assertTrue((boolean)setA.matches(setB));
        Assert.assertNotEquals((Object)setA, (Object)setB);
        setB.attribute("global").set((Object)"B");
        Assert.assertFalse((boolean)setA.matches(setB));
        Assert.assertNotEquals((Object)setA, (Object)setB);
        setA = new AttributeSet(this.getClass(), new AttributeDefinition[]{local});
        setB = new AttributeSet(this.getClass(), new AttributeDefinition[]{local, global});
        setA.attribute("local").set((Object)"A");
        setB.attribute("local").set((Object)"A");
        setB.attribute("global").set((Object)"A");
        Assert.assertFalse((boolean)setA.matches(setB));
        Assert.assertNotEquals((Object)setA, (Object)setB);
        AttributeDefinition global2 = AttributeDefinition.builder((String)"global2", (Object)"").build();
        setA = new AttributeSet(this.getClass(), new AttributeDefinition[]{local, global});
        setB = new AttributeSet(this.getClass(), new AttributeDefinition[]{local, global2});
        setA.attribute("local").set((Object)"A");
        setA.attribute("global").set((Object)"A");
        setB.attribute("local").set((Object)"A");
        setB.attribute("global2").set((Object)"A");
        Assert.assertFalse((boolean)setA.matches(setB));
        Assert.assertNotEquals((Object)setA, (Object)setB);
    }

    @Test
    public void testAttributeFromString() {
        AttributeDefinition charAttrDef = AttributeDefinition.builder((String)"char", (Object)Character.valueOf('c')).build();
        Attribute characterAttr = new Attribute(charAttrDef);
        characterAttr.fromString("a");
        Assert.assertEquals((long)97L, (long)((Character)characterAttr.get()).charValue());
        Assertions.assertThatThrownBy(() -> characterAttr.fromString("ab")).isInstanceOf(IllegalArgumentException.class);
        AttributeDefinition charArrayAttrDef = AttributeDefinition.builder((String)"chararray", (Object)new char[0]).build();
        Attribute charArrayAttr = new Attribute(charArrayAttrDef);
        charArrayAttr.fromString("abc");
        Assert.assertArrayEquals((char[])new char[]{'a', 'b', 'c'}, (char[])((char[])charArrayAttr.get()));
        AttributeDefinition byteAttrDef = AttributeDefinition.builder((String)"byte", (Object)0).build();
        Attribute byteAttr = new Attribute(byteAttrDef);
        byteAttr.fromString("5");
        Assert.assertEquals((long)5L, (long)((Byte)byteAttr.get()).byteValue());
        AttributeDefinition shortAttrDef = AttributeDefinition.builder((String)"short", (Object)0).build();
        Attribute shortAttr = new Attribute(shortAttrDef);
        shortAttr.fromString("5");
        Assert.assertEquals((long)5L, (long)((Short)shortAttr.get()).shortValue());
        AttributeDefinition stringAttrDef = AttributeDefinition.builder((String)"string", (Object)"").build();
        Attribute stringAttr = new Attribute(stringAttrDef);
        stringAttr.fromString("a");
        Assert.assertEquals((Object)"a", (Object)stringAttr.get());
        AttributeDefinition integerAttrDef = AttributeDefinition.builder((String)"integer", (Object)0).build();
        Attribute integerAttr = new Attribute(integerAttrDef);
        integerAttr.fromString("1");
        Assert.assertEquals((long)1L, (long)((Integer)integerAttr.get()).intValue());
        AttributeDefinition longAttrDef = AttributeDefinition.builder((String)"long", (Object)0L).build();
        Attribute longAttr = new Attribute(longAttrDef);
        longAttr.fromString("1");
        Assert.assertEquals((long)1L, (long)((Long)longAttr.get()));
        AttributeDefinition floatAttrDef = AttributeDefinition.builder((String)"float", (Object)Float.valueOf(0.0f)).build();
        Attribute floatAttr = new Attribute(floatAttrDef);
        floatAttr.fromString("0.1");
        Assert.assertEquals((float)0.1f, (float)((Float)floatAttr.get()).floatValue(), (float)1.0E-6f);
        AttributeDefinition doubleAttrDef = AttributeDefinition.builder((String)"double", (Object)0.0).build();
        Attribute doubleAttr = new Attribute(doubleAttrDef);
        doubleAttr.fromString("0.1");
        Assert.assertEquals((double)0.1, (double)((Double)doubleAttr.get()), (double)1.0E-6);
        AttributeDefinition booleanAttrDef = AttributeDefinition.builder((String)"boolean", (Object)false).build();
        Attribute booleanAttr = new Attribute(booleanAttrDef);
        booleanAttr.fromString("true");
        Assert.assertTrue((boolean)((Boolean)booleanAttr.get()));
        booleanAttr.fromString("false");
        Assert.assertFalse((boolean)((Boolean)booleanAttr.get()));
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> booleanAttr.fromString("blah")).isInstanceOf(IllegalArgumentException.class)).hasMessage("ISPN000955: 'blah' is not a valid boolean value (true|false|yes|no|y|n|on|off)");
        AttributeDefinition bigDecimalAttrDef = AttributeDefinition.builder((String)"bigdecimal", (Object)new BigDecimal(0)).build();
        Attribute bigDecimalAttr = new Attribute(bigDecimalAttrDef);
        bigDecimalAttr.fromString("0.1");
        Assert.assertEquals((Object)BigDecimal.valueOf(0.1), (Object)bigDecimalAttr.get());
        AttributeDefinition bigIntegerAttrDef = AttributeDefinition.builder((String)"biginteger", (Object)BigInteger.valueOf(0L)).build();
        Attribute bigIntegerAttr = new Attribute(bigIntegerAttrDef);
        bigIntegerAttr.fromString("100");
        Assert.assertEquals((Object)BigInteger.valueOf(100L), (Object)bigIntegerAttr.get());
        AttributeDefinition stringArrayDef = AttributeDefinition.builder((String)"stringArray", (Object)new String[0]).build();
        Attribute stringArray = new Attribute(stringArrayDef);
        stringArray.fromString("a b c");
        Assert.assertArrayEquals((Object[])new String[]{"a", "b", "c"}, (Object[])((Object[])stringArray.get()));
        stringArray.fromString("d");
        Assert.assertArrayEquals((Object[])new String[]{"d"}, (Object[])((Object[])stringArray.get()));
        stringArray.fromString("");
        Assert.assertArrayEquals((Object[])new String[0], (Object[])((Object[])stringArray.get()));
        AttributeDefinition listAttrDef = AttributeDefinition.builder((String)"list", Collections.emptyList(), List.class).build();
        Attribute listAttr = new Attribute(listAttrDef);
        listAttr.fromString("a b c");
        Assert.assertEquals(Arrays.asList("a", "b", "c"), (Object)listAttr.get());
        listAttr.fromString("d");
        Assert.assertEquals(List.of("d"), (Object)listAttr.get());
        listAttr.fromString("");
        Assert.assertEquals(Collections.emptyList(), (Object)listAttr.get());
        AttributeDefinition setAttrDef = AttributeDefinition.builder((String)"set", Collections.emptySet(), Set.class).build();
        Attribute setAttr = new Attribute(setAttrDef);
        setAttr.fromString("a b c");
        Assert.assertEquals(Set.of("a", "b", "c"), (Object)setAttr.get());
        setAttr.fromString("d");
        Assert.assertEquals(Set.of("d"), (Object)setAttr.get());
        setAttr.fromString("");
        Assert.assertEquals(Collections.emptySet(), (Object)setAttr.get());
        AttributeDefinition fileAttrDef = AttributeDefinition.builder((String)"file", null, File.class).build();
        Attribute fileAttr = new Attribute(fileAttrDef);
        fileAttr.fromString("/home/user/tmp/test.txt");
        Assert.assertEquals((Object)new File("/home/user/tmp/test.txt"), (Object)fileAttr.get());
        AttributeDefinition propertiesAttrDef = AttributeDefinition.builder((String)"properties", (Object)new Properties(), Properties.class).build();
        Attribute propertiesAttr = new Attribute(propertiesAttrDef);
        propertiesAttr.fromString("A=B\nC=D\n");
        Assertions.assertThat((Map)((Map)propertiesAttr.get())).containsExactlyInAnyOrderEntriesOf((Map)new Properties(){
            {
                this.put("A", "B");
                this.put("C", "D");
            }
        });
        AttributeDefinition enumAttrDef = AttributeDefinition.builder((String)"enum", null, FileVisitOption.class).build();
        Attribute enumAttr = new Attribute(enumAttrDef);
        enumAttr.fromString("FOLLOW_LINKS");
        Assert.assertEquals((Object)((Object)FileVisitOption.FOLLOW_LINKS), (Object)enumAttr.get());
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> enumAttr.fromString("BLAH")).isInstanceOf(IllegalArgumentException.class)).hasMessage("ISPN000956: 'BLAH' is not one of [FOLLOW_LINKS]");
        AttributeDefinition unknownAttrDef = AttributeDefinition.builder((String)"path", null, Path.class).build();
        Attribute unknownAttr = new Attribute(unknownAttrDef);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> unknownAttr.fromString("a")).isInstanceOf(CacheConfigurationException.class)).hasMessageContaining("Cannot convert a to type java.nio.file.Path");
    }

    static class Holder<T> {
        T object;

        Holder(T object) {
            this.object = object;
        }

        Holder() {
            this.object = null;
        }

        T get() {
            return this.object;
        }

        void set(T object) {
            this.object = object;
        }
    }
}

