/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.commons.configuration.io.xml;

import java.io.EOFException;
import java.io.Reader;
import java.io.StringReader;
import org.infinispan.commons.configuration.io.xml.MXParser;
import org.infinispan.commons.configuration.io.xml.XmlPullParserException;
import org.junit.Assert;
import org.junit.Test;

public class MXParserTest {
    @Test
    public void testHexadecimalEntities() throws Exception {
        MXParser parser = new MXParser();
        parser.defineEntityReplacementText("test", "replacement");
        String input = "<root>&#x41;</root>";
        parser.setInput((Reader)new StringReader(input));
        Assert.assertEquals((long)2L, (long)parser.next());
        Assert.assertEquals((long)4L, (long)parser.next());
        Assert.assertEquals((Object)"A", (Object)parser.getText());
        Assert.assertEquals((long)3L, (long)parser.next());
    }

    @Test
    public void testDecimalEntities() throws Exception {
        MXParser parser = new MXParser();
        parser.defineEntityReplacementText("test", "replacement");
        String input = "<root>&#65;</root>";
        parser.setInput((Reader)new StringReader(input));
        Assert.assertEquals((long)2L, (long)parser.next());
        Assert.assertEquals((long)4L, (long)parser.next());
        Assert.assertEquals((Object)"A", (Object)parser.getText());
        Assert.assertEquals((long)3L, (long)parser.next());
    }

    @Test
    public void testPredefinedEntities() throws Exception {
        MXParser parser = new MXParser();
        parser.defineEntityReplacementText("test", "replacement");
        String input = "<root>&lt;&gt;&amp;&apos;&quot;</root>";
        parser.setInput((Reader)new StringReader(input));
        Assert.assertEquals((long)2L, (long)parser.next());
        Assert.assertEquals((long)4L, (long)parser.next());
        Assert.assertEquals((Object)"<>&'\"", (Object)parser.getText());
        Assert.assertEquals((long)3L, (long)parser.next());
    }

    @Test
    public void testCustomEntities() throws Exception {
        MXParser parser = new MXParser();
        String input = "<root>&myentity;</root>";
        parser.setInput((Reader)new StringReader(input));
        parser.defineEntityReplacementText("myentity", "replacement");
        Assert.assertEquals((long)2L, (long)parser.next());
        Assert.assertEquals((long)4L, (long)parser.next());
        Assert.assertEquals((Object)"replacement", (Object)parser.getText());
        Assert.assertEquals((long)3L, (long)parser.next());
        parser = new MXParser();
        input = "<root>&myCustom;</root>";
        parser.setInput((Reader)new StringReader(input));
        parser.defineEntityReplacementText("fo", "&#65;");
        parser.defineEntityReplacementText("myCustom", "&fo;");
        Assert.assertEquals((long)2L, (long)parser.next());
        Assert.assertEquals((long)4L, (long)parser.next());
        Assert.assertEquals((Object)"&#65;", (Object)parser.getText());
        Assert.assertEquals((long)3L, (long)parser.next());
    }

    @Test
    public void testUnicodeEntities() throws Exception {
        MXParser parser = new MXParser();
        String input = "<root>&#x1d7ed;</root>";
        parser.setInput((Reader)new StringReader(input));
        Assert.assertEquals((long)2L, (long)parser.nextToken());
        Assert.assertEquals((long)6L, (long)parser.nextToken());
        Assert.assertEquals((Object)"\ud835\udfed", (Object)parser.getText());
        Assert.assertEquals((long)3L, (long)parser.nextToken());
        parser = new MXParser();
        input = "<root>&#x159;</root>";
        parser.setInput((Reader)new StringReader(input));
        Assert.assertEquals((long)2L, (long)parser.nextToken());
        Assert.assertEquals((long)6L, (long)parser.nextToken());
        Assert.assertEquals((Object)"\u0159", (Object)parser.getText());
        Assert.assertEquals((long)3L, (long)parser.nextToken());
    }

    @Test
    public void testInvalidCharacterReferenceHexa() throws Exception {
        MXParser parser = new MXParser();
        String input = "<root>&#x110000;</root>";
        parser.setInput((Reader)new StringReader(input));
        try {
            Assert.assertEquals((long)2L, (long)parser.nextToken());
            Assert.assertEquals((long)6L, (long)parser.nextToken());
            Assert.fail((String)"Should fail since &#x110000; is an illegal character reference");
        }
        catch (XmlPullParserException e) {
            Assert.assertTrue((boolean)e.getMessage().contains("character reference (with hex value 110000) is invalid"));
        }
    }

    @Test
    public void testValidCharacterReferenceHexa() throws Exception {
        MXParser parser = new MXParser();
        String input = "<root>&#x9;&#xA;&#xD;&#x20;&#x200;&#xD7FF;&#xE000;&#xFFA2;&#xFFFD;&#x10000;&#x10FFFD;&#x10FFFF;</root>";
        parser.setInput((Reader)new StringReader(input));
        try {
            Assert.assertEquals((long)2L, (long)parser.nextToken());
            Assert.assertEquals((long)6L, (long)parser.nextToken());
            Assert.assertEquals((long)9L, (long)parser.getText().codePointAt(0));
            Assert.assertEquals((long)6L, (long)parser.nextToken());
            Assert.assertEquals((long)10L, (long)parser.getText().codePointAt(0));
            Assert.assertEquals((long)6L, (long)parser.nextToken());
            Assert.assertEquals((long)13L, (long)parser.getText().codePointAt(0));
            Assert.assertEquals((long)6L, (long)parser.nextToken());
            Assert.assertEquals((long)32L, (long)parser.getText().codePointAt(0));
            Assert.assertEquals((long)6L, (long)parser.nextToken());
            Assert.assertEquals((long)512L, (long)parser.getText().codePointAt(0));
            Assert.assertEquals((long)6L, (long)parser.nextToken());
            Assert.assertEquals((long)55295L, (long)parser.getText().codePointAt(0));
            Assert.assertEquals((long)6L, (long)parser.nextToken());
            Assert.assertEquals((long)57344L, (long)parser.getText().codePointAt(0));
            Assert.assertEquals((long)6L, (long)parser.nextToken());
            Assert.assertEquals((long)65442L, (long)parser.getText().codePointAt(0));
            Assert.assertEquals((long)6L, (long)parser.nextToken());
            Assert.assertEquals((long)65533L, (long)parser.getText().codePointAt(0));
            Assert.assertEquals((long)6L, (long)parser.nextToken());
            Assert.assertEquals((long)65536L, (long)parser.getText().codePointAt(0));
            Assert.assertEquals((long)6L, (long)parser.nextToken());
            Assert.assertEquals((long)1114109L, (long)parser.getText().codePointAt(0));
            Assert.assertEquals((long)6L, (long)parser.nextToken());
            Assert.assertEquals((long)0x10FFFFL, (long)parser.getText().codePointAt(0));
            Assert.assertEquals((long)3L, (long)parser.nextToken());
        }
        catch (XmlPullParserException e) {
            Assert.fail((String)"Should success since the input represents all legal character references");
        }
    }

    @Test
    public void testInvalidCharacterReferenceDecimal() throws Exception {
        MXParser parser = new MXParser();
        String input = "<root>&#1114112;</root>";
        parser.setInput((Reader)new StringReader(input));
        try {
            Assert.assertEquals((long)2L, (long)parser.nextToken());
            Assert.assertEquals((long)6L, (long)parser.nextToken());
            Assert.fail((String)"Should fail since &#1114112; is an illegal character reference");
        }
        catch (XmlPullParserException e) {
            Assert.assertTrue((boolean)e.getMessage().contains("character reference (with decimal value 1114112) is invalid"));
        }
    }

    @Test
    public void testValidCharacterReferenceDecimal() throws Exception {
        MXParser parser = new MXParser();
        String input = "<root>&#9;&#10;&#13;&#32;&#512;&#55295;&#57344;&#65442;&#65533;&#65536;&#1114109;&#1114111;</root>";
        parser.setInput((Reader)new StringReader(input));
        try {
            Assert.assertEquals((long)2L, (long)parser.nextToken());
            Assert.assertEquals((long)6L, (long)parser.nextToken());
            Assert.assertEquals((long)9L, (long)parser.getText().codePointAt(0));
            Assert.assertEquals((long)6L, (long)parser.nextToken());
            Assert.assertEquals((long)10L, (long)parser.getText().codePointAt(0));
            Assert.assertEquals((long)6L, (long)parser.nextToken());
            Assert.assertEquals((long)13L, (long)parser.getText().codePointAt(0));
            Assert.assertEquals((long)6L, (long)parser.nextToken());
            Assert.assertEquals((long)32L, (long)parser.getText().codePointAt(0));
            Assert.assertEquals((long)6L, (long)parser.nextToken());
            Assert.assertEquals((long)512L, (long)parser.getText().codePointAt(0));
            Assert.assertEquals((long)6L, (long)parser.nextToken());
            Assert.assertEquals((long)55295L, (long)parser.getText().codePointAt(0));
            Assert.assertEquals((long)6L, (long)parser.nextToken());
            Assert.assertEquals((long)57344L, (long)parser.getText().codePointAt(0));
            Assert.assertEquals((long)6L, (long)parser.nextToken());
            Assert.assertEquals((long)65442L, (long)parser.getText().codePointAt(0));
            Assert.assertEquals((long)6L, (long)parser.nextToken());
            Assert.assertEquals((long)65533L, (long)parser.getText().codePointAt(0));
            Assert.assertEquals((long)6L, (long)parser.nextToken());
            Assert.assertEquals((long)65536L, (long)parser.getText().codePointAt(0));
            Assert.assertEquals((long)6L, (long)parser.nextToken());
            Assert.assertEquals((long)1114109L, (long)parser.getText().codePointAt(0));
            Assert.assertEquals((long)6L, (long)parser.nextToken());
            Assert.assertEquals((long)0x10FFFFL, (long)parser.getText().codePointAt(0));
            Assert.assertEquals((long)3L, (long)parser.nextToken());
        }
        catch (XmlPullParserException e) {
            Assert.fail((String)"Should success since the input represents all legal character references");
        }
    }

    @Test
    public void testValidCDATA() throws Exception {
        MXParser parser = new MXParser();
        String input = "<root><![CDATA[x]],if(c[a]>3&&a.v)]]></root>";
        parser.setInput((Reader)new StringReader(input));
        Assert.assertEquals((long)2L, (long)parser.nextToken());
        Assert.assertEquals((long)5L, (long)parser.nextToken());
        Assert.assertEquals((Object)"x]],if(c[a]>3&&a.v)", (Object)parser.getText());
        Assert.assertEquals((long)3L, (long)parser.nextToken());
    }

    @Test
    public void testParserPosition() throws Exception {
        String input = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><!-- A --> \n <!-- B --><test>\tnnn</test>\n<!-- C\nC -->";
        MXParser parser = new MXParser();
        parser.setInput((Reader)new StringReader(input));
        Assert.assertEquals((long)0L, (long)parser.nextToken());
        MXParserTest.assertPosition(1, 39, parser);
        Assert.assertEquals((long)9L, (long)parser.nextToken());
        MXParserTest.assertPosition(1, 49, parser);
        Assert.assertEquals((long)7L, (long)parser.nextToken());
        MXParserTest.assertPosition(2, 3, parser);
        Assert.assertEquals((long)9L, (long)parser.nextToken());
        MXParserTest.assertPosition(2, 12, parser);
        Assert.assertEquals((long)2L, (long)parser.nextToken());
        MXParserTest.assertPosition(2, 18, parser);
        Assert.assertEquals((long)4L, (long)parser.nextToken());
        MXParserTest.assertPosition(2, 23, parser);
        Assert.assertEquals((long)3L, (long)parser.nextToken());
        MXParserTest.assertPosition(2, 29, parser);
        Assert.assertEquals((long)7L, (long)parser.nextToken());
        MXParserTest.assertPosition(3, 2, parser);
        Assert.assertEquals((long)9L, (long)parser.nextToken());
        MXParserTest.assertPosition(4, 6, parser);
        Assert.assertEquals((long)1L, (long)parser.nextToken());
        MXParserTest.assertPosition(4, 6, parser);
    }

    @Test
    public void testProcessingXMLDeclaration() throws Exception {
        String input = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><test>nnn</test>";
        MXParser parser = new MXParser();
        parser.setInput((Reader)new StringReader(input));
        Assert.assertEquals((long)0L, (long)parser.nextToken());
        Assert.assertEquals((long)2L, (long)parser.nextToken());
        Assert.assertEquals((long)4L, (long)parser.nextToken());
        Assert.assertEquals((long)3L, (long)parser.nextToken());
        Assert.assertEquals((long)1L, (long)parser.nextToken());
    }

    @Test
    public void testProcessingInstructionsContainingUnbalancedGreaterThanSign() throws Exception {
        String sb = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<project>\n<?ignore\n>\n?>\n</project>";
        MXParser parser = new MXParser();
        parser.setInput((Reader)new StringReader(sb));
        Assert.assertEquals((long)0L, (long)parser.nextToken());
        Assert.assertEquals((long)7L, (long)parser.nextToken());
        Assert.assertEquals((long)2L, (long)parser.nextToken());
        Assert.assertEquals((long)4L, (long)parser.nextToken());
        Assert.assertEquals((long)8L, (long)parser.nextToken());
        Assert.assertEquals((long)4L, (long)parser.nextToken());
        Assert.assertEquals((long)3L, (long)parser.nextToken());
        Assert.assertEquals((long)1L, (long)parser.nextToken());
    }

    @Test
    public void testProcessingInstructionsContainingXml() throws Exception {
        String sb = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><project>\n <?pi\n   <tag>\n   </tag>\n ?>\n</project>";
        MXParser parser = new MXParser();
        parser.setInput((Reader)new StringReader(sb));
        Assert.assertEquals((long)0L, (long)parser.nextToken());
        Assert.assertEquals((long)2L, (long)parser.nextToken());
        Assert.assertEquals((long)4L, (long)parser.nextToken());
        Assert.assertEquals((long)8L, (long)parser.nextToken());
        Assert.assertEquals((long)4L, (long)parser.nextToken());
        Assert.assertEquals((long)3L, (long)parser.nextToken());
        Assert.assertEquals((long)1L, (long)parser.nextToken());
    }

    @Test
    public void testMalformedProcessingInstructionsContainingXmlNoClosingQuestionMark() throws Exception {
        String sb = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<project />\n<?pi\n   <tag>\n   </tag>>\n";
        MXParser parser = new MXParser();
        parser.setInput((Reader)new StringReader(sb));
        try {
            Assert.assertEquals((long)0L, (long)parser.nextToken());
            Assert.assertEquals((long)7L, (long)parser.nextToken());
            Assert.assertEquals((long)2L, (long)parser.nextToken());
            Assert.assertEquals((long)3L, (long)parser.nextToken());
            Assert.assertEquals((long)7L, (long)parser.nextToken());
            Assert.assertEquals((long)8L, (long)parser.nextToken());
            Assert.fail((String)"Should fail since it has invalid PI");
        }
        catch (XmlPullParserException ex) {
            Assert.assertTrue((boolean)ex.getMessage().contains("processing instruction started on line 3 and column 1 was not closed"));
        }
    }

    @Test
    public void testSubsequentProcessingInstructionShort() throws Exception {
        String sb = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><project><!-- comment --><?m2e ignore?></project>";
        MXParser parser = new MXParser();
        parser.setInput((Reader)new StringReader(sb));
        Assert.assertEquals((long)0L, (long)parser.nextToken());
        Assert.assertEquals((long)2L, (long)parser.nextToken());
        Assert.assertEquals((long)9L, (long)parser.nextToken());
        Assert.assertEquals((long)8L, (long)parser.nextToken());
        Assert.assertEquals((long)3L, (long)parser.nextToken());
        Assert.assertEquals((long)1L, (long)parser.nextToken());
    }

    @Test
    public void testSubsequentProcessingInstructionMoreThan8k() throws Exception {
        StringBuilder sb = new StringBuilder();
        sb.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
        sb.append("<project>");
        for (int j = 0; j < 10; ++j) {
            sb.append("<!-- ");
            sb.append("ten bytes ".repeat(2000));
            sb.append(" -->");
        }
        sb.append("<?m2e ignore?>");
        sb.append("</project>");
        MXParser parser = new MXParser();
        parser.setInput((Reader)new StringReader(sb.toString()));
        Assert.assertEquals((long)0L, (long)parser.nextToken());
        Assert.assertEquals((long)2L, (long)parser.nextToken());
        Assert.assertEquals((long)9L, (long)parser.nextToken());
        Assert.assertEquals((long)9L, (long)parser.nextToken());
        Assert.assertEquals((long)9L, (long)parser.nextToken());
        Assert.assertEquals((long)9L, (long)parser.nextToken());
        Assert.assertEquals((long)9L, (long)parser.nextToken());
        Assert.assertEquals((long)9L, (long)parser.nextToken());
        Assert.assertEquals((long)9L, (long)parser.nextToken());
        Assert.assertEquals((long)9L, (long)parser.nextToken());
        Assert.assertEquals((long)9L, (long)parser.nextToken());
        Assert.assertEquals((long)9L, (long)parser.nextToken());
        Assert.assertEquals((long)8L, (long)parser.nextToken());
        Assert.assertEquals((long)3L, (long)parser.nextToken());
        Assert.assertEquals((long)1L, (long)parser.nextToken());
    }

    @Test
    public void testLargeText_NoOverflow() throws Exception {
        String sb = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><largetextblock>" + new String(new char[0x2000000]) + "</largetextblock>";
        MXParser parser = new MXParser();
        parser.setInput((Reader)new StringReader(sb));
        Assert.assertEquals((long)0L, (long)parser.nextToken());
        Assert.assertEquals((long)2L, (long)parser.nextToken());
        Assert.assertEquals((long)4L, (long)parser.nextToken());
        Assert.assertEquals((long)3L, (long)parser.nextToken());
        Assert.assertEquals((long)1L, (long)parser.nextToken());
    }

    @Test
    public void testMalformedProcessingInstructionAfterTag() throws Exception {
        MXParser parser = new MXParser();
        String input = "<project /><?>";
        parser.setInput((Reader)new StringReader(input));
        try {
            Assert.assertEquals((long)2L, (long)parser.next());
            Assert.assertEquals((long)3L, (long)parser.next());
            Assert.assertEquals((long)8L, (long)parser.next());
            Assert.fail((String)"Should fail since it has an invalid Processing Instruction");
        }
        catch (XmlPullParserException ex) {
            Assert.assertTrue((boolean)ex.getMessage().contains("processing instruction PITarget name not found"));
        }
    }

    @Test
    public void testMalformedProcessingInstructionBeforeTag() throws Exception {
        MXParser parser = new MXParser();
        String input = "<?><project />";
        parser.setInput((Reader)new StringReader(input));
        try {
            Assert.assertEquals((long)8L, (long)parser.next());
            Assert.assertEquals((long)2L, (long)parser.next());
            Assert.assertEquals((long)3L, (long)parser.next());
            Assert.fail((String)"Should fail since it has invalid PI");
        }
        catch (XmlPullParserException ex) {
            Assert.assertTrue((boolean)ex.getMessage().contains("processing instruction PITarget name not found"));
        }
    }

    @Test
    public void testMalformedProcessingInstructionSpaceBeforeName() throws Exception {
        MXParser parser = new MXParser();
        String sb = "<? shouldhavenospace><project />";
        parser.setInput((Reader)new StringReader(sb));
        try {
            Assert.assertEquals((long)8L, (long)parser.next());
            Assert.assertEquals((long)2L, (long)parser.next());
            Assert.assertEquals((long)3L, (long)parser.next());
            Assert.fail((String)"Should fail since it has invalid PI");
        }
        catch (XmlPullParserException ex) {
            Assert.assertTrue((boolean)ex.getMessage().contains("processing instruction PITarget must be exactly after <? and not white space character"));
        }
    }

    @Test
    public void testMalformedProcessingInstructionNoClosingQuestionMark() throws Exception {
        MXParser parser = new MXParser();
        String sb = "<?shouldhavenospace><project />";
        parser.setInput((Reader)new StringReader(sb));
        try {
            Assert.assertEquals((long)8L, (long)parser.next());
            Assert.fail((String)"Should fail since it has invalid PI");
        }
        catch (XmlPullParserException ex) {
            Assert.assertTrue((boolean)ex.getMessage().contains("processing instruction started on line 1 and column 1 was not closed"));
        }
    }

    @Test
    public void testSubsequentMalformedProcessingInstructionNoClosingQuestionMark() throws Exception {
        MXParser parser = new MXParser();
        String sb = "<project /><?shouldhavenospace>";
        parser.setInput((Reader)new StringReader(sb));
        try {
            Assert.assertEquals((long)2L, (long)parser.next());
            Assert.assertEquals((long)3L, (long)parser.next());
            Assert.assertEquals((long)8L, (long)parser.next());
            Assert.fail((String)"Should fail since it has invalid PI");
        }
        catch (XmlPullParserException ex) {
            Assert.assertTrue((boolean)ex.getMessage().contains("processing instruction started on line 1 and column 12 was not closed"));
        }
    }

    @Test
    public void testSubsequentAbortedProcessingInstruction() throws Exception {
        MXParser parser = new MXParser();
        String sb = "<project /><?aborted";
        parser.setInput((Reader)new StringReader(sb));
        try {
            Assert.assertEquals((long)2L, (long)parser.next());
            Assert.assertEquals((long)3L, (long)parser.next());
            Assert.assertEquals((long)8L, (long)parser.next());
            Assert.fail((String)"Should fail since it has aborted PI");
        }
        catch (XmlPullParserException ex) {
            Assert.assertTrue((boolean)ex.getMessage().contains("@1:21"));
            Assert.assertTrue((boolean)ex.getMessage().contains("processing instruction started on line 1 and column 12 was not closed"));
        }
    }

    @Test
    public void testSubsequentAbortedComment() throws Exception {
        MXParser parser = new MXParser();
        String sb = "<project /><!-- aborted";
        parser.setInput((Reader)new StringReader(sb));
        try {
            Assert.assertEquals((long)2L, (long)parser.next());
            Assert.assertEquals((long)3L, (long)parser.next());
            Assert.assertEquals((long)8L, (long)parser.next());
            Assert.fail((String)"Should fail since it has aborted comment");
        }
        catch (XmlPullParserException ex) {
            Assert.assertTrue((boolean)ex.getMessage().contains("@1:24"));
            Assert.assertTrue((boolean)ex.getMessage().contains("comment started on line 1 and column 12 was not closed"));
        }
    }

    @Test
    public void testMalformedXMLRootElement() throws Exception {
        MXParser parser = new MXParser();
        String input = "<Y";
        parser.setInput((Reader)new StringReader(input));
        try {
            Assert.assertEquals((long)2L, (long)parser.nextToken());
            Assert.fail((String)"Should throw EOFException");
        }
        catch (EOFException e) {
            Assert.assertTrue((boolean)e.getMessage().contains("no more data available - expected the opening tag <Y...>"));
        }
    }

    @Test
    public void testMalformedXMLRootElement2() throws Exception {
        MXParser parser = new MXParser();
        String input = "<hello";
        parser.setInput((Reader)new StringReader(input));
        try {
            Assert.assertEquals((long)2L, (long)parser.nextToken());
            Assert.fail((String)"Should throw EOFException");
        }
        catch (EOFException e) {
            Assert.assertTrue((boolean)e.getMessage().contains("no more data available - expected the opening tag <hello...>"));
        }
    }

    @Test
    public void testMalformedXMLRootElement3() throws Exception {
        MXParser parser = new MXParser();
        String input = "<hello><how";
        parser.setInput((Reader)new StringReader(input));
        try {
            Assert.assertEquals((long)2L, (long)parser.nextToken());
            Assert.assertEquals((long)2L, (long)parser.nextToken());
            Assert.fail((String)"Should throw EOFException");
        }
        catch (EOFException e) {
            Assert.assertTrue((boolean)e.getMessage().contains("no more data available - expected the opening tag <how...>"));
        }
    }

    @Test
    public void testMalformedXMLRootElement4() throws Exception {
        MXParser parser = new MXParser();
        String input = "<hello>some text<how";
        parser.setInput((Reader)new StringReader(input));
        try {
            Assert.assertEquals((long)2L, (long)parser.nextToken());
            Assert.assertEquals((long)4L, (long)parser.nextToken());
            Assert.assertEquals((Object)"some text", (Object)parser.getText());
            Assert.assertEquals((long)2L, (long)parser.nextToken());
            Assert.fail((String)"Should throw EOFException");
        }
        catch (EOFException e) {
            Assert.assertTrue((boolean)e.getMessage().contains("no more data available - expected the opening tag <how...>"));
        }
    }

    @Test
    public void testMalformedXMLRootElement5() throws Exception {
        MXParser parser = new MXParser();
        String input = "<hello>some text</hello";
        parser.setInput((Reader)new StringReader(input));
        try {
            Assert.assertEquals((long)2L, (long)parser.nextToken());
            Assert.assertEquals((long)4L, (long)parser.nextToken());
            Assert.assertEquals((Object)"some text", (Object)parser.getText());
            Assert.assertEquals((long)3L, (long)parser.nextToken());
            Assert.fail((String)"Should throw EOFException");
        }
        catch (EOFException e) {
            Assert.assertTrue((boolean)e.getMessage().contains("no more data available - expected end tag </hello> to close start tag <hello>"));
        }
    }

    private static void assertPosition(int row, int col, MXParser parser) {
        Assert.assertEquals((String)"Current line", (long)row, (long)parser.getLineNumber());
        Assert.assertEquals((String)"Current column", (long)col, (long)parser.getColumnNumber());
    }
}

