/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.commons.dataconversion;

import java.nio.charset.StandardCharsets;
import org.infinispan.commons.dataconversion.MediaType;
import org.infinispan.commons.dataconversion.StandardConversions;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;

public class StandardConversionsTest {
    @Rule
    public ExpectedException thrown = ExpectedException.none();

    @Test
    public void textToTextConversion() {
        String source = "All those moments will be lost in time, like tears in rain.";
        byte[] sourceAs8859 = source.getBytes(StandardCharsets.ISO_8859_1);
        byte[] sourceAsASCII = source.getBytes(StandardCharsets.US_ASCII);
        Object result = StandardConversions.convertTextToText((Object)sourceAs8859, (MediaType)MediaType.TEXT_PLAIN.withCharset(StandardCharsets.ISO_8859_1), (MediaType)MediaType.TEXT_PLAIN.withCharset(StandardCharsets.US_ASCII));
        Assert.assertArrayEquals((byte[])sourceAsASCII, (byte[])((byte[])result));
    }

    @Test
    public void testTextToObjectConversion() {
        String source = "Can the maker repair what he makes?";
        String source2 = "I had your job once. I was good at it.";
        byte[] sourceBytes = source2.getBytes(StandardCharsets.US_ASCII);
        String result = StandardConversions.convertTextToObject((Object)source, (MediaType)MediaType.APPLICATION_OBJECT);
        String result2 = StandardConversions.convertTextToObject((Object)sourceBytes, (MediaType)MediaType.TEXT_PLAIN.withCharset(StandardCharsets.US_ASCII));
        Assert.assertEquals((Object)source, (Object)result);
        Assert.assertEquals((Object)source2, (Object)result2);
    }
}

