/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.commons.io;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.FileTime;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.infinispan.commons.io.FileWatcher;
import org.infinispan.commons.test.CommonsTestingUtil;
import org.infinispan.commons.test.Eventually;
import org.junit.Assert;
import org.junit.Test;

public class FileWatcherTest {
    @Test
    public void testFileWatcher() throws IOException, InterruptedException {
        try (FileWatcher watcher = new FileWatcher();){
            Path tmpDir = Paths.get(CommonsTestingUtil.tmpDirectory(FileWatcherTest.class), new String[0]);
            Files.createDirectories(tmpDir, new FileAttribute[0]);
            Path a = tmpDir.resolve("a");
            Files.deleteIfExists(a);
            Path b = tmpDir.resolve("b");
            Files.deleteIfExists(b);
            Files.createFile(a, new FileAttribute[0]);
            ConcurrentHashMap counters = new ConcurrentHashMap();
            watcher.watch(a, p -> counters.computeIfAbsent(p, k -> new AtomicInteger()).incrementAndGet());
            Files.setLastModifiedTime(a, FileTime.fromMillis(System.currentTimeMillis()));
            Eventually.eventually(() -> counters.containsKey(a) && ((AtomicInteger)counters.get(a)).get() == 1);
            Files.setLastModifiedTime(a, FileTime.fromMillis(System.currentTimeMillis()));
            Eventually.eventually(() -> ((AtomicInteger)counters.get(a)).get() == 2);
            Files.createFile(b, new FileAttribute[0]);
            Thread.sleep(FileWatcher.SLEEP + 500);
            Assert.assertFalse((boolean)counters.containsKey(b));
            Assert.assertEquals((long)2L, (long)((AtomicInteger)counters.get(a)).get());
            watcher.watch(b, p -> counters.computeIfAbsent(p, k -> new AtomicInteger()).incrementAndGet());
            watcher.watch(a, p -> counters.computeIfAbsent(p, k -> new AtomicInteger()).incrementAndGet());
            Files.setLastModifiedTime(a, FileTime.fromMillis(System.currentTimeMillis()));
            Files.setLastModifiedTime(b, FileTime.fromMillis(System.currentTimeMillis()));
            Eventually.eventually(() -> ((AtomicInteger)counters.get(a)).get() == 4);
            Eventually.eventually(() -> counters.containsKey(b) && ((AtomicInteger)counters.get(b)).get() == 1);
        }
    }
}

