/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.commons.util;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ListAssert;
import org.infinispan.commons.util.ClassFinder;
import org.junit.Test;

public class ClassFinderTest {
    @Test
    public void testFindWithAnnotations() {
        @ClassAnnotation
        class With {
            With() {
            }
        }
        @ClassAnnotation2
        class With2 {
            With2() {
            }
        }
        class Without {
            Without() {
            }
        }
        ((ListAssert)Assertions.assertThat((List)ClassFinder.withAnnotationPresent(List.of(With.class, With2.class, Without.class), ClassAnnotation.class)).hasSize(1)).contains((Object[])new Class[]{With.class});
        ((ListAssert)Assertions.assertThat((List)ClassFinder.withAnnotationDeclared(List.of(With.class, With2.class, Without.class), ClassAnnotation.class)).hasSize(1)).contains((Object[])new Class[]{With.class});
    }

    @Test
    public void testIsAssignable() {
        class A {
            A() {
            }
        }
        class B
        extends A {
            B() {
            }
        }
        class C {
            C() {
            }
        }
        ((ListAssert)Assertions.assertThat((List)ClassFinder.isAssignableFrom(List.of(A.class, B.class, C.class), A.class)).hasSize(2)).contains((Object[])new Class[]{A.class, B.class});
        ((ListAssert)Assertions.assertThat((List)ClassFinder.isAssignableFrom(List.of(A.class, B.class, C.class), B.class)).hasSize(1)).contains((Object[])new Class[]{B.class});
    }

    @Test
    public void testInfinispanClasses() throws Throwable {
        Assertions.assertThat((List)ClassFinder.infinispanClasses()).hasSizeGreaterThan(100);
        Assertions.assertThat((List)ClassFinder.infinispanClasses((String)"")).isEmpty();
    }

    @Target(value={ElementType.TYPE})
    @Retention(value=RetentionPolicy.RUNTIME)
    private static @interface ClassAnnotation {
    }

    @Target(value={ElementType.TYPE})
    @Retention(value=RetentionPolicy.RUNTIME)
    private static @interface ClassAnnotation2 {
    }
}

