/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.commons.util;

import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.infinispan.commons.util.EnumUtil;
import org.junit.Test;

public class EnumUtilTest {
    @Test
    public void testConversionOperations() {
        long ac = 5L;
        long ace = 21L;
        static enum Test {
            A,
            B,
            C,
            D,
            E;

        }
        Assertions.assertThat((long)EnumUtil.bitSetOf((Enum)Test.A, (Enum)Test.C)).isEqualTo(ac);
        Assertions.assertThat((long)EnumUtil.bitSetOf((Enum)Test.A, (Enum)Test.C, (Enum[])new Enum[]{Test.E})).isEqualTo(ace);
        Assertions.assertThat((long)EnumUtil.bitSetOf(Collections.emptyList())).isEqualTo(0L);
        Assertions.assertThat((long)EnumUtil.bitSetOf(List.of(Test.A, Test.C, Test.E))).isEqualTo(ace);
        Assertions.assertThat((long)EnumUtil.bitSetOf((Enum[])new Enum[]{Test.A, Test.C, Test.E})).isEqualTo(ace);
    }

    @Test
    public void testCreationOperations() {
        long ace = 21L;
        static enum Test {
            A,
            B,
            C,
            D,
            E;

        }
        Assertions.assertThat((Collection)EnumUtil.enumSetOf((long)ace, Test.class)).isEqualTo(EnumSet.of(Test.A, Test.C, Test.E));
        Assertions.assertThat((Collection)EnumUtil.enumSetOf((long)0L, Test.class)).isEqualTo(EnumSet.noneOf(Test.class));
        Assertions.assertThat((boolean)EnumUtil.hasEnum((long)ace, (Enum)Test.A)).isTrue();
        Assertions.assertThat((boolean)EnumUtil.hasEnum((long)ace, (Enum)Test.B)).isFalse();
        Assertions.assertThat((long)EnumUtil.setEnum((long)ace, (Enum)Test.B)).isEqualTo(23L);
        Assertions.assertThat((long)EnumUtil.setEnum((long)ace, (Enum)Test.A)).isEqualTo(ace);
        Assertions.assertThat((long)EnumUtil.unsetEnum((long)ace, (Enum)Test.B)).isEqualTo(ace);
        Assertions.assertThat((long)EnumUtil.unsetEnum((long)ace, (Enum)Test.E)).isEqualTo(5L);
    }
}

