/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.commons.util;

import java.util.Collections;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ListAssert;
import org.infinispan.commons.util.ImmutableListCopy;
import org.junit.Test;

public class ImmutableListCopyTest {
    @Test
    public void testImmutableFromCombined() {
        ((ListAssert)Assertions.assertThat((List)new ImmutableListCopy(List.of(Integer.valueOf(1), Integer.valueOf(2)), List.of(Integer.valueOf(3), Integer.valueOf(4)))).hasSize(4)).containsExactly((Object[])new Integer[]{1, 2, 3, 4});
        ((ListAssert)Assertions.assertThat((List)new ImmutableListCopy(List.of(Integer.valueOf(1), Integer.valueOf(2)), Collections.emptyList())).hasSize(2)).containsExactly((Object[])new Integer[]{1, 2});
        ((ListAssert)Assertions.assertThat((List)new ImmutableListCopy(Collections.emptyList(), List.of(Integer.valueOf(3), Integer.valueOf(4)))).hasSize(2)).containsExactly((Object[])new Integer[]{3, 4});
    }

    @Test
    public void testIndexOf() {
        ImmutableListCopy ilc = new ImmutableListCopy(List.of(Integer.valueOf(1), Integer.valueOf(2), Integer.valueOf(42)), List.of(Integer.valueOf(42), Integer.valueOf(3), Integer.valueOf(4)));
        Assertions.assertThat((int)ilc.lastIndexOf(null)).isEqualTo(-1);
        Assertions.assertThat((int)ilc.lastIndexOf((Object)42)).isEqualTo(3);
        Assertions.assertThat((int)ilc.indexOf((Object)42)).isEqualTo(2);
        Assertions.assertThat((int)ilc.indexOf(null)).isEqualTo(-1);
    }
}

