/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.commons.util;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ObjectArrayAssert;
import org.assertj.core.api.ObjectAssert;
import org.assertj.core.api.ThrowingConsumer;
import org.infinispan.commons.CacheException;
import org.infinispan.commons.util.ReflectionUtil;
import org.junit.Test;

public class ReflectionUtilTest {
    @Test
    public void testGetAllMethods() {
        class T {
            T() {
            }

            @MethodAnnotation
            public void a() {
            }

            @MethodAnnotation
            public void b() {
            }

            public void c() {
            }
        }
        Assertions.assertThat((List)ReflectionUtil.getAllMethods(T.class, MethodAnnotation.class)).hasSize(2);
        Assertions.assertThat((List)ReflectionUtil.getAllMethods(T.class, FieldAnnotation.class)).isEmpty();
    }

    @Test
    public void testGetValue() {
        class T {
            private String field;

            T() {
            }
        }
        T t = new T();
        Assertions.assertThat((Object)ReflectionUtil.getValue((Object)t, (String)"field")).isNull();
        t.field = "value";
        Assertions.assertThat((Object)ReflectionUtil.getValue((Object)t, (String)"field")).isEqualTo((Object)"value");
        Assertions.assertThatThrownBy(() -> Assertions.assertThat((Object)ReflectionUtil.getValue((Object)t, (String)"something"))).isInstanceOf(CacheException.class);
    }

    @Test
    public void testGetAnnotation() {
        @ClassAnnotation
        class T {
            T() {
            }
        }
        Assertions.assertThat((Object)((ClassAnnotation)ReflectionUtil.getAnnotation(T.class, ClassAnnotation.class))).isNotNull();
        Assertions.assertThat((Object)((FieldAnnotation)ReflectionUtil.getAnnotation(T.class, FieldAnnotation.class))).isNull();
    }

    @Test
    public void testGetAnnotationSuper() {
        @ClassAnnotation
        class A {
            A() {
            }
        }
        Assertions.assertThat((Object)((ClassAnnotation)ReflectionUtil.getAnnotation(A.class, ClassAnnotation.class))).isNotNull();
        Assertions.assertThat((boolean)ReflectionUtil.isAnnotationPresent(A.class, ClassAnnotation.class)).isTrue();
        class B
        extends A {
            B() {
            }
        }
        Assertions.assertThat((Object)((ClassAnnotation)ReflectionUtil.getAnnotation(B.class, ClassAnnotation.class))).isNotNull();
        Assertions.assertThat((boolean)ReflectionUtil.isAnnotationPresent(B.class, ClassAnnotation.class)).isTrue();
        Assertions.assertThat((Object)((FieldAnnotation)ReflectionUtil.getAnnotation(B.class, FieldAnnotation.class))).isNull();
        Assertions.assertThat((boolean)ReflectionUtil.isAnnotationPresent(B.class, FieldAnnotation.class)).isFalse();
    }

    @Test
    public void testGetAnnotationInterface() {
        @ClassAnnotation
        static interface A {
        }
        Assertions.assertThat((Object)((ClassAnnotation)ReflectionUtil.getAnnotation(A.class, ClassAnnotation.class))).isNotNull();
        Assertions.assertThat((boolean)ReflectionUtil.isAnnotationPresent(A.class, ClassAnnotation.class)).isTrue();
        class B
        implements A {
            B() {
            }
        }
        Assertions.assertThat((Object)((ClassAnnotation)ReflectionUtil.getAnnotation(B.class, ClassAnnotation.class))).isNotNull();
        Assertions.assertThat((boolean)ReflectionUtil.isAnnotationPresent(B.class, ClassAnnotation.class)).isTrue();
        Assertions.assertThat((Object)((FieldAnnotation)ReflectionUtil.getAnnotation(B.class, FieldAnnotation.class))).isNull();
        Assertions.assertThat((boolean)ReflectionUtil.isAnnotationPresent(B.class, FieldAnnotation.class)).isFalse();
    }

    @Test
    public void testGetClass() throws Throwable {
        class A {
            A() {
            }
        }
        Assertions.assertThat((Class)ReflectionUtil.getClassForName((String)A.class.getName(), (ClassLoader)A.class.getClassLoader())).isEqualTo(A.class);
        Assertions.assertThatThrownBy(() -> ReflectionUtil.getClassForName((String)"org.infinispan.commons.util.C", (ClassLoader)ReflectionUtil.class.getClassLoader())).isInstanceOf(ClassNotFoundException.class);
        Assertions.assertThat((Class)ReflectionUtil.getClassForName((String)Float.TYPE.getName(), (ClassLoader)A.class.getClassLoader())).isEqualTo(Float.TYPE);
        Assertions.assertThat((Class)ReflectionUtil.getClassForName((String)byte[].class.getName(), (ClassLoader)A.class.getClassLoader())).isEqualTo(byte[].class);
    }

    @Test
    public void testSetGetField() {
        class A {
            String field;
            private String other;

            A() {
            }
        }
        Field field = ReflectionUtil.getField((String)"field", A.class);
        Assertions.assertThat((Object)field).isNotNull();
        Assertions.assertThat((String)field.getName()).isEqualTo("field");
        Assertions.assertThat(field.getType()).isEqualTo(String.class);
        Assertions.assertThat((Object)ReflectionUtil.getField((String)"unknown", A.class)).isNull();
        A a = new A();
        a.field = "before";
        ReflectionUtil.setField((Object)a, (Field)field, (Object)"updated");
        Assertions.assertThat((String)a.field).isEqualTo("updated");
        Field other = ReflectionUtil.getField((String)"other", A.class);
        Assertions.assertThat((Object)other).isNotNull();
        a.other = "before";
        Assertions.assertThatThrownBy(() -> ReflectionUtil.setField((Object)a, (Field)other, (Object)"updated")).isInstanceOf(CacheException.class);
    }

    @Test
    public void testUnwrap() {
        class C {
            C() {
            }
        }
        String value = "value";
        Assertions.assertThat((String)((String)ReflectionUtil.unwrap((Object)value, String.class))).isEqualTo(value);
        class B
        extends A {
            B() {
                class A {
                    protected String field;

                    A() {
                    }
                }
            }
        }
        B b = new B();
        b.field = value;
        Assertions.assertThat((Object)((B)ReflectionUtil.unwrap((Object)b, B.class))).isEqualTo((Object)b);
        A a = (A)ReflectionUtil.unwrap((Object)b, A.class);
        ((ObjectAssert)((ObjectAssert)Assertions.assertThat((Object)a).isNotNull()).satisfies(new ThrowingConsumer[]{ignore -> Assertions.assertThat((Object)a).isEqualTo((Object)b)})).satisfies(new ThrowingConsumer[]{ignore -> Assertions.assertThat((String)a.field).isEqualTo(value)});
        Assertions.assertThat((String)((String)ReflectionUtil.unwrapAny(String.class, (Object[])new Object[]{a, b, value}))).isEqualTo(value);
        Assertions.assertThatThrownBy(() -> ReflectionUtil.unwrap((Object)b, C.class)).isInstanceOf(IllegalArgumentException.class);
        Assertions.assertThatThrownBy(() -> ReflectionUtil.unwrapAny(C.class, (Object[])new Object[]{a, b, value})).isInstanceOf(IllegalArgumentException.class);
    }

    @Test
    public void testGetInvokeMethod() {
        class A {
            A() {
            }

            public void a() {
            }

            public int b(Integer x, Integer y) {
                return x + y;
            }
        }
        A a = new A();
        Assertions.assertThat((Object)ReflectionUtil.findMethod(A.class, (String)"a")).isNotNull();
        Method add = ReflectionUtil.findMethod(A.class, (String)"b", (Class[])new Class[]{Integer.class, Integer.class});
        Assertions.assertThat((Object)add).isNotNull();
        Assertions.assertThat((Object)ReflectionUtil.invokeMethod((Object)a, (Method)add, (Object[])new Object[]{1, 1})).isEqualTo((Object)2);
        Assertions.assertThatThrownBy(() -> ReflectionUtil.invokeMethod((Object)a, (Method)add, (Object[])new Object[]{1, null})).isInstanceOf(CacheException.class);
        Assertions.assertThatThrownBy(() -> ReflectionUtil.invokeMethod((Object)a, (Method)add, (Object[])new Object[]{"1", "1"})).isInstanceOf(CacheException.class);
        Assertions.assertThatThrownBy(() -> ReflectionUtil.findMethod(A.class, (String)"unknown")).isInstanceOf(CacheException.class);
        Assertions.assertThatThrownBy(() -> ReflectionUtil.findMethod(A.class, (String)"b", (Class[])new Class[]{Float.TYPE, Float.TYPE})).isInstanceOf(CacheException.class);
    }

    @Test
    public void testGetterAndSetter() {
        class A {
            private String field;
            private boolean flag;

            A() {
            }

            public void setField(String field) {
                this.field = field;
            }

            public void setFlag(boolean flag) {
                this.flag = flag;
            }

            public String getField() {
                return this.field;
            }

            public boolean isFlag() {
                return this.flag;
            }
        }
        Method setter = ReflectionUtil.findSetterForField(A.class, (String)"field");
        Assertions.assertThat((Object)setter).isNotNull();
        Method getter = ReflectionUtil.findGetterForField(A.class, (String)"field");
        Assertions.assertThat((Object)getter).isNotNull();
        Assertions.assertThat((Object)ReflectionUtil.findGetterForField(A.class, (String)"flag")).isNotNull();
        Assertions.assertThat((Object)ReflectionUtil.findSetterForField(A.class, (String)"flag")).isNotNull();
        class B
        extends A {
            B() {
            }
        }
        Assertions.assertThat((Object)ReflectionUtil.findSetterForField(B.class, (String)"field")).isNotNull();
        Assertions.assertThat((Object)ReflectionUtil.findGetterForField(B.class, (String)"field")).isNotNull();
        Assertions.assertThat((Object)ReflectionUtil.findSetterForField(A.class, (String)"unknown")).isNull();
        Assertions.assertThat((Object)ReflectionUtil.findSetterForField(B.class, (String)"unknown")).isNull();
        Assertions.assertThat((Object)ReflectionUtil.findGetterForField(A.class, (String)"unknown")).isNull();
        Assertions.assertThat((Object)ReflectionUtil.findGetterForField(B.class, (String)"unknown")).isNull();
    }

    @Test
    public void testStringify() throws Throwable {
        Class[] classes = new Class[]{Integer.TYPE, String.class};
        Object[] stringfied = ReflectionUtil.toStringArray((Class[])classes);
        ((ObjectArrayAssert)Assertions.assertThat((Object[])stringfied).hasSize(2)).containsExactly((Object[])new String[]{"int", "java.lang.String"});
        Assertions.assertThat((Object[])ReflectionUtil.toStringArray(null)).isEmpty();
        Assertions.assertThat((String)ReflectionUtil.extractFieldName((String)"getField")).isEqualTo("field");
        Assertions.assertThat((String)ReflectionUtil.extractFieldName((String)"setField")).isEqualTo("field");
        Assertions.assertThat((String)ReflectionUtil.extractFieldName((String)"isFlag")).isEqualTo("flag");
        Assertions.assertThat((String)ReflectionUtil.extractFieldName((String)"flag")).isNull();
        Object[] actual = ReflectionUtil.toClassArray((String[])stringfied, (ClassLoader)ReflectionUtil.class.getClassLoader());
        Assertions.assertThat((Object[])actual).isEqualTo((Object)classes);
        Assertions.assertThat((Object[])ReflectionUtil.toClassArray(null, (ClassLoader)ReflectionUtil.class.getClassLoader())).isEmpty();
    }

    @Target(value={ElementType.METHOD})
    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface MethodAnnotation {
    }

    @Target(value={ElementType.FIELD})
    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface FieldAnnotation {
    }

    @Target(value={ElementType.TYPE})
    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface ClassAnnotation {
    }
}

