/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.commons.util;

import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ThreadLocalRandom;
import java.util.stream.IntStream;
import org.assertj.core.api.AbstractStringAssert;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.infinispan.commons.CacheConfigurationException;
import org.infinispan.commons.hash.CRC16;
import org.infinispan.commons.hash.Hash;
import org.infinispan.commons.hash.MurmurHash3;
import org.infinispan.commons.util.Util;
import org.junit.Test;

public class UtilTest {
    @Test
    public void testToStr() {
        Assertions.assertThat((String)Util.toStr(null)).isEqualTo("[]");
        Assertions.assertThat((String)Util.toStr((Object)"")).isEqualTo("");
        Assertions.assertThat((String)Util.toStr((Object)new byte[]{1, 2, 3})).isEqualTo("[B0x010203");
        Assertions.assertThat((String)Util.toStr((Object)new char[]{'1', '2', '3'})).isEqualTo("[1, 2, 3]");
        Assertions.assertThat((String)Util.toStr((Object)new boolean[]{true, false})).isEqualTo("[true, false]");
        Assertions.assertThat((String)Util.toStr((Object)new int[]{1, 2, 3})).isEqualTo("[1, 2, 3]");
        Assertions.assertThat((String)Util.toStr((Object)new long[]{1L, 2L, 3L})).isEqualTo("[1, 2, 3]");
        Assertions.assertThat((String)Util.toStr((Object)new double[]{1.0, 2.0, 3.0})).isEqualTo("[1.0, 2.0, 3.0]");
        Assertions.assertThat((String)Util.toStr((Object)new float[]{1.0f, 2.0f, 3.0f})).isEqualTo("[1.0, 2.0, 3.0]");
        Assertions.assertThat((String)Util.toStr((Object)new String[]{"a", "b", "c"})).isEqualTo("[a, b, c]");
        Assertions.assertThat((String)Util.toStr((Object)new Object[]{"a", "b", "c"})).isEqualTo("[a, b, c]");
        Assertions.assertThat((String)Util.toStr((Object)new Object[]{1, 2, 3})).isEqualTo("[1, 2, 3]");
        Assertions.assertThat((String)Util.toStr((Object)new Object[]{1L, 2L, 3L})).isEqualTo("[1, 2, 3]");
        Assertions.assertThat((String)Util.toStr((Object)new Object[]{1.0, 2.0, 3.0})).isEqualTo("[1.0, 2.0, 3.0]");
    }

    @Test
    public void testNewInstanceOrNull() {
        Assertions.assertThat((Object)((MyClass)Util.newInstanceOrNull(MyClass.class, (Class[])new Class[]{String.class}, (Object[])new Object[]{"a"}))).isInstanceOf(MyClass.class);
        Assertions.assertThat((Object)((MyClass)Util.newInstanceOrNull(MyClass.class, (Class[])new Class[0], (Object[])new Object[0]))).isNull();
    }

    @Test
    public void testComposeWithExceptions() {
        Runnable runnable = Util.composeWithExceptions(() -> {
            throw new RuntimeException("one");
        }, () -> {
            throw new RuntimeException("two");
        });
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(runnable::run).isInstanceOf(RuntimeException.class)).hasMessageContaining("one").hasSuppressedException((Throwable)new RuntimeException("two"));
    }

    @Test
    public void testPrettyPrintTime() {
        Assertions.assertThat((String)Util.prettyPrintTime((long)500L)).isEqualTo("500 milliseconds");
        Assertions.assertThat((String)Util.prettyPrintTime((long)1000L)).isEqualTo("1 seconds");
        Assertions.assertThat((String)Util.prettyPrintTime((long)400000L)).isEqualTo("6.67 minutes");
        Assertions.assertThat((String)Util.prettyPrintTime((long)10000000L)).isEqualTo("2.78 hours");
    }

    @Test
    public void testUnicodeEscapeUnescape() {
        Assertions.assertThat((String)Util.unicodeEscapeString((String)"ab\t\\\t\n\r\f\u00e8")).isEqualTo("ab\\t\\\\\\t\\n\\r\\f\\u00E8");
        Assertions.assertThat((String)Util.unicodeUnescapeString((String)"\\u0061\\u0062\\u0063\\u00De")).isEqualTo("abc\u00de");
        Assertions.assertThat((String)Util.unicodeUnescapeString((String)"u\\\t\\\r\\\n\\\fo")).isEqualTo("u\t\r\n\fo");
        Assertions.assertThatThrownBy(() -> Util.unicodeUnescapeString((String)"\\u1BdG")).isInstanceOf(IllegalArgumentException.class);
    }

    @Test
    public void testArrayEquals() {
        byte[] a = new byte[]{98, 97, 108, 108, 111, 111, 110};
        byte[] b = new byte[]{109, 97, 108, 108, 111, 99, 46};
        Assertions.assertThat((boolean)Util.arraysEqual((byte[])a, (int)1, (int)3, (byte[])b, (int)1, (int)3)).isTrue();
        Assertions.assertThat((boolean)Util.arraysEqual((byte[])a, (int)1, (int)3, (byte[])b, (int)2, (int)3)).isFalse();
        Assertions.assertThat((boolean)Util.arraysEqual((byte[])a, (int)0, (int)2, (byte[])b, (int)0, (int)2)).isFalse();
        Assertions.assertThat((boolean)Util.arraysEqual((byte[])a, (int)1, (int)6, (byte[])b, (int)1, (int)6)).isFalse();
    }

    @Test
    public void testConcat() {
        byte[] a = new byte[]{104, 97};
        byte[] b = new byte[]{110, 100};
        byte[] hand = new byte[]{104, 97, 110, 100};
        Assertions.assertThat((byte[])Util.concat((byte[])a, (byte[])b)).isEqualTo((Object)hand);
        String[] hey = new String[]{"h", "e", "y"};
        Assertions.assertThat((Object[])((String[])Util.concat((Object[])new String[]{"h", "e"}, (Object)"y"))).isEqualTo((Object)hey);
    }

    @Test
    public void testStr() {
        Assertions.assertThat((String)Util.toStr((Collection)null)).isEqualTo("[]");
        Assertions.assertThat((String)Util.toStr(Collections.emptyList())).isEqualTo("[]");
        Assertions.assertThat((String)Util.toStr(List.of(Integer.valueOf(1), Integer.valueOf(2)))).isEqualTo("[1, 2]");
        Assertions.assertThat((String)Util.toStr(IntStream.range(0, 20).boxed().toList())).isEqualTo("[0, 1, 2, 3, 4, 5, 6, 7...<12 other elements>]");
        ArrayList<Serializable> a = new ArrayList<Serializable>();
        a.add(Integer.valueOf(1));
        a.add(Integer.valueOf(2));
        a.add(a);
        Assertions.assertThat((String)Util.toStr(a)).isEqualTo("[1, 2, (this Collection)]");
    }

    @Test
    public void testHexDump() {
        byte[] smallDatum = new byte[32];
        ThreadLocalRandom.current().nextBytes(smallDatum);
        String h = Util.hexDump((byte[])smallDatum);
        Assertions.assertThat((String)h).isNotEmpty();
        Assertions.assertThat((String)Util.hexDump((ByteBuffer)ByteBuffer.wrap(smallDatum))).isEqualTo(h);
        byte[] largeDatum = new byte[128];
        ThreadLocalRandom.current().nextBytes(largeDatum);
        h = Util.hexDump((byte[])largeDatum);
        Assertions.assertThat((String)h).endsWith((CharSequence)" bytes)");
        Assertions.assertThat((String)Util.hexDump((ByteBuffer)ByteBuffer.wrap(largeDatum))).isEqualTo(h);
    }

    @Test
    public void testUnwrapExceptionMessage() {
        Assertions.assertThat((String)Util.unwrapExceptionMessage((Throwable)new IllegalStateException("message 1"))).isEqualTo("message 1");
        IllegalStateException e1 = new IllegalStateException("message 1");
        IllegalStateException e2 = new IllegalStateException("message 2");
        e1.addSuppressed(e2);
        Assertions.assertThat((String)Util.unwrapExceptionMessage((Throwable)e1)).isEqualTo("message 1\n    message 2");
        e1 = new IllegalStateException("message");
        e2 = new IllegalStateException("message");
        e1.addSuppressed(e2);
        Assertions.assertThat((String)Util.unwrapExceptionMessage((Throwable)e1)).isEqualTo("message");
    }

    @Test
    public void testGetInstance() {
        Assertions.assertThat((String)((String)Util.getInstance((String)String.class.getName(), (ClassLoader)Util.class.getClassLoader()))).isNotNull();
        Assertions.assertThat((Object)((CRC16)Util.getInstance((String)CRC16.class.getName(), (ClassLoader)Util.class.getClassLoader()))).isEqualTo((Object)CRC16.getInstance());
        Assertions.assertThatThrownBy(() -> {
            class A {
                private A() {
                }
            }
            Util.getInstance((String)A.class.getName(), (ClassLoader)Util.class.getClassLoader());
        }).isInstanceOf(CacheConfigurationException.class);
    }

    @Test
    public void testPrintArray() {
        byte[] arr = new byte[]{104, 105};
        Assertions.assertThat((String)Util.printArray((byte[])arr, (boolean)true)).isEqualTo("[B0x6869,h=10c2]");
        arr = new byte[32];
        ThreadLocalRandom.current().nextBytes(arr);
        ((AbstractStringAssert)Assertions.assertThat((String)Util.printArray((byte[])arr, (boolean)true)).contains(new CharSequence[]{"..[32],h="})).startsWith((CharSequence)"[B0x");
    }

    @Test
    public void testSegmentSize() {
        Assertions.assertThat((int)Util.getSegmentSize((Hash)CRC16.getInstance(), (int)256)).isEqualTo(256);
        Assertions.assertThat((int)Util.getSegmentSize((Hash)MurmurHash3.getInstance(), (int)256)).isEqualTo(0x800000);
    }

    static class MyClass {
        public MyClass(String s) {
        }
    }
}

