/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.commons.equivalence;

import org.infinispan.commons.equivalence.Equivalence;

public final class AnyEquivalence<T>
implements Equivalence<T> {
    private static AnyEquivalence<Object> OBJECT = new AnyEquivalence();
    public static AnyEquivalence<String> STRING = AnyEquivalence.getInstance(String.class);
    public static AnyEquivalence<Byte> BYTE = AnyEquivalence.getInstance(Byte.class);
    public static AnyEquivalence<Short> SHORT = AnyEquivalence.getInstance(Short.class);
    public static AnyEquivalence<Integer> INT = AnyEquivalence.getInstance(Integer.class);
    public static AnyEquivalence<Long> LONG = AnyEquivalence.getInstance(Long.class);
    public static AnyEquivalence<Double> DOUBLE = AnyEquivalence.getInstance(Double.class);
    public static AnyEquivalence<Float> FLOAT = AnyEquivalence.getInstance(Float.class);
    public static AnyEquivalence<Boolean> BOOLEAN = AnyEquivalence.getInstance(Boolean.class);

    private AnyEquivalence() {
    }

    @Override
    public int hashCode(Object obj) {
        return obj == null ? 0 : obj.hashCode();
    }

    @Override
    public boolean equals(T obj, Object otherObj) {
        return obj != null && obj.equals(otherObj);
    }

    @Override
    public String toString(Object obj) {
        return String.valueOf(obj);
    }

    @Override
    public boolean isComparable(Object obj) {
        return obj instanceof Comparable;
    }

    @Override
    public int compare(T obj, T otherObj) {
        return ((Comparable)obj).compareTo(otherObj);
    }

    public static <T> AnyEquivalence<T> getInstance() {
        return OBJECT;
    }

    public static <T> AnyEquivalence<T> getInstance(Class<T> classType) {
        return OBJECT;
    }
}

