/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.extendedstats;

import java.lang.invoke.MethodHandles;
import java.util.concurrent.TimeUnit;
import org.infinispan.commons.time.TimeService;
import org.infinispan.extendedstats.ExtendedStatisticNotFoundException;
import org.infinispan.extendedstats.container.ConcurrentGlobalContainer;
import org.infinispan.extendedstats.container.ExtendedStatistic;
import org.infinispan.extendedstats.container.ExtendedStatisticsContainer;
import org.infinispan.extendedstats.logging.Log;
import org.infinispan.util.logging.LogFactory;

public abstract class TransactionStatistics {
    protected final long initTime;
    protected static final Log log = (Log)LogFactory.getLog(MethodHandles.lookup().lookupClass(), Log.class);
    protected final TimeService timeService;
    private final ExtendedStatisticsContainer container;
    private boolean readOnly;
    private boolean committed;

    protected TransactionStatistics(ExtendedStatisticsContainer container, TimeService timeService) {
        this.timeService = timeService;
        this.initTime = timeService.time();
        this.readOnly = true;
        this.container = container;
        if (log.isTraceEnabled()) {
            log.tracef("Created transaction statistics. Start time=%s", this.initTime);
        }
    }

    public final boolean isCommitted() {
        return this.committed;
    }

    public final void setOutcome(boolean commit) {
        this.committed = commit;
    }

    public final boolean isReadOnly() {
        return this.readOnly;
    }

    public final void markAsUpdateTransaction() {
        this.readOnly = false;
    }

    public final void addValue(ExtendedStatistic stat, double value) {
        this.container.addValue(stat, value);
        if (log.isTraceEnabled()) {
            log.tracef("Add %s to %s", value, (Object)stat);
        }
    }

    public final double getValue(ExtendedStatistic stat) throws ExtendedStatisticNotFoundException {
        double value = this.container.getValue(stat);
        if (log.isTraceEnabled()) {
            log.tracef("Value of %s is %s", (Object)stat, value);
        }
        return value;
    }

    public final void incrementValue(ExtendedStatistic stat) {
        this.addValue(stat, 1.0);
    }

    public final void terminateTransaction() {
        if (log.isTraceEnabled()) {
            log.tracef("Terminating transaction. Is read only? %s. Is commit? %s", this.readOnly, this.committed);
        }
        long execTime = this.timeService.timeDuration(this.initTime, TimeUnit.NANOSECONDS);
        if (this.readOnly) {
            if (this.committed) {
                this.incrementValue(ExtendedStatistic.NUM_COMMITTED_RO_TX);
                this.addValue(ExtendedStatistic.RO_TX_SUCCESSFUL_EXECUTION_TIME, execTime);
            } else {
                this.incrementValue(ExtendedStatistic.NUM_ABORTED_RO_TX);
                this.addValue(ExtendedStatistic.RO_TX_ABORTED_EXECUTION_TIME, execTime);
            }
        } else if (this.committed) {
            this.incrementValue(ExtendedStatistic.NUM_COMMITTED_WR_TX);
            this.addValue(ExtendedStatistic.WR_TX_SUCCESSFUL_EXECUTION_TIME, execTime);
        } else {
            this.incrementValue(ExtendedStatistic.NUM_ABORTED_WR_TX);
            this.addValue(ExtendedStatistic.WR_TX_ABORTED_EXECUTION_TIME, execTime);
        }
        this.terminate();
    }

    public final void flushTo(ConcurrentGlobalContainer globalContainer) {
        if (log.isTraceEnabled()) {
            log.tracef("Flush this [%s] to %s", this, globalContainer);
        }
        this.container.mergeTo(globalContainer);
    }

    public String toString() {
        return "initTime=" + this.initTime + ", readOnly=" + this.readOnly + ", committed=" + this.committed + "}";
    }

    public abstract void onPrepareCommand();

    public abstract boolean isLocalTransaction();

    protected abstract void terminate();

    protected final void copyValue(ExtendedStatistic from, ExtendedStatistic to) {
        try {
            double value = this.container.getValue(from);
            this.container.addValue(to, value);
            if (log.isDebugEnabled()) {
                log.debugf("Copy value [%s] from [%s] to [%s]", value, (Object)from, (Object)to);
            }
        }
        catch (ExtendedStatisticNotFoundException e) {
            log.unableToCopyValue(from, to, e);
        }
    }
}

