/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.hotrod.impl.multimap.operations;

import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import net.jcip.annotations.Immutable;
import org.infinispan.api.common.CacheOptions;
import org.infinispan.hotrod.impl.DataFormat;
import org.infinispan.hotrod.impl.multimap.operations.AbstractMultimapKeyOperation;
import org.infinispan.hotrod.impl.operations.OperationContext;
import org.infinispan.hotrod.impl.protocol.HotRodConstants;
import org.infinispan.hotrod.impl.transport.netty.ByteBufUtil;
import org.infinispan.hotrod.impl.transport.netty.HeaderDecoder;
import org.infinispan.hotrod.marshall.MarshallerUtil;

@Immutable
public class GetKeyMultimapOperation<K, V>
extends AbstractMultimapKeyOperation<K, Collection<V>> {
    private int size;
    private Collection<V> result;

    public GetKeyMultimapOperation(OperationContext operationContext, K key, byte[] keyBytes, CacheOptions options, DataFormat dataFormat, boolean supportsDuplicates) {
        super(operationContext, (short)103, (short)104, key, keyBytes, options, dataFormat, supportsDuplicates);
    }

    @Override
    protected void reset() {
        super.reset();
        this.result = null;
    }

    @Override
    public void acceptResponse(ByteBuf buf, short status, HeaderDecoder decoder) {
        if (HotRodConstants.isNotExist(status)) {
            this.complete(Collections.emptySet());
            return;
        }
        if (this.result == null) {
            this.size = ByteBufUtil.readVInt(buf);
            this.result = this.supportsDuplicates ? new ArrayList(this.size) : new HashSet(this.size);
            decoder.checkpoint();
        }
        while (this.result.size() < this.size) {
            Object value = MarshallerUtil.bytes2obj(this.operationContext.getChannelFactory().getMarshaller(), ByteBufUtil.readArray(buf), this.dataFormat().isObjectStorage(), this.operationContext.getConfiguration().getClassAllowList());
            this.result.add(value);
            decoder.checkpoint();
        }
        this.complete(this.result);
    }
}

