/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.hotrod.impl.counter;

import java.util.concurrent.CompletableFuture;
import org.infinispan.counter.api.CounterConfiguration;
import org.infinispan.counter.api.CounterListener;
import org.infinispan.counter.api.Handle;
import org.infinispan.hotrod.impl.counter.CounterOperationFactory;
import org.infinispan.hotrod.impl.counter.NotificationManager;

public class BaseCounter {
    protected final String name;
    protected final CounterConfiguration configuration;
    protected final CounterOperationFactory factory;
    private final NotificationManager notificationManager;

    BaseCounter(CounterConfiguration configuration, String name, CounterOperationFactory factory, NotificationManager notificationManager) {
        this.configuration = configuration;
        this.name = name;
        this.factory = factory;
        this.notificationManager = notificationManager;
    }

    public String getName() {
        return this.name;
    }

    public CompletableFuture<Void> reset() {
        return this.factory.newResetOperation(this.name, this.useConsistentHash()).execute().toCompletableFuture();
    }

    public CompletableFuture<Void> remove() {
        return this.factory.newRemoveOperation(this.name, this.useConsistentHash()).execute().toCompletableFuture();
    }

    public CounterConfiguration getConfiguration() {
        return this.configuration;
    }

    public <T extends CounterListener> Handle<T> addListener(T listener) {
        return this.notificationManager.addListener(this.name, listener);
    }

    boolean useConsistentHash() {
        return false;
    }
}

