/*
 * Decompiled with CFR 0.152.
 */
package io.protostuff;

import java.math.BigInteger;

public final class UnsignedNumberUtil {
    public static final long MAX_VALUE = -1L;
    static final long INT_MASK = 0xFFFFFFFFL;
    private static final long[] maxValueDivs = new long[37];
    private static final int[] maxValueMods = new int[37];
    private static final int[] maxSafeDigits = new int[37];

    static {
        BigInteger overflow = new BigInteger("10000000000000000", 16);
        int i = 2;
        while (i <= 36) {
            UnsignedNumberUtil.maxValueDivs[i] = UnsignedNumberUtil.divide(-1L, i);
            UnsignedNumberUtil.maxValueMods[i] = (int)UnsignedNumberUtil.remainder(-1L, i);
            UnsignedNumberUtil.maxSafeDigits[i] = overflow.toString(i).length() - 1;
            ++i;
        }
    }

    private UnsignedNumberUtil() {
    }

    private static int flip(int value) {
        return value ^ Integer.MIN_VALUE;
    }

    private static long flip(long a) {
        return a ^ Long.MIN_VALUE;
    }

    private static long toLong(int value) {
        return (long)value & 0xFFFFFFFFL;
    }

    public static int parseUnsignedInt(String s) {
        return UnsignedNumberUtil.parseUnsignedInt(s, 10);
    }

    private static int parseUnsignedInt(String string, int radix) {
        long result = Long.parseLong(string, radix);
        if ((result & 0xFFFFFFFFL) != result) {
            throw new NumberFormatException("Input " + string + " in base " + radix + " is not in the range of an unsigned integer");
        }
        return (int)result;
    }

    public static String unsignedIntToString(int x) {
        return UnsignedNumberUtil.unsignedIntToString(x, 10);
    }

    private static int compareUnsigned(long a, long b) {
        return UnsignedNumberUtil.compareSigned(UnsignedNumberUtil.flip(a), UnsignedNumberUtil.flip(b));
    }

    private static int compareSigned(long a, long b) {
        return a < b ? -1 : (a > b ? 1 : 0);
    }

    private static String unsignedIntToString(int x, int radix) {
        long asLong = (long)x & 0xFFFFFFFFL;
        return Long.toString(asLong, radix);
    }

    private static long divide(long dividend, long divisor) {
        long quotient;
        if (divisor < 0L) {
            if (UnsignedNumberUtil.compareUnsigned(dividend, divisor) < 0) {
                return 0L;
            }
            return 1L;
        }
        if (dividend >= 0L) {
            return dividend / divisor;
        }
        long rem = dividend - (quotient = (dividend >>> 1) / divisor << 1) * divisor;
        return quotient + (long)(UnsignedNumberUtil.compareUnsigned(rem, divisor) >= 0 ? 1 : 0);
    }

    private static long remainder(long dividend, long divisor) {
        long rem;
        if (divisor < 0L) {
            if (UnsignedNumberUtil.compareUnsigned(dividend, divisor) < 0) {
                return dividend;
            }
            return dividend - divisor;
        }
        if (dividend >= 0L) {
            return dividend % divisor;
        }
        long quotient = (dividend >>> 1) / divisor << 1;
        return rem - (UnsignedNumberUtil.compareUnsigned(rem = dividend - quotient * divisor, divisor) >= 0 ? divisor : 0L);
    }

    public static long parseUnsignedLong(String s) {
        return UnsignedNumberUtil.parseUnsignedLong(s, 10);
    }

    private static long parseUnsignedLong(String s, int radix) {
        if (s.length() == 0) {
            throw new NumberFormatException("empty string");
        }
        if (radix < 2 || radix > 36) {
            throw new NumberFormatException("illegal radix: " + radix);
        }
        int max_safe_pos = maxSafeDigits[radix] - 1;
        long value = 0L;
        int pos = 0;
        while (pos < s.length()) {
            int digit = Character.digit(s.charAt(pos), radix);
            if (digit == -1) {
                throw new NumberFormatException(s);
            }
            if (pos > max_safe_pos && UnsignedNumberUtil.overflowInParse(value, digit, radix)) {
                throw new NumberFormatException("Too large for unsigned long: " + s);
            }
            value = value * (long)radix + (long)digit;
            ++pos;
        }
        return value;
    }

    private static boolean overflowInParse(long current, int digit, int radix) {
        if (current >= 0L) {
            if (current < maxValueDivs[radix]) {
                return false;
            }
            if (current > maxValueDivs[radix]) {
                return true;
            }
            return digit > maxValueMods[radix];
        }
        return true;
    }

    public static String unsignedLongToString(long x) {
        return UnsignedNumberUtil.unsignedLongToString(x, 10);
    }

    private static String unsignedLongToString(long x, int radix) {
        if (radix < 2 || radix > 36) {
            throw new IllegalArgumentException("Invalid radix: " + radix);
        }
        if (x == 0L) {
            return "0";
        }
        char[] buf = new char[64];
        int i = buf.length;
        if (x < 0L) {
            long quotient = UnsignedNumberUtil.divide(x, radix);
            long rem = x - quotient * (long)radix;
            buf[--i] = Character.forDigit((int)rem, radix);
            x = quotient;
        }
        while (x > 0L) {
            buf[--i] = Character.forDigit((int)(x % (long)radix), radix);
            x /= (long)radix;
        }
        return new String(buf, i, buf.length - i);
    }
}

