/*
 * Decompiled with CFR 0.152.
 */
package io.protostuff.runtime;

import io.protostuff.CollectionSchema;
import io.protostuff.Input;
import io.protostuff.MapSchema;
import io.protostuff.Message;
import io.protostuff.Output;
import io.protostuff.Pipe;
import io.protostuff.Schema;
import io.protostuff.runtime.Delegate;
import io.protostuff.runtime.EnumIO;
import io.protostuff.runtime.HasDelegate;
import io.protostuff.runtime.HasSchema;
import io.protostuff.runtime.IdStrategy;
import io.protostuff.runtime.NumericIdStrategy;
import io.protostuff.runtime.RuntimeSchema;
import java.io.IOException;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.IdentityHashMap;
import java.util.Map;

public final class ExplicitIdStrategy
extends NumericIdStrategy {
    final IdentityHashMap<Class<?>, RegisteredCollectionFactory> collectionMapping;
    final ArrayList<RegisteredCollectionFactory> collections;
    final IdentityHashMap<Class<?>, RegisteredMapFactory> mapMapping;
    final ArrayList<RegisteredMapFactory> maps;
    final IdentityHashMap<Class<?>, RegisteredEnumIO> enumMapping;
    final ArrayList<RegisteredEnumIO> enums;
    final IdentityHashMap<Class<?>, BaseHS<?>> pojoMapping;
    final ArrayList<BaseHS<?>> pojos;
    final IdentityHashMap<Class<?>, NumericIdStrategy.RegisteredDelegate<?>> delegateMapping;
    final ArrayList<NumericIdStrategy.RegisteredDelegate<?>> delegates;

    public ExplicitIdStrategy(IdentityHashMap<Class<?>, RegisteredCollectionFactory> collectionMapping, ArrayList<RegisteredCollectionFactory> collections, IdentityHashMap<Class<?>, RegisteredMapFactory> mapMapping, ArrayList<RegisteredMapFactory> maps, IdentityHashMap<Class<?>, RegisteredEnumIO> enumMapping, ArrayList<RegisteredEnumIO> enums, IdentityHashMap<Class<?>, BaseHS<?>> pojoMapping, ArrayList<BaseHS<?>> pojos, IdentityHashMap<Class<?>, NumericIdStrategy.RegisteredDelegate<?>> delegateMapping, ArrayList<NumericIdStrategy.RegisteredDelegate<?>> delegates) {
        this(DEFAULT_FLAGS, null, 0, collectionMapping, collections, mapMapping, maps, enumMapping, enums, pojoMapping, pojos, delegateMapping, delegates);
    }

    public ExplicitIdStrategy(int flags, IdStrategy primaryGroup, int groupId, IdentityHashMap<Class<?>, RegisteredCollectionFactory> collectionMapping, ArrayList<RegisteredCollectionFactory> collections, IdentityHashMap<Class<?>, RegisteredMapFactory> mapMapping, ArrayList<RegisteredMapFactory> maps, IdentityHashMap<Class<?>, RegisteredEnumIO> enumMapping, ArrayList<RegisteredEnumIO> enums, IdentityHashMap<Class<?>, BaseHS<?>> pojoMapping, ArrayList<BaseHS<?>> pojos, IdentityHashMap<Class<?>, NumericIdStrategy.RegisteredDelegate<?>> delegateMapping, ArrayList<NumericIdStrategy.RegisteredDelegate<?>> delegates) {
        super(flags, primaryGroup, groupId);
        this.collectionMapping = collectionMapping;
        this.collections = collections;
        this.mapMapping = mapMapping;
        this.maps = maps;
        this.enumMapping = enumMapping;
        this.enums = enums;
        this.pojoMapping = pojoMapping;
        this.pojos = pojos;
        this.delegateMapping = delegateMapping;
        this.delegates = delegates;
    }

    @Override
    public boolean isRegistered(Class<?> typeClass) {
        return this.pojoMapping.containsKey(typeClass);
    }

    @Override
    public <T> HasSchema<T> getSchemaWrapper(Class<T> typeClass, boolean create) {
        BaseHS<?> wrapper = this.pojoMapping.get(typeClass);
        if (wrapper == null && create) {
            throw new IdStrategy.UnknownTypeException("pojo: " + typeClass);
        }
        return wrapper;
    }

    @Override
    protected EnumIO<? extends Enum<?>> getEnumIO(Class<?> enumClass) {
        RegisteredEnumIO reio = this.enumMapping.get(enumClass);
        if (reio == null) {
            throw new IdStrategy.UnknownTypeException("enum: " + enumClass);
        }
        return reio.eio;
    }

    @Override
    protected CollectionSchema.MessageFactory getCollectionFactory(Class<?> clazz) {
        RegisteredCollectionFactory rf = this.collectionMapping.get(clazz);
        if (rf == null) {
            if (clazz.getName().startsWith("java.util")) {
                return CollectionSchema.MessageFactories.valueOf(clazz.getSimpleName());
            }
            throw new IdStrategy.UnknownTypeException("collection: " + clazz);
        }
        return rf;
    }

    @Override
    protected MapSchema.MessageFactory getMapFactory(Class<?> clazz) {
        RegisteredMapFactory rf = this.mapMapping.get(clazz);
        if (rf == null) {
            if (clazz.getName().startsWith("java.util")) {
                return MapSchema.MessageFactories.valueOf(clazz.getSimpleName());
            }
            throw new IdStrategy.UnknownTypeException("map: " + clazz);
        }
        return rf;
    }

    @Override
    protected void writeCollectionIdTo(Output output, int fieldNumber, Class<?> clazz) throws IOException {
        RegisteredCollectionFactory factory = this.collectionMapping.get(clazz);
        if (factory == null) {
            throw new IdStrategy.UnknownTypeException("collection: " + clazz);
        }
        output.writeUInt32(fieldNumber, factory.id, false);
    }

    @Override
    protected void transferCollectionId(Input input, Output output, int fieldNumber) throws IOException {
        output.writeUInt32(fieldNumber, input.readUInt32(), false);
    }

    @Override
    protected CollectionSchema.MessageFactory resolveCollectionFrom(Input input) throws IOException {
        RegisteredCollectionFactory factory;
        int id = input.readUInt32();
        RegisteredCollectionFactory registeredCollectionFactory = factory = id < this.collections.size() ? this.collections.get(id) : null;
        if (factory == null) {
            throw new IdStrategy.UnknownTypeException("collection id: " + id + " (Outdated registry)");
        }
        return factory;
    }

    @Override
    protected void writeMapIdTo(Output output, int fieldNumber, Class<?> clazz) throws IOException {
        RegisteredMapFactory factory = this.mapMapping.get(clazz);
        if (factory == null) {
            throw new IdStrategy.UnknownTypeException("map: " + clazz);
        }
        output.writeUInt32(fieldNumber, factory.id, false);
    }

    @Override
    protected void transferMapId(Input input, Output output, int fieldNumber) throws IOException {
        output.writeUInt32(fieldNumber, input.readUInt32(), false);
    }

    @Override
    protected MapSchema.MessageFactory resolveMapFrom(Input input) throws IOException {
        RegisteredMapFactory factory;
        int id = input.readUInt32();
        RegisteredMapFactory registeredMapFactory = factory = id < this.maps.size() ? this.maps.get(id) : null;
        if (factory == null) {
            throw new IdStrategy.UnknownTypeException("map id: " + id + " (Outdated registry)");
        }
        return factory;
    }

    @Override
    protected void writeEnumIdTo(Output output, int fieldNumber, Class<?> clazz) throws IOException {
        RegisteredEnumIO reio = this.enumMapping.get(clazz);
        if (reio == null) {
            throw new IdStrategy.UnknownTypeException("enum: " + clazz);
        }
        output.writeUInt32(fieldNumber, reio.id, false);
    }

    @Override
    protected void transferEnumId(Input input, Output output, int fieldNumber) throws IOException {
        output.writeUInt32(fieldNumber, input.readUInt32(), false);
    }

    @Override
    protected EnumIO<?> resolveEnumFrom(Input input) throws IOException {
        RegisteredEnumIO reio;
        int id = input.readUInt32();
        RegisteredEnumIO registeredEnumIO = reio = id < this.enums.size() ? this.enums.get(id) : null;
        if (reio == null) {
            throw new IdStrategy.UnknownTypeException("enum id: " + id + " (Outdated registry)");
        }
        return reio.eio;
    }

    @Override
    public boolean isDelegateRegistered(Class<?> typeClass) {
        return this.delegateMapping.containsKey(typeClass);
    }

    @Override
    public <T> Delegate<T> getDelegate(Class<? super T> typeClass) {
        NumericIdStrategy.RegisteredDelegate<?> rd = this.delegateMapping.get(typeClass);
        return rd == null ? null : rd.delegate;
    }

    @Override
    public <T> HasDelegate<T> getDelegateWrapper(Class<? super T> typeClass) {
        return this.delegateMapping.get(typeClass);
    }

    @Override
    protected <T> HasDelegate<T> tryWriteDelegateIdTo(Output output, int fieldNumber, Class<T> clazz) throws IOException {
        NumericIdStrategy.RegisteredDelegate<?> rd = this.delegateMapping.get(clazz);
        if (rd == null) {
            return null;
        }
        output.writeUInt32(fieldNumber, rd.id, false);
        return rd;
    }

    @Override
    protected <T> HasDelegate<T> transferDelegateId(Input input, Output output, int fieldNumber) throws IOException {
        NumericIdStrategy.RegisteredDelegate<?> rd;
        int id = input.readUInt32();
        NumericIdStrategy.RegisteredDelegate<?> registeredDelegate = rd = id < this.delegates.size() ? this.delegates.get(id) : null;
        if (rd == null) {
            throw new IdStrategy.UnknownTypeException("delegate id: " + id + " (Outdated registry)");
        }
        output.writeUInt32(fieldNumber, id, false);
        return rd;
    }

    @Override
    protected <T> HasDelegate<T> resolveDelegateFrom(Input input) throws IOException {
        NumericIdStrategy.RegisteredDelegate<?> rd;
        int id = input.readUInt32();
        NumericIdStrategy.RegisteredDelegate<?> registeredDelegate = rd = id < this.delegates.size() ? this.delegates.get(id) : null;
        if (rd == null) {
            throw new IdStrategy.UnknownTypeException("delegate id: " + id + " (Outdated registry)");
        }
        return rd;
    }

    @Override
    protected <T> HasSchema<T> tryWritePojoIdTo(Output output, int fieldNumber, Class<T> clazz, boolean registered) throws IOException {
        BaseHS<?> wrapper = this.pojoMapping.get(clazz);
        if (wrapper != null) {
            output.writeUInt32(fieldNumber, wrapper.id, false);
        }
        return wrapper;
    }

    @Override
    protected <T> HasSchema<T> writePojoIdTo(Output output, int fieldNumber, Class<T> clazz) throws IOException {
        BaseHS<?> wrapper = this.pojoMapping.get(clazz);
        if (wrapper == null) {
            throw new IdStrategy.UnknownTypeException("pojo: " + clazz);
        }
        output.writeUInt32(fieldNumber, wrapper.id, false);
        return wrapper;
    }

    @Override
    protected <T> HasSchema<T> transferPojoId(Input input, Output output, int fieldNumber) throws IOException {
        int id = input.readUInt32();
        BaseHS<?> wrapper = this.pojos.get(id);
        if (wrapper == null) {
            throw new IdStrategy.UnknownTypeException("pojo id: " + id + " (Outdated registry)");
        }
        output.writeUInt32(fieldNumber, id, false);
        return wrapper;
    }

    @Override
    protected <T> HasSchema<T> resolvePojoFrom(Input input, int fieldNumber) throws IOException {
        BaseHS<?> wrapper;
        int id = input.readUInt32();
        BaseHS<?> baseHS = wrapper = id < this.pojos.size() ? this.pojos.get(id) : null;
        if (wrapper == null) {
            throw new IdStrategy.UnknownTypeException("pojo id: " + id + " (Outdated registry)");
        }
        return wrapper;
    }

    @Override
    protected <T> Schema<T> writeMessageIdTo(Output output, int fieldNumber, Message<T> message) throws IOException {
        BaseHS<?> wrapper = this.pojoMapping.get(message.getClass());
        if (wrapper == null) {
            throw new IdStrategy.UnknownTypeException("pojo: " + message.getClass());
        }
        output.writeUInt32(fieldNumber, wrapper.id, false);
        return message.cachedSchema();
    }

    @Override
    protected Class<?> collectionClass(int id) {
        RegisteredCollectionFactory factory;
        RegisteredCollectionFactory registeredCollectionFactory = factory = id < this.collections.size() ? this.collections.get(id) : null;
        if (factory == null) {
            throw new IdStrategy.UnknownTypeException("collection id: " + id + " (Outdated registry)");
        }
        return factory.typeClass();
    }

    @Override
    protected Class<?> mapClass(int id) {
        RegisteredMapFactory factory;
        RegisteredMapFactory registeredMapFactory = factory = id < this.maps.size() ? this.maps.get(id) : null;
        if (factory == null) {
            throw new IdStrategy.UnknownTypeException("map id: " + id + " (Outdated registry)");
        }
        return factory.typeClass();
    }

    @Override
    protected Class<?> enumClass(int id) {
        RegisteredEnumIO reio;
        RegisteredEnumIO registeredEnumIO = reio = id < this.enums.size() ? this.enums.get(id) : null;
        if (reio == null) {
            throw new IdStrategy.UnknownTypeException("enum id: " + id + " (Outdated registry)");
        }
        return reio.eio.enumClass;
    }

    @Override
    protected Class<?> delegateClass(int id) {
        NumericIdStrategy.RegisteredDelegate<?> rd = id < this.delegates.size() ? this.delegates.get(id) : null;
        return rd == null ? null : rd.delegate.typeClass();
    }

    @Override
    protected Class<?> pojoClass(int id) {
        BaseHS<?> wrapper;
        BaseHS<?> baseHS = wrapper = id < this.pojos.size() ? this.pojos.get(id) : null;
        if (wrapper == null) {
            throw new IdStrategy.UnknownTypeException("pojo id: " + id + " (Outdated registry)");
        }
        return wrapper.getSchema().typeClass();
    }

    @Override
    protected NumericIdStrategy.RegisteredDelegate<?> getRegisteredDelegate(Class<?> clazz) {
        return this.delegateMapping.get(clazz);
    }

    @Override
    protected int getEnumId(Class<?> clazz) {
        RegisteredEnumIO reio = this.enumMapping.get(clazz);
        if (reio == null) {
            throw new IdStrategy.UnknownTypeException("enum: " + clazz);
        }
        return reio.id << 5 | 0x19;
    }

    @Override
    protected int getId(Class<?> clazz) {
        if (Message.class.isAssignableFrom(clazz)) {
            BaseHS<?> wrapper = this.pojoMapping.get(clazz);
            if (wrapper == null) {
                throw new IdStrategy.UnknownTypeException("pojo: " + clazz);
            }
            return wrapper.id << 5 | 0x1C;
        }
        if (Map.class.isAssignableFrom(clazz)) {
            return EnumMap.class.isAssignableFrom(clazz) ? 24 : this.mapId(clazz);
        }
        if (Collection.class.isAssignableFrom(clazz)) {
            return EnumSet.class.isAssignableFrom(clazz) ? 23 : this.collectionId(clazz);
        }
        BaseHS<?> wrapper = this.pojoMapping.get(clazz);
        if (wrapper == null) {
            throw new IdStrategy.UnknownTypeException("pojo: " + clazz);
        }
        return wrapper.id << 5 | 0x1C;
    }

    private int collectionId(Class<?> clazz) {
        RegisteredCollectionFactory factory = this.collectionMapping.get(clazz);
        if (factory == null) {
            throw new IdStrategy.UnknownTypeException("collection: " + clazz);
        }
        return factory.id << 5 | 0x1A;
    }

    private int mapId(Class<?> clazz) {
        RegisteredMapFactory factory = this.mapMapping.get(clazz);
        if (factory == null) {
            throw new IdStrategy.UnknownTypeException("map: " + clazz);
        }
        return factory.id << 5 | 0x1B;
    }

    static <K, V> IdentityHashMap<K, V> newMap(int size) {
        return new IdentityHashMap(size);
    }

    static final class Lazy<T>
    extends BaseHS<T> {
        final Class<T> typeClass;
        private volatile Schema<T> schema;
        private volatile Pipe.Schema<T> pipeSchema;

        Lazy(int id, Class<T> typeClass, IdStrategy strategy) {
            super(id, strategy);
            this.typeClass = typeClass;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Schema<T> getSchema() {
            Schema<T> schema = this.schema;
            if (schema == null) {
                Lazy lazy = this;
                synchronized (lazy) {
                    schema = this.schema;
                    if (schema == null) {
                        if (Message.class.isAssignableFrom(this.typeClass)) {
                            Message m = (Message)IdStrategy.createMessageInstance(this.typeClass);
                            this.schema = schema = m.cachedSchema();
                        } else {
                            this.schema = schema = this.strategy.newSchema(this.typeClass);
                        }
                    }
                }
            }
            return schema;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Pipe.Schema<T> getPipeSchema() {
            Pipe.Schema<T> pipeSchema = this.pipeSchema;
            if (pipeSchema == null) {
                Lazy lazy = this;
                synchronized (lazy) {
                    pipeSchema = this.pipeSchema;
                    if (pipeSchema == null) {
                        this.pipeSchema = pipeSchema = RuntimeSchema.resolvePipeSchema(this.getSchema(), this.typeClass, true);
                    }
                }
            }
            return pipeSchema;
        }
    }

    static final class Registered<T>
    extends BaseHS<T> {
        final Schema<T> schema;
        final Pipe.Schema<T> pipeSchema;

        Registered(int id, Schema<T> schema, Pipe.Schema<T> pipeSchema, IdStrategy strategy) {
            super(id, strategy);
            this.schema = schema;
            this.pipeSchema = pipeSchema;
        }

        @Override
        public Schema<T> getSchema() {
            return this.schema;
        }

        @Override
        public Pipe.Schema<T> getPipeSchema() {
            return this.pipeSchema;
        }
    }

    static abstract class BaseHS<T>
    extends HasSchema<T> {
        final int id;

        BaseHS(int id, IdStrategy strategy) {
            super(strategy);
            this.id = id;
        }
    }

    static final class RegisteredEnumIO {
        final int id;
        final EnumIO<?> eio;

        public RegisteredEnumIO(int id, EnumIO<?> eio) {
            this.id = id;
            this.eio = eio;
        }
    }

    static final class RegisteredMapFactory
    implements MapSchema.MessageFactory {
        final int id;
        final MapSchema.MessageFactory factory;

        public RegisteredMapFactory(int id, MapSchema.MessageFactory factory) {
            this.id = id;
            this.factory = factory;
        }

        @Override
        public <K, V> Map<K, V> newMessage() {
            return this.factory.newMessage();
        }

        @Override
        public Class<?> typeClass() {
            return this.factory.typeClass();
        }
    }

    static final class RegisteredCollectionFactory
    implements CollectionSchema.MessageFactory {
        final int id;
        final CollectionSchema.MessageFactory factory;

        public RegisteredCollectionFactory(int id, CollectionSchema.MessageFactory factory) {
            this.id = id;
            this.factory = factory;
        }

        @Override
        public <V> Collection<V> newMessage() {
            return this.factory.newMessage();
        }

        @Override
        public Class<?> typeClass() {
            return this.factory.typeClass();
        }
    }

    public static class Registry
    implements NumericIdStrategy.Registry {
        public final ExplicitIdStrategy strategy;

        public Registry() {
            this(IdStrategy.DEFAULT_FLAGS, null, 0, 10, 10, 10, 10, 10);
        }

        public Registry(int initialCollectionSize, int initialMapSize, int initialEnumSize, int initialPojoSize, int initialDelegateSize) {
            this(IdStrategy.DEFAULT_FLAGS, null, 0, initialCollectionSize, initialMapSize, initialEnumSize, initialPojoSize, initialDelegateSize);
        }

        public Registry(int flags, IdStrategy primaryGroup, int groupId, int initialCollectionSize, int initialMapSize, int initialEnumSize, int initialPojoSize, int initialDelegateSize) {
            IdentityHashMap<Class<?>, RegisteredCollectionFactory> collectionMapping = ExplicitIdStrategy.newMap(initialCollectionSize);
            ArrayList<RegisteredCollectionFactory> collections = NumericIdStrategy.newList(initialCollectionSize + 1);
            IdentityHashMap mapMapping = new IdentityHashMap(initialMapSize);
            ArrayList<RegisteredMapFactory> maps = NumericIdStrategy.newList(initialMapSize);
            IdentityHashMap<Class<?>, RegisteredEnumIO> enumMapping = ExplicitIdStrategy.newMap(initialEnumSize);
            ArrayList<RegisteredEnumIO> enums = NumericIdStrategy.newList(initialEnumSize + 1);
            IdentityHashMap<Class<?>, BaseHS<?>> pojoMapping = ExplicitIdStrategy.newMap(initialPojoSize);
            ArrayList<BaseHS<?>> pojos = NumericIdStrategy.newList(initialPojoSize + 1);
            IdentityHashMap<Class<?>, NumericIdStrategy.RegisteredDelegate<?>> delegateMapping = ExplicitIdStrategy.newMap(initialDelegateSize);
            ArrayList<NumericIdStrategy.RegisteredDelegate<?>> delegates = NumericIdStrategy.newList(initialDelegateSize + 1);
            this.strategy = new ExplicitIdStrategy(flags, primaryGroup, groupId, collectionMapping, collections, mapMapping, maps, enumMapping, enums, pojoMapping, pojos, delegateMapping, delegates);
        }

        @Override
        public <T extends Collection<?>> Registry registerCollection(CollectionSchema.MessageFactory factory, int id) {
            if (id < 1) {
                throw new IllegalArgumentException("collection ids start at 1.");
            }
            if (id >= this.strategy.collections.size()) {
                NumericIdStrategy.grow(this.strategy.collections, id + 1);
            } else if (this.strategy.collections.get(id) != null) {
                throw new IllegalArgumentException("Duplicate id registration: " + id + " (" + factory.typeClass() + ")");
            }
            RegisteredCollectionFactory rf = new RegisteredCollectionFactory(id, factory);
            this.strategy.collections.set(id, rf);
            if (this.strategy.collectionMapping.put(factory.typeClass(), rf) != null) {
                throw new IllegalArgumentException("Duplicate registration for: " + factory.typeClass());
            }
            return this;
        }

        @Override
        public <T extends Map<?, ?>> Registry registerMap(MapSchema.MessageFactory factory, int id) {
            if (id < 1) {
                throw new IllegalArgumentException("map ids start at 1.");
            }
            if (id >= this.strategy.maps.size()) {
                NumericIdStrategy.grow(this.strategy.maps, id + 1);
            } else if (this.strategy.maps.get(id) != null) {
                throw new IllegalArgumentException("Duplicate id registration: " + id + " (" + factory.typeClass() + ")");
            }
            RegisteredMapFactory rf = new RegisteredMapFactory(id, factory);
            this.strategy.maps.set(id, rf);
            if (this.strategy.mapMapping.put(factory.typeClass(), rf) != null) {
                throw new IllegalArgumentException("Duplicate registration for: " + factory.typeClass());
            }
            return this;
        }

        @Override
        public <T extends Enum<T>> Registry registerEnum(Class<T> clazz, int id) {
            if (id < 1) {
                throw new IllegalArgumentException("enum ids start at 1.");
            }
            if (id >= this.strategy.enums.size()) {
                NumericIdStrategy.grow(this.strategy.enums, id + 1);
            } else if (this.strategy.enums.get(id) != null) {
                throw new IllegalArgumentException("Duplicate id registration: " + id + " (" + clazz.getName() + ")");
            }
            EnumIO<Enum<T>> eio = EnumIO.newEnumIO(clazz, this.strategy);
            RegisteredEnumIO reio = new RegisteredEnumIO(id, eio);
            this.strategy.enums.set(id, reio);
            if (this.strategy.enumMapping.put(clazz, reio) != null) {
                throw new IllegalArgumentException("Duplicate registration for: " + clazz);
            }
            return this;
        }

        @Override
        public Registry registerEnum(EnumIO<?> eio, int id) {
            if (id < 1) {
                throw new IllegalArgumentException("enum ids start at 1.");
            }
            if (id >= this.strategy.enums.size()) {
                NumericIdStrategy.grow(this.strategy.enums, id + 1);
            } else if (this.strategy.enums.get(id) != null) {
                throw new IllegalArgumentException("Duplicate id registration: " + id + " (" + eio.enumClass.getName() + ")");
            }
            RegisteredEnumIO reio = new RegisteredEnumIO(id, eio);
            this.strategy.enums.set(id, reio);
            if (this.strategy.enumMapping.put(eio.enumClass, reio) != null) {
                throw new IllegalArgumentException("Duplicate registration for: " + eio.enumClass);
            }
            return this;
        }

        @Override
        public <T> Registry registerPojo(Class<T> clazz, int id) {
            if (clazz.isInterface() || Modifier.isAbstract(clazz.getModifiers())) {
                throw new IllegalArgumentException("Not a concrete class: " + clazz);
            }
            if (id < 1) {
                throw new IllegalArgumentException("pojo ids start at 1.");
            }
            if (id >= this.strategy.pojos.size()) {
                NumericIdStrategy.grow(this.strategy.pojos, id + 1);
            } else if (this.strategy.pojos.get(id) != null) {
                throw new IllegalArgumentException("Duplicate id registration: " + id + " (" + clazz.getName() + ")");
            }
            if (this.strategy.pojoMapping.containsKey(clazz)) {
                throw new IllegalArgumentException("Duplicate registration for: " + clazz);
            }
            Lazy<T> wrapper = new Lazy<T>(id, clazz, this.strategy);
            this.strategy.pojos.set(id, wrapper);
            this.strategy.pojoMapping.put(clazz, wrapper);
            return this;
        }

        @Override
        public <T> Registry registerPojo(Schema<T> schema, Pipe.Schema<T> pipeSchema, int id) {
            if (id >= this.strategy.pojos.size()) {
                NumericIdStrategy.grow(this.strategy.pojos, id + 1);
            } else if (this.strategy.pojos.get(id) != null) {
                throw new IllegalArgumentException("Duplicate id registration: " + id + " (" + schema.typeClass().getName() + ")");
            }
            if (this.strategy.pojoMapping.containsKey(schema.typeClass())) {
                throw new IllegalArgumentException("Duplicate registration for: " + schema.typeClass());
            }
            Registered<T> wrapper = new Registered<T>(id, schema, pipeSchema, this.strategy);
            this.strategy.pojos.set(id, wrapper);
            this.strategy.pojoMapping.put(schema.typeClass(), wrapper);
            return this;
        }

        @Override
        public <T> Registry mapPojo(Class<? super T> baseClass, Class<T> implClass) {
            if (this.strategy.pojoMapping.containsKey(baseClass)) {
                throw new IllegalArgumentException("Duplicate registration for: " + baseClass);
            }
            BaseHS<?> wrapper = this.strategy.pojoMapping.get(implClass);
            if (wrapper == null) {
                throw new IllegalArgumentException("Must register the impl class first. " + implClass);
            }
            this.strategy.pojoMapping.put(baseClass, wrapper);
            return this;
        }

        @Override
        public <T> Registry registerDelegate(Delegate<T> delegate, int id) {
            if (id < 1) {
                throw new IllegalArgumentException("delegate ids start at 1.");
            }
            if (id >= this.strategy.delegates.size()) {
                NumericIdStrategy.grow(this.strategy.delegates, id + 1);
            } else if (this.strategy.delegates.get(id) != null) {
                throw new IllegalArgumentException("Duplicate id registration: " + id + " (" + delegate.typeClass() + ")");
            }
            NumericIdStrategy.RegisteredDelegate<T> rd = new NumericIdStrategy.RegisteredDelegate<T>(id, delegate, this.strategy);
            this.strategy.delegates.set(id, rd);
            if (this.strategy.delegateMapping.put(delegate.typeClass(), rd) != null) {
                throw new IllegalArgumentException("Duplicate registration for: " + delegate.typeClass());
            }
            return this;
        }
    }
}

