/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.rxjava3.internal.operators.flowable;

import io.reactivex.rxjava3.core.Flowable;
import io.reactivex.rxjava3.core.FlowableSubscriber;
import io.reactivex.rxjava3.internal.operators.flowable.AbstractFlowableWithUpstream;
import io.reactivex.rxjava3.internal.subscriptions.SubscriptionHelper;
import io.reactivex.rxjava3.internal.util.BackpressureHelper;
import io.reactivex.rxjava3.plugins.RxJavaPlugins;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

public final class FlowableCache<T>
extends AbstractFlowableWithUpstream<T, T>
implements FlowableSubscriber<T> {
    final AtomicBoolean once;
    final int capacityHint;
    final AtomicReference<CacheSubscription<T>[]> subscribers;
    static final CacheSubscription[] EMPTY = new CacheSubscription[0];
    static final CacheSubscription[] TERMINATED = new CacheSubscription[0];
    volatile long size;
    final Node<T> head;
    Node<T> tail;
    int tailOffset;
    Throwable error;
    volatile boolean done;

    public FlowableCache(Flowable<T> source, int capacityHint) {
        super(source);
        this.capacityHint = capacityHint;
        this.once = new AtomicBoolean();
        Node n = new Node(capacityHint);
        this.head = n;
        this.tail = n;
        this.subscribers = new AtomicReference<CacheSubscription[]>(EMPTY);
    }

    @Override
    protected void subscribeActual(Subscriber<? super T> t) {
        CacheSubscription<? super T> consumer = new CacheSubscription<T>(t, this);
        t.onSubscribe(consumer);
        this.add(consumer);
        if (!this.once.get() && this.once.compareAndSet(false, true)) {
            this.source.subscribe(this);
        } else {
            this.replay(consumer);
        }
    }

    boolean isConnected() {
        return this.once.get();
    }

    boolean hasSubscribers() {
        return this.subscribers.get().length != 0;
    }

    long cachedEventCount() {
        return this.size;
    }

    void add(CacheSubscription<T> consumer) {
        CacheSubscription[] next;
        CacheSubscription<T>[] current;
        do {
            if ((current = this.subscribers.get()) == TERMINATED) {
                return;
            }
            int n = current.length;
            next = new CacheSubscription[n + 1];
            System.arraycopy(current, 0, next, 0, n);
            next[n] = consumer;
        } while (!this.subscribers.compareAndSet(current, next));
    }

    void remove(CacheSubscription<T> consumer) {
        CacheSubscription[] next;
        CacheSubscription<T>[] current;
        do {
            int n;
            if ((n = (current = this.subscribers.get()).length) == 0) {
                return;
            }
            int j = -1;
            for (int i = 0; i < n; ++i) {
                if (current[i] != consumer) continue;
                j = i;
                break;
            }
            if (j < 0) {
                return;
            }
            if (n == 1) {
                next = EMPTY;
                continue;
            }
            next = new CacheSubscription[n - 1];
            System.arraycopy(current, 0, next, 0, j);
            System.arraycopy(current, j + 1, next, j, n - j - 1);
        } while (!this.subscribers.compareAndSet(current, next));
    }

    void replay(CacheSubscription<T> consumer) {
        if (consumer.getAndIncrement() != 0) {
            return;
        }
        int missed = 1;
        long index = consumer.index;
        int offset = consumer.offset;
        Node node = consumer.node;
        AtomicLong requested = consumer.requested;
        Subscriber downstream = consumer.downstream;
        int capacity = this.capacityHint;
        while (true) {
            boolean empty;
            boolean sourceDone = this.done;
            boolean bl = empty = this.size == index;
            if (sourceDone && empty) {
                consumer.node = null;
                Throwable ex = this.error;
                if (ex != null) {
                    downstream.onError(ex);
                } else {
                    downstream.onComplete();
                }
                return;
            }
            if (!empty) {
                long consumerRequested = requested.get();
                if (consumerRequested == Long.MIN_VALUE) {
                    consumer.node = null;
                    return;
                }
                if (consumerRequested != index) {
                    if (offset == capacity) {
                        node = node.next;
                        offset = 0;
                    }
                    downstream.onNext(node.values[offset]);
                    ++offset;
                    ++index;
                    continue;
                }
            }
            consumer.index = index;
            consumer.offset = offset;
            consumer.node = node;
            if ((missed = consumer.addAndGet(-missed)) == 0) break;
        }
    }

    @Override
    public void onSubscribe(Subscription s) {
        s.request(Long.MAX_VALUE);
    }

    @Override
    public void onNext(T t) {
        int tailOffset = this.tailOffset;
        if (tailOffset == this.capacityHint) {
            Node n = new Node(tailOffset);
            n.values[0] = t;
            this.tailOffset = 1;
            this.tail.next = n;
            this.tail = n;
        } else {
            this.tail.values[tailOffset] = t;
            this.tailOffset = tailOffset + 1;
        }
        ++this.size;
        for (CacheSubscription<T> consumer : this.subscribers.get()) {
            this.replay(consumer);
        }
    }

    @Override
    public void onError(Throwable t) {
        if (this.done) {
            RxJavaPlugins.onError(t);
            return;
        }
        this.error = t;
        this.done = true;
        for (CacheSubscription consumer : this.subscribers.getAndSet(TERMINATED)) {
            this.replay(consumer);
        }
    }

    @Override
    public void onComplete() {
        this.done = true;
        for (CacheSubscription consumer : this.subscribers.getAndSet(TERMINATED)) {
            this.replay(consumer);
        }
    }

    static final class Node<T> {
        final T[] values;
        volatile Node<T> next;

        Node(int capacityHint) {
            this.values = new Object[capacityHint];
        }
    }

    static final class CacheSubscription<T>
    extends AtomicInteger
    implements Subscription {
        private static final long serialVersionUID = 6770240836423125754L;
        final Subscriber<? super T> downstream;
        final FlowableCache<T> parent;
        final AtomicLong requested;
        Node<T> node;
        int offset;
        long index;

        CacheSubscription(Subscriber<? super T> downstream, FlowableCache<T> parent) {
            this.downstream = downstream;
            this.parent = parent;
            this.node = parent.head;
            this.requested = new AtomicLong();
        }

        @Override
        public void request(long n) {
            if (SubscriptionHelper.validate(n)) {
                BackpressureHelper.addCancel(this.requested, n);
                this.parent.replay(this);
            }
        }

        @Override
        public void cancel() {
            if (this.requested.getAndSet(Long.MIN_VALUE) != Long.MIN_VALUE) {
                this.parent.remove(this);
            }
        }
    }
}

