/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.persistence.sifs.configuration;

import org.infinispan.commons.configuration.Builder;
import org.infinispan.commons.configuration.ConfigurationBuilderInfo;
import org.infinispan.commons.configuration.attributes.AttributeSet;
import org.infinispan.commons.configuration.elements.ElementDefinition;
import org.infinispan.persistence.sifs.Log;
import org.infinispan.persistence.sifs.configuration.IndexConfiguration;
import org.infinispan.util.logging.LogFactory;

public class IndexConfigurationBuilder
implements Builder<IndexConfiguration>,
ConfigurationBuilderInfo {
    private static final Log log = (Log)LogFactory.getLog(IndexConfigurationBuilder.class, Log.class);
    private final AttributeSet attributes = IndexConfiguration.attributeDefinitionSet();

    public ElementDefinition getElementDefinition() {
        return IndexConfiguration.ELEMENT_DEFINITION;
    }

    public AttributeSet attributes() {
        return this.attributes;
    }

    public IndexConfigurationBuilder indexLocation(String indexLocation) {
        this.attributes.attribute(IndexConfiguration.INDEX_LOCATION).set((Object)indexLocation);
        return this;
    }

    public IndexConfigurationBuilder indexSegments(int indexSegments) {
        this.attributes.attribute(IndexConfiguration.INDEX_SEGMENTS).set((Object)indexSegments);
        return this;
    }

    public IndexConfigurationBuilder minNodeSize(int minNodeSize) {
        this.attributes.attribute(IndexConfiguration.MIN_NODE_SIZE).set((Object)minNodeSize);
        return this;
    }

    public IndexConfigurationBuilder maxNodeSize(int maxNodeSize) {
        this.attributes.attribute(IndexConfiguration.MAX_NODE_SIZE).set((Object)maxNodeSize);
        return this;
    }

    public IndexConfigurationBuilder indexQueueLength(int indexQueueLength) {
        this.attributes.attribute(IndexConfiguration.INDEX_QUEUE_LENGTH).set((Object)indexQueueLength);
        return this;
    }

    public IndexConfiguration create() {
        return new IndexConfiguration(this.attributes.protect());
    }

    public Builder<?> read(IndexConfiguration template) {
        this.attributes.read(template.attributes());
        return this;
    }

    public void validate() {
        int minNodeSize = (Integer)this.attributes.attribute(IndexConfiguration.MIN_NODE_SIZE).get();
        int maxNodeSize = (Integer)this.attributes.attribute(IndexConfiguration.MAX_NODE_SIZE).get();
        if (maxNodeSize <= 0 || maxNodeSize > Short.MAX_VALUE) {
            throw log.maxNodeSizeLimitedToShort(maxNodeSize);
        }
        if (minNodeSize < 0 || minNodeSize > maxNodeSize) {
            throw log.minNodeSizeMustBeLessOrEqualToMax(minNodeSize, maxNodeSize);
        }
    }

    public String toString() {
        return "IndexConfigurationBuilder{attributes=" + this.attributes + '}';
    }
}

