/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.impl.massindex;

import java.util.concurrent.CompletableFuture;
import org.hibernate.search.util.common.impl.Futures;
import org.infinispan.query.impl.massindex.IndexUpdater;
import org.infinispan.query.impl.massindex.MassIndexerProgressNotifier;
import org.infinispan.query.logging.Log;
import org.infinispan.util.logging.LogFactory;

public class MassIndexerProgressState {
    private static final Log LOG = (Log)LogFactory.getLog(IndexUpdater.class, Log.class);
    private final MassIndexerProgressNotifier notifier;
    private CompletableFuture<?> lastFuture = CompletableFuture.completedFuture(null);

    public MassIndexerProgressState(MassIndexerProgressNotifier notifier) {
        this.notifier = notifier;
    }

    public void addItem(Object key, Object value, CompletableFuture<?> future) {
        this.lastFuture = ((CompletableFuture)future.whenComplete((result, exception) -> {
            if (exception != null) {
                this.notifier.notifyEntityIndexingFailure(value.getClass(), key, (Throwable)exception);
            } else {
                this.notifier.notifyDocumentsAdded(1);
            }
        })).thenCombine(this.lastFuture, (ignored1, ignored2) -> null);
    }

    public void waitForAsyncCompletion() {
        try {
            Futures.unwrappedExceptionGet(this.lastFuture);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw LOG.interruptedWhileWaitingForRequestCompletion(e);
        }
    }
}

