package org.infinispan.search.mapper.log.impl;

import java.util.Locale;
import java.io.Serializable;
import javax.annotation.processing.Generated;
import org.jboss.logging.DelegatingBasicLogger;
import org.hibernate.search.engine.environment.classpath.spi.ClassLoadingException;
import org.hibernate.search.util.common.SearchException;
import java.lang.String;
import org.jboss.logging.Logger;
import java.lang.Exception;
import org.jboss.logging.BasicLogger;
import java.lang.Throwable;
import java.lang.Class;
import java.util.Arrays;


import static org.jboss.logging.Logger.Level.ERROR;

/**
 * Warning this class consists of generated code.
 */
@Generated(value = "org.jboss.logging.processor.generator.model.MessageLoggerImplementor", date = "2024-03-13T07:57:42-0400")
public class Log_$logger extends DelegatingBasicLogger implements Log, BasicLogger, Serializable {
    private static final long serialVersionUID = 1L;
    private static final String FQCN = Log_$logger.class.getName();
    public Log_$logger(final Logger log) {
        super(log);
    }
    private static final Locale LOCALE = Locale.ROOT;
    protected Locale getLoggingLocale() {
        return LOCALE;
    }
    protected String errorRetrievingTypeModel$str() {
        return "ISPN014501: Exception while retrieving the type model for '%1$s'.";
    }
    @Override
    public final SearchException errorRetrievingTypeModel(final Class<?> clazz, final Exception cause) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), errorRetrievingTypeModel$str(), new org.hibernate.search.util.common.logging.impl.ClassFormatter(clazz)), cause);
        _copyStackTraceMinusOne(result);
        return result;
    }
    private static void _copyStackTraceMinusOne(final Throwable e) {
        final StackTraceElement[] st = e.getStackTrace();
        e.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
    }
    protected String multipleEntityTypesWithSameName$str() {
        return "ISPN014502: Multiple entity types configured with the same name '%1$s': '%2$s', '%3$s'";
    }
    @Override
    public final SearchException multipleEntityTypesWithSameName(final String entityName, final Class<?> previousType, final Class<?> type) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), multipleEntityTypesWithSameName$str(), entityName, previousType, type));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String namedTypesNotSupported$str() {
        return "ISPN014503: Infinispan Search Mapper does not support named types. The type with name '%1$s' does not exist.";
    }
    @Override
    public final SearchException namedTypesNotSupported(final String name) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), namedTypesNotSupported$str(), name));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String unableToLoadTheClass$str() {
        return "ISPN014504: Unable to load class [%1$s]";
    }
    @Override
    public final ClassLoadingException unableToLoadTheClass(final String className, final Throwable cause) {
        final ClassLoadingException result = new ClassLoadingException(String.format(getLoggingLocale(), unableToLoadTheClass$str(), className), cause);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String invalidEntityName$str() {
        return "ISPN014505: Unknown entity name: '%1$s'.";
    }
    @Override
    public final SearchException invalidEntityName(final String entityName) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), invalidEntityName$str(), entityName));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String invalidEntitySuperType$str() {
        return "ISPN014506: Invalid type for '%1$s': the entity type must extend '%2$s', but entity type '%3$s' does not.";
    }
    @Override
    public final SearchException invalidEntitySuperType(final String entityName, final Class<?> expectedSuperType, final Class<?> actualJavaType) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), invalidEntitySuperType$str(), entityName, new org.hibernate.search.util.common.logging.impl.ClassFormatter(expectedSuperType), new org.hibernate.search.util.common.logging.impl.ClassFormatter(actualJavaType)));
        _copyStackTraceMinusOne(result);
        return result;
    }
    @Override
    public final void errorProcessingIndexingOperation(final Throwable cause) {
        super.log.logf(FQCN, ERROR, cause, errorProcessingIndexingOperation$str());
    }
    protected String errorProcessingIndexingOperation$str() {
        return "ISPN014507: Error processing indexing operation.";
    }
}
