/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.clustered.commandworkers;

import java.io.IOException;
import java.util.BitSet;
import org.hibernate.search.exception.SearchException;
import org.hibernate.search.query.engine.spi.DocumentExtractor;
import org.infinispan.query.clustered.QueryResponse;
import org.infinispan.query.clustered.commandworkers.CQWorker;

final class CQLazyFetcher
extends CQWorker {
    CQLazyFetcher() {
    }

    @Override
    QueryResponse perform(BitSet segments) {
        DocumentExtractor extractor = this.getQueryBox().get(this.queryId);
        Object value = this.extractValue(extractor, this.docIndex);
        return new QueryResponse(value);
    }

    Object extractValue(DocumentExtractor extractor, int docIndex) {
        Object[] projection;
        try {
            projection = extractor.extract(docIndex).getProjection();
        }
        catch (IOException e) {
            throw new SearchException("Error while extracting projection", (Throwable)e);
        }
        if (projection == null) {
            Object key = this.extractKey(extractor, docIndex);
            return this.cache.get(key);
        }
        return projection;
    }
}

