/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.impl;

import java.util.Map;
import java.util.Set;
import org.hibernate.search.jmx.StatisticsInfoMBean;
import org.hibernate.search.spi.SearchIntegrator;
import org.infinispan.jmx.annotations.MBean;
import org.infinispan.jmx.annotations.ManagedAttribute;
import org.infinispan.jmx.annotations.ManagedOperation;
import org.infinispan.query.Indexer;
import org.infinispan.security.AuthorizationPermission;
import org.infinispan.security.impl.AuthorizationHelper;

@MBean(objectName="Statistics", description="Statistics for index based query")
public final class InfinispanQueryStatisticsInfo
implements StatisticsInfoMBean {
    private final SearchIntegrator searchIntegrator;
    private final Indexer massIndexer;
    private final QueryStatistics queryStatistics = new QueryStatistics();
    private final IndexStatistics indexStatistics = new IndexStatistics();
    private final AuthorizationHelper authorizationHelper;

    InfinispanQueryStatisticsInfo(SearchIntegrator searchIntegrator, Indexer massIndexer, AuthorizationHelper authorizationHelper) {
        this.searchIntegrator = searchIntegrator;
        this.massIndexer = massIndexer;
        this.authorizationHelper = authorizationHelper;
    }

    @ManagedOperation
    public void clear() {
        this.authorizationHelper.checkPermission(AuthorizationPermission.ADMIN);
        this.searchIntegrator.getStatistics().clear();
    }

    @ManagedAttribute
    public long getSearchQueryExecutionCount() {
        return this.searchIntegrator.getStatistics().getSearchQueryExecutionCount();
    }

    @ManagedAttribute
    public long getSearchQueryTotalTime() {
        return this.searchIntegrator.getStatistics().getSearchQueryTotalTime();
    }

    @ManagedAttribute
    public long getSearchQueryExecutionMaxTime() {
        return this.searchIntegrator.getStatistics().getSearchQueryExecutionMaxTime();
    }

    @ManagedAttribute
    public long getSearchQueryExecutionAvgTime() {
        return this.searchIntegrator.getStatistics().getSearchQueryExecutionAvgTime();
    }

    @ManagedAttribute
    public String getSearchQueryExecutionMaxTimeQueryString() {
        return this.searchIntegrator.getStatistics().getSearchQueryExecutionMaxTimeQueryString();
    }

    @ManagedAttribute
    public long getObjectLoadingTotalTime() {
        return this.searchIntegrator.getStatistics().getObjectLoadingTotalTime();
    }

    @ManagedAttribute
    public long getObjectLoadingExecutionMaxTime() {
        return this.searchIntegrator.getStatistics().getObjectLoadingExecutionMaxTime();
    }

    @ManagedAttribute
    public long getObjectLoadingExecutionAvgTime() {
        return this.searchIntegrator.getStatistics().getObjectLoadingExecutionAvgTime();
    }

    @ManagedAttribute
    public long getObjectsLoadedCount() {
        return this.searchIntegrator.getStatistics().getObjectsLoadedCount();
    }

    @ManagedAttribute(writable=true)
    public boolean isStatisticsEnabled() {
        return this.searchIntegrator.getStatistics().isStatisticsEnabled();
    }

    public void setStatisticsEnabled(boolean isStatisticsEnabled) {
        this.searchIntegrator.getStatistics().setStatisticsEnabled(isStatisticsEnabled);
    }

    @ManagedAttribute
    public String getSearchVersion() {
        return this.searchIntegrator.getStatistics().getSearchVersion();
    }

    @ManagedAttribute
    public Set<String> getIndexedClassNames() {
        return this.searchIntegrator.getStatistics().getIndexedClassNames();
    }

    @ManagedOperation
    public int getNumberOfIndexedEntities(String entity) {
        return this.searchIntegrator.getStatistics().getNumberOfIndexedEntities(entity);
    }

    @ManagedOperation
    public Map<String, Integer> indexedEntitiesCount() {
        return this.searchIntegrator.getStatistics().indexedEntitiesCount();
    }

    @ManagedOperation
    public long getIndexSize(String indexName) {
        return this.searchIntegrator.getStatistics().getIndexSize(indexName);
    }

    @ManagedOperation
    public Map<String, Long> indexSizes() {
        return this.searchIntegrator.getStatistics().indexSizes();
    }

    public QueryStatistics getQueryStatistics() {
        return this.queryStatistics;
    }

    public IndexStatistics getIndexStatistics() {
        return this.indexStatistics;
    }

    public final class QueryStatistics {
        public long getSearchQueryExecutionCount() {
            return InfinispanQueryStatisticsInfo.this.getSearchQueryExecutionCount();
        }

        public long getSearchQueryTotalTime() {
            return InfinispanQueryStatisticsInfo.this.getSearchQueryTotalTime();
        }

        public long getSearchQueryExecutionMaxTime() {
            return InfinispanQueryStatisticsInfo.this.getSearchQueryExecutionMaxTime();
        }

        public long getSearchQueryExecutionAvgTime() {
            return InfinispanQueryStatisticsInfo.this.getSearchQueryExecutionAvgTime();
        }

        public String getSearchQueryExecutionMaxTimeQueryString() {
            return InfinispanQueryStatisticsInfo.this.getSearchQueryExecutionMaxTimeQueryString();
        }

        public long getObjectLoadingTotalTime() {
            return InfinispanQueryStatisticsInfo.this.getObjectLoadingTotalTime();
        }

        public long getObjectLoadingExecutionMaxTime() {
            return InfinispanQueryStatisticsInfo.this.getObjectLoadingExecutionMaxTime();
        }

        public long getObjectLoadingExecutionAvgTime() {
            return InfinispanQueryStatisticsInfo.this.getObjectLoadingExecutionAvgTime();
        }

        public long getObjectsLoadedCount() {
            return InfinispanQueryStatisticsInfo.this.getObjectsLoadedCount();
        }
    }

    public final class IndexStatistics {
        public Set<String> getIndexedClassNames() {
            return InfinispanQueryStatisticsInfo.this.getIndexedClassNames();
        }

        public int getNumberOfIndexedEntities(String entity) {
            return InfinispanQueryStatisticsInfo.this.getNumberOfIndexedEntities(entity);
        }

        public Map<String, Integer> getIndexedEntitiesCount() {
            return InfinispanQueryStatisticsInfo.this.indexedEntitiesCount();
        }

        public Map<String, Long> getIndexSizes() {
            return InfinispanQueryStatisticsInfo.this.indexSizes();
        }

        public boolean getReindexing() {
            return InfinispanQueryStatisticsInfo.this.massIndexer.isRunning();
        }
    }
}

