/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.impl.massindex;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.infinispan.commons.time.TimeService;
import org.infinispan.query.logging.Log;
import org.infinispan.util.logging.LogFactory;

public class MassIndexerProgressMonitor {
    private static final Log log = (Log)LogFactory.getLog(MassIndexerProgressMonitor.class, Log.class);
    private final AtomicLong documentsDoneCounter = new AtomicLong();
    private volatile long startTime;
    private final int logAfterNumberOfDocuments;
    private final TimeService timeService;

    public MassIndexerProgressMonitor(TimeService timeService) {
        this(50, timeService);
    }

    public MassIndexerProgressMonitor(int logAfterNumberOfDocuments, TimeService timeService) {
        this.logAfterNumberOfDocuments = logAfterNumberOfDocuments;
        this.timeService = timeService;
    }

    public void documentsAdded(long increment) {
        long current = this.documentsDoneCounter.addAndGet(increment);
        if (current == increment) {
            this.startTime = this.timeService.time();
        }
        if (current % (long)this.getStatusMessagePeriod() == 0L) {
            this.printStatusMessage(this.startTime, current);
        }
    }

    public void indexingCompleted() {
        log.indexingEntitiesCompleted(this.documentsDoneCounter.get());
    }

    protected int getStatusMessagePeriod() {
        return this.logAfterNumberOfDocuments;
    }

    protected void printStatusMessage(long startTime, long doneCount) {
        log.indexingDocumentsCompleted(doneCount, this.timeService.timeDuration(startTime, TimeUnit.MILLISECONDS));
    }
}

