/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.concurrent;

import java.util.concurrent.Future;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.hibernate.search.backend.lucene.work.spi.LuceneWorkExecutorProvider;
import org.hibernate.search.engine.common.execution.spi.SimpleScheduledExecutor;
import org.infinispan.factories.AbstractComponentFactory;
import org.infinispan.factories.AutoInstantiableFactory;
import org.infinispan.factories.annotations.DefaultFactoryFor;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.factories.scopes.Scope;
import org.infinispan.factories.scopes.Scopes;
import org.infinispan.util.concurrent.BlockingManager;

@Scope(value=Scopes.GLOBAL)
@DefaultFactoryFor(classes={LuceneWorkExecutorProvider.class})
public class InfinispanIndexingExecutorProvider
extends AbstractComponentFactory
implements AutoInstantiableFactory,
LuceneWorkExecutorProvider {
    @Inject
    BlockingManager blockingManager;

    public Object construct(String name) {
        return new InfinispanIndexingExecutorProvider();
    }

    public SimpleScheduledExecutor writeExecutor(LuceneWorkExecutorProvider.Context context) {
        return InfinispanIndexingExecutorProvider.writeExecutor(this.blockingManager);
    }

    public static SimpleScheduledExecutor writeExecutor(BlockingManager blockingManager) {
        return new InfinispanScheduledExecutor(blockingManager);
    }

    static final class InfinispanScheduledExecutor
    implements SimpleScheduledExecutor {
        private final BlockingManager blockingManager;

        public InfinispanScheduledExecutor(BlockingManager blockingManager) {
            this.blockingManager = blockingManager;
        }

        public Future<?> submit(Runnable task) {
            return this.blockingManager.runBlocking(task, (Object)this).toCompletableFuture();
        }

        public ScheduledFuture<?> schedule(Runnable command, long delay, TimeUnit unit) {
            return this.blockingManager.scheduleRunBlocking(command, delay, unit, (Object)this);
        }

        public void shutdownNow() {
        }

        public boolean isBlocking() {
            return false;
        }
    }
}

