/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.remote.impl;

import java.util.Collection;
import java.util.Set;
import java.util.concurrent.locks.StampedLock;
import org.hibernate.search.engine.reporting.FailureHandler;
import org.infinispan.AdvancedCache;
import org.infinispan.Cache;
import org.infinispan.commons.dataconversion.MediaType;
import org.infinispan.commons.logging.LogFactory;
import org.infinispan.configuration.cache.IndexingConfiguration;
import org.infinispan.encoding.DataConversion;
import org.infinispan.protostream.SerializationContext;
import org.infinispan.query.impl.EntityLoader;
import org.infinispan.query.remote.impl.ProtobufMetadataManagerImpl;
import org.infinispan.query.remote.impl.logging.Log;
import org.infinispan.query.remote.impl.mapping.SerializationContextSearchMapping;
import org.infinispan.query.remote.impl.util.LazyRef;
import org.infinispan.search.mapper.mapping.SearchIndexedEntity;
import org.infinispan.search.mapper.mapping.SearchMapping;
import org.infinispan.search.mapper.mapping.SearchMappingBuilder;
import org.infinispan.search.mapper.mapping.SearchMappingCommonBuilding;
import org.infinispan.search.mapper.scope.SearchScope;
import org.infinispan.search.mapper.session.SearchSession;
import org.infinispan.search.mapper.work.SearchIndexer;

public class LazySearchMapping
implements SearchMapping {
    private static final Log log = (Log)LogFactory.getLog(LazySearchMapping.class, Log.class);
    private final Cache<?, ?> cache;
    private final ProtobufMetadataManagerImpl protobufMetadataManager;
    private final SearchMappingCommonBuilding commonBuilding;
    private final EntityLoader<?> entityLoader;
    private final SerializationContext serCtx;
    private LazyRef<SearchMapping> searchMappingRef = new LazyRef<SearchMapping>(this::createMapping);
    private final StampedLock stampedLock = new StampedLock();

    public LazySearchMapping(SearchMappingCommonBuilding commonBuilding, EntityLoader<?> entityLoader, SerializationContext serCtx, AdvancedCache<?, ?> cache, ProtobufMetadataManagerImpl protobufMetadataManager) {
        this.commonBuilding = commonBuilding;
        this.entityLoader = entityLoader;
        this.serCtx = serCtx;
        this.cache = cache;
        this.protobufMetadataManager = protobufMetadataManager;
    }

    public <E> SearchScope<E> scope(Collection<? extends Class<? extends E>> types) {
        return this.mapping().scope(types);
    }

    public SearchScope<?> scopeAll() {
        return this.mapping().scopeAll();
    }

    public FailureHandler getFailureHandler() {
        return this.mapping().getFailureHandler();
    }

    public void close() {
        this.mapping().close();
    }

    public boolean isClose() {
        return this.mapping().isClose();
    }

    public SearchSession getMappingSession() {
        return this.mapping().getMappingSession();
    }

    public SearchIndexer getSearchIndexer() {
        return this.mapping().getSearchIndexer();
    }

    public SearchIndexedEntity indexedEntity(Class<?> entityType) {
        return this.mapping().indexedEntity(entityType);
    }

    public SearchIndexedEntity indexedEntity(String entityName) {
        return this.mapping().indexedEntity(entityName);
    }

    public Collection<? extends SearchIndexedEntity> allIndexedEntities() {
        return this.mapping().allIndexedEntities();
    }

    public Set<String> allIndexedEntityNames() {
        return this.mapping().allIndexedEntityNames();
    }

    public Set<Class<?>> allIndexedEntityJavaClasses() {
        return this.mapping().allIndexedEntityJavaClasses();
    }

    public Class<?> toConvertedEntityJavaClass(Object value) {
        return this.mapping().toConvertedEntityJavaClass(value);
    }

    public void reload() {
        long stamp = this.stampedLock.writeLock();
        try {
            this.searchMappingRef.get().close();
            this.searchMappingRef = new LazyRef<SearchMapping>(this::createMapping);
        }
        finally {
            this.stampedLock.unlockWrite(stamp);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SearchMapping mapping() {
        long stamp = this.stampedLock.tryOptimisticRead();
        SearchMapping searchMapping = this.searchMappingRef.get();
        if (!this.stampedLock.validate(stamp)) {
            stamp = this.stampedLock.readLock();
            try {
                searchMapping = this.searchMappingRef.get();
            }
            finally {
                this.stampedLock.unlockRead(stamp);
            }
        }
        return searchMapping;
    }

    private SearchMapping createMapping() {
        IndexingConfiguration indexingConfiguration = this.cache.getCacheConfiguration().indexing();
        Set indexedEntityTypes = indexingConfiguration.indexedEntityTypes();
        DataConversion valueDataConversion = this.cache.getAdvancedCache().getValueDataConversion();
        SearchMapping searchMapping = null;
        if (this.commonBuilding != null) {
            SearchMappingBuilder builder = SerializationContextSearchMapping.createBuilder(this.commonBuilding, this.entityLoader, indexedEntityTypes, this.serCtx);
            SearchMapping searchMapping2 = searchMapping = builder != null ? builder.build() : null;
        }
        if (indexingConfiguration.enabled() && valueDataConversion.getStorageMediaType().match(MediaType.APPLICATION_PROTOSTREAM)) {
            Set knownTypes = this.protobufMetadataManager.getSerializationContext().getGenericDescriptors().keySet();
            for (String typeName : indexedEntityTypes) {
                if (!knownTypes.contains(typeName)) {
                    if (searchMapping != null) {
                        searchMapping.close();
                    }
                    throw log.unknownType(typeName);
                }
                if (searchMapping != null && searchMapping.indexedEntity(typeName) != null) continue;
                if (searchMapping != null) {
                    searchMapping.close();
                }
                throw log.typeNotIndexed(typeName);
            }
        }
        return searchMapping;
    }
}

