/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.remote.impl.indexing;

import org.infinispan.api.annotations.indexing.option.Structure;
import org.infinispan.api.annotations.indexing.option.TermVector;
import org.infinispan.api.annotations.indexing.option.VectorSimilarity;
import org.infinispan.protostream.descriptors.EnumValueDescriptor;
import org.infinispan.protostream.descriptors.FieldDescriptor;

public final class FieldMapping {
    private final FieldDescriptor fieldDescriptor;
    private final String name;
    private final boolean searchable;
    private final boolean projectable;
    private final boolean aggregable;
    private final boolean sortable;
    private final String indexNullAs;
    private final String analyzer;
    private final String normalizer;
    private final String searchAnalyzer;
    private final Boolean norms;
    private final TermVector termVector;
    private final Integer decimalScale;
    private final Integer dimension;
    private final VectorSimilarity similarity;
    private final Integer beamWidth;
    private final Integer maxConnection;
    private final Integer includeDepth;
    private final Structure structure;
    private volatile boolean isInitialized = false;
    private Object indexNullAsObj;

    private FieldMapping(FieldDescriptor fieldDescriptor, String name, boolean searchable, boolean projectable, boolean aggregable, boolean sortable, String indexNullAs, String analyzer, String normalizer, String searchAnalyzer, Boolean norms, TermVector termVector, Integer decimalScale, Integer dimension, VectorSimilarity similarity, Integer beamWidth, Integer maxConnection, Integer includeDepth, Structure structure) {
        if (name == null) {
            throw new IllegalArgumentException("name argument cannot be null");
        }
        if (fieldDescriptor == null) {
            throw new IllegalArgumentException("fieldDescriptor argument cannot be null");
        }
        this.fieldDescriptor = fieldDescriptor;
        this.name = name;
        this.searchable = searchable;
        this.projectable = projectable;
        this.aggregable = aggregable;
        this.sortable = sortable;
        this.indexNullAs = indexNullAs;
        this.analyzer = analyzer;
        this.normalizer = normalizer;
        this.searchAnalyzer = searchAnalyzer;
        this.norms = norms;
        this.termVector = termVector;
        this.decimalScale = decimalScale;
        this.dimension = dimension;
        this.similarity = similarity;
        this.beamWidth = beamWidth;
        this.maxConnection = maxConnection;
        this.includeDepth = includeDepth;
        this.structure = structure;
    }

    public static Builder make(FieldDescriptor fieldDescriptor, String name, boolean searchable, boolean projectable, boolean aggregable, boolean sortable) {
        return new Builder(fieldDescriptor, name, searchable, projectable, aggregable, sortable);
    }

    public String name() {
        return this.name;
    }

    public boolean searchable() {
        return this.searchable;
    }

    public boolean projectable() {
        return this.projectable;
    }

    public boolean aggregable() {
        return this.aggregable;
    }

    public boolean sortable() {
        return this.sortable;
    }

    public String analyzer() {
        return this.analyzer;
    }

    public String normalizer() {
        return this.normalizer;
    }

    public boolean analyzed() {
        return this.analyzer != null;
    }

    public boolean normalized() {
        return this.normalizer != null;
    }

    public Object indexNullAs() {
        this.init();
        return this.indexNullAsObj;
    }

    public Boolean norms() {
        return this.norms;
    }

    public String searchAnalyzer() {
        return this.searchAnalyzer;
    }

    public TermVector termVector() {
        return this.termVector;
    }

    public Integer decimalScale() {
        return this.decimalScale;
    }

    public Integer dimension() {
        return this.dimension;
    }

    public VectorSimilarity similarity() {
        return this.similarity;
    }

    public Integer beamWidth() {
        return this.beamWidth;
    }

    public Integer maxConnection() {
        return this.maxConnection;
    }

    public Integer includeDepth() {
        return this.includeDepth;
    }

    public Structure structure() {
        return this.structure;
    }

    private void init() {
        if (!this.isInitialized) {
            if (this.fieldDescriptor.getType() == null) {
                throw new IllegalStateException("FieldDescriptors are not fully initialised!");
            }
            this.indexNullAsObj = this.parseIndexNullAs();
            this.isInitialized = true;
        }
    }

    public Object parseIndexNullAs() {
        if (this.indexNullAs != null) {
            switch (this.fieldDescriptor.getType()) {
                case DOUBLE: {
                    return Double.parseDouble(this.indexNullAs);
                }
                case FLOAT: {
                    return Float.valueOf(Float.parseFloat(this.indexNullAs));
                }
                case INT64: 
                case UINT64: 
                case FIXED64: 
                case SFIXED64: 
                case SINT64: {
                    return Long.parseLong(this.indexNullAs);
                }
                case INT32: 
                case FIXED32: 
                case UINT32: 
                case SFIXED32: 
                case SINT32: {
                    return Integer.parseInt(this.indexNullAs);
                }
                case ENUM: {
                    EnumValueDescriptor enumVal = this.fieldDescriptor.getEnumType().findValueByName(this.indexNullAs);
                    if (enumVal == null) {
                        throw new IllegalArgumentException("Enum value not found : " + this.indexNullAs);
                    }
                    return enumVal.getNumber();
                }
                case BOOL: {
                    return Boolean.valueOf(this.indexNullAs);
                }
            }
        }
        return this.indexNullAs;
    }

    public String toString() {
        return "FieldMapping{fieldDescriptor=" + String.valueOf(this.fieldDescriptor) + ", name='" + this.name + "', searchable=" + this.searchable + ", projectable=" + this.projectable + ", aggregable=" + this.aggregable + ", sortable=" + this.sortable + ", indexNullAs='" + this.indexNullAs + "', analyzer='" + this.analyzer + "', normalizer='" + this.normalizer + "', searchAnalyzer='" + this.searchAnalyzer + "', norms=" + this.norms + ", termVector=" + String.valueOf(this.termVector) + ", decimalScale=" + this.decimalScale + ", dimension=" + this.dimension + ", similarity=" + String.valueOf(this.similarity) + ", beamWidth=" + this.beamWidth + ", maxConnection=" + this.maxConnection + ", includeDepth=" + this.includeDepth + ", structure=" + String.valueOf(this.structure) + "}";
    }

    public static class Builder {
        private final FieldDescriptor fieldDescriptor;
        private final String name;
        private final boolean searchable;
        private final boolean projectable;
        private final boolean aggregable;
        private final boolean sortable;
        private String indexNullAs;
        private String analyzer;
        private String normalizer;
        private String searchAnalyzer;
        private Boolean norms;
        private TermVector termVector;
        private Integer decimalScale;
        private Integer dimension;
        private VectorSimilarity similarity;
        private Integer beamWidth;
        private Integer maxConnection;
        private Integer includeDepth;
        private Structure structure;

        private Builder(FieldDescriptor fieldDescriptor, String name, boolean searchable, boolean projectable, boolean aggregable, boolean sortable) {
            this.fieldDescriptor = fieldDescriptor;
            this.name = name;
            this.searchable = searchable;
            this.projectable = projectable;
            this.aggregable = aggregable;
            this.sortable = sortable;
            this.indexNullAs = this.indexNullAs;
        }

        public Builder indexNullAs(String indexNullAs) {
            this.indexNullAs = indexNullAs;
            return this;
        }

        public Builder analyzer(String analyzer) {
            this.analyzer = analyzer;
            return this;
        }

        public Builder keyword(String normalizer, boolean norms) {
            this.normalizer = normalizer;
            this.norms = norms;
            return this;
        }

        public Builder text(String analyzer, String searchAnalyzer, boolean norms, TermVector termVector) {
            this.analyzer = analyzer;
            this.searchAnalyzer = searchAnalyzer;
            this.norms = norms;
            this.termVector = termVector;
            return this;
        }

        public Builder decimalScale(int decimalScale) {
            this.decimalScale = decimalScale;
            return this;
        }

        public Builder vector(int dimension, VectorSimilarity similarity, int beamWidth, int maxConnection) {
            this.dimension = dimension;
            this.similarity = similarity;
            this.beamWidth = beamWidth;
            this.maxConnection = maxConnection;
            return this;
        }

        public Builder embedded(int includeDepth, Structure structure) {
            this.includeDepth = includeDepth;
            this.structure = structure;
            return this;
        }

        public FieldMapping build() {
            return new FieldMapping(this.fieldDescriptor, this.name, this.searchable, this.projectable, this.aggregable, this.sortable, this.indexNullAs, this.analyzer, this.normalizer, this.searchAnalyzer, this.norms, this.termVector, this.decimalScale, this.dimension, this.similarity, this.beamWidth, this.maxConnection, this.includeDepth, this.structure);
        }
    }
}

