/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.hotrod.configuration;

import org.infinispan.commons.configuration.Builder;
import org.infinispan.server.hotrod.configuration.BooleanElementConfigurationBuilder;
import org.infinispan.server.hotrod.configuration.PolicyConfiguration;
import org.infinispan.server.hotrod.configuration.SaslConfigurationBuilder;

public class PolicyConfigurationBuilder
implements Builder<PolicyConfiguration> {
    private BooleanElementConfigurationBuilder forwardSecrecy;
    private BooleanElementConfigurationBuilder noActive;
    private BooleanElementConfigurationBuilder noAnonymous;
    private BooleanElementConfigurationBuilder noDictionary;
    private BooleanElementConfigurationBuilder noPlainText;
    private BooleanElementConfigurationBuilder passCredentials;

    PolicyConfigurationBuilder(SaslConfigurationBuilder sasl) {
        this.forwardSecrecy = new BooleanElementConfigurationBuilder("forward-secrecy", sasl, "javax.security.sasl.policy.forward");
        this.noActive = new BooleanElementConfigurationBuilder("no-active", sasl, "javax.security.sasl.policy.noactive");
        this.noAnonymous = new BooleanElementConfigurationBuilder("no-anonymous", sasl, "javax.security.sasl.policy.noanonymous");
        this.noDictionary = new BooleanElementConfigurationBuilder("no-dictionary", sasl, "javax.security.sasl.policy.nodictionary");
        this.noPlainText = new BooleanElementConfigurationBuilder("no-plain-text", sasl, "javax.security.sasl.policy.noplaintext");
        this.passCredentials = new BooleanElementConfigurationBuilder("pass-credentials", sasl, "javax.security.sasl.policy.credentials");
    }

    public BooleanElementConfigurationBuilder forwardSecrecy() {
        return this.forwardSecrecy;
    }

    public BooleanElementConfigurationBuilder noActive() {
        return this.noActive;
    }

    public BooleanElementConfigurationBuilder noAnonymous() {
        return this.noAnonymous;
    }

    public BooleanElementConfigurationBuilder noDictionary() {
        return this.noDictionary;
    }

    public BooleanElementConfigurationBuilder noPlainText() {
        return this.noPlainText;
    }

    public BooleanElementConfigurationBuilder passCredentials() {
        return this.passCredentials;
    }

    public void validate() {
    }

    public PolicyConfiguration create() {
        return new PolicyConfiguration(this.forwardSecrecy.create(), this.noActive.create(), this.noAnonymous.create(), this.noDictionary.create(), this.noPlainText.create(), this.passCredentials.create());
    }

    public PolicyConfigurationBuilder read(PolicyConfiguration template) {
        this.forwardSecrecy.read(template.forwardSecrecy());
        this.noActive.read(template.noActive());
        this.noAnonymous.read(template.noAnonymous());
        this.noDictionary.read(template.noDictionary());
        this.noPlainText.read(template.noPlainText());
        this.passCredentials.read(template.passCredentials());
        return this;
    }
}

