/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.memcached;

import java.util.Objects;
import org.infinispan.server.memcached.MemcachedOperation;
import org.infinispan.server.memcached.MemcachedParameters;
import org.infinispan.server.memcached.RequestHeader;

class OperationContext {
    final RequestHeader header;
    final MemcachedParameters parameters;
    final byte[] key;
    final byte[] value;

    OperationContext(RequestHeader header, MemcachedParameters parameters, byte[] key, byte[] value) {
        this.header = Objects.requireNonNull(header);
        this.parameters = parameters;
        this.key = key;
        this.value = value;
    }

    boolean isNoReply() {
        return this.parameters != null && this.parameters.noReply;
    }

    boolean isOperation(MemcachedOperation operation) {
        return this.header.operation == operation;
    }
}

