/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.memcached;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import java.nio.charset.StandardCharsets;
import java.util.List;
import org.infinispan.server.core.ProtocolDetector;
import org.infinispan.server.core.ProtocolServer;
import org.infinispan.server.core.logging.Log;
import org.infinispan.server.core.transport.AccessControlFilter;
import org.infinispan.server.memcached.MemcachedServer;
import org.infinispan.server.memcached.configuration.MemcachedProtocol;

public class MemcachedTextDetector
extends ProtocolDetector {
    public static final String NAME = "memcached-text-detector";
    private final MemcachedServer server;

    public MemcachedTextDetector(MemcachedServer server) {
        super((ProtocolServer)server);
        this.server = server;
    }

    public String getName() {
        return NAME;
    }

    protected void decode(ChannelHandlerContext ctx, ByteBuf in, List<Object> out) {
        if (in.readableBytes() < 4) {
            return;
        }
        int i = in.readerIndex();
        CharSequence handshake = in.getCharSequence(i, 4, StandardCharsets.US_ASCII);
        if ("set ".contentEquals(handshake)) {
            this.installHandler(ctx);
        }
        ctx.pipeline().remove((ChannelHandler)this);
    }

    private void installHandler(ChannelHandlerContext ctx) {
        this.trimPipeline(ctx);
        ctx.pipeline().addLast(new ChannelHandler[]{this.server.getInitializer(MemcachedProtocol.TEXT)});
        Log.SERVER.tracef("Detected Memcached text connection %s", (Object)ctx);
        ctx.pipeline().fireUserEventTriggered((Object)AccessControlFilter.EVENT);
    }
}

